/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.ModelWithRanges;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelWithRangesTest {
    @Test(description="test model with @ApiModelProperty.allowableValues")
    public void modelWithRangesTest() {
        Map properties = ((Model)ModelConverters.getInstance().read(ModelWithRanges.class).get("ModelWithRanges")).getProperties();
        IntegerProperty inclusiveRange = (IntegerProperty)properties.get("inclusiveRange");
        Assert.assertEquals((Object)inclusiveRange.getMinimum(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)inclusiveRange.getMaximum(), (Object)new BigDecimal(5));
        Assert.assertNull((Object)inclusiveRange.getExclusiveMaximum());
        Assert.assertNull((Object)inclusiveRange.getExclusiveMinimum());
        IntegerProperty exclusiveRange = (IntegerProperty)properties.get("exclusiveRange");
        Assert.assertEquals((Object)exclusiveRange.getMinimum(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)exclusiveRange.getMaximum(), (Object)new BigDecimal(5));
        Assert.assertEquals((Boolean)exclusiveRange.getExclusiveMinimum(), (Boolean)Boolean.TRUE);
        Assert.assertEquals((Boolean)exclusiveRange.getExclusiveMaximum(), (Boolean)Boolean.TRUE);
        IntegerProperty positiveInfinityRange = (IntegerProperty)properties.get("positiveInfinityRange");
        Assert.assertEquals((Object)positiveInfinityRange.getMinimum(), (Object)new BigDecimal(1.0));
        Assert.assertNull((Object)positiveInfinityRange.getMaximum());
        Assert.assertNull((Object)positiveInfinityRange.getExclusiveMaximum());
        Assert.assertNull((Object)positiveInfinityRange.getExclusiveMinimum());
        IntegerProperty negativeInfinityRange = (IntegerProperty)properties.get("negativeInfinityRange");
        Assert.assertNull((Object)negativeInfinityRange.getMinimum());
        Assert.assertEquals((Object)negativeInfinityRange.getMaximum(), (Object)new BigDecimal(5.0));
        Assert.assertNull((Object)negativeInfinityRange.getExclusiveMaximum());
        Assert.assertNull((Object)negativeInfinityRange.getExclusiveMinimum());
        StringProperty stringValues = (StringProperty)properties.get("stringValues");
        Assert.assertEquals((Collection)stringValues.getEnum(), Arrays.asList("str1", "str2"));
        DoubleProperty doubleValues = (DoubleProperty)properties.get("doubleValues");
        Assert.assertEquals((Object)doubleValues.getMinimum(), (Object)new BigDecimal("1.0"));
        Assert.assertEquals((Object)doubleValues.getMaximum(), (Object)new BigDecimal("8.0"));
        Assert.assertEquals((Boolean)doubleValues.getExclusiveMaximum(), (Boolean)Boolean.TRUE);
        Assert.assertNull((Object)doubleValues.getExclusiveMinimum());
    }
}

