/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiParam;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParameterProcessorTest {
    private static final String TEST_PATTERN_REGXP = "^[A-Z]+$";

    private void parametrizedMethod(@ApiParam(name="paramName1", value="paramValue1", defaultValue="value1", required=true, allowableValues="one, two, three, ") @PathParam(value="param1") String arg1, @ApiParam(name="paramName2", access="test") @DefaultValue(value="10") @QueryParam(value="param2") List<Integer> arg2, @Context String arg3, @ApiParam(name="paramName4", hidden=true) @QueryParam(value="hiddenParam") String arg4, @ApiParam(name="paramName4") Integer arg5) {
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="paramName1", value="paramValue1", dataType="string", paramType="path", allowMultiple=true, allowableValues=",,,"), @ApiImplicitParam(value="paramValue2", dataType="string", paramType="body", access="test", defaultValue="10")})
    private void implicitParametrizedMethod() {
    }

    private void rangedParametrizedMethod(@ApiParam(value="sample param data", defaultValue="5", allowableValues="range[0,10]", collectionFormat="multi") @PathParam(value="id") Integer id, @ApiParam(value="sample positive infinity data", allowableValues="range(0, infinity)") @PathParam(value="minValue") Double minValue, @ApiParam(value="sample negative infinity data", allowableValues="range[-infinity, 100]") @PathParam(value="maxValue") Integer maxValue, @ApiParam(value="sample array data", allowMultiple=true, allowableValues="range(0, 5)") @PathParam(value="values") Integer values) {
    }

    private void arrayParametrizedMethod(@HeaderParam(value="ids") @Size(min=5, max=10) List<Long> ids) {
    }

    private void beanValidationSizeOnNumber(@QueryParam(value="intValue") @Size(min=5, max=10) int intValue, @QueryParam(value="shortValue") @Size(min=5, max=10) short shortValue, @QueryParam(value="longValue") @Size(min=5, max=10) long longValue, @QueryParam(value="floatValue") @Size(min=5, max=10) float floatValue, @QueryParam(value="doubleValue") @Size(min=5, max=10) double doubleValue, @QueryParam(value="intWrapperValue") @Size(min=5, max=10) Integer intWrapperValue, @QueryParam(value="shortWrapperValue") @Size(min=5, max=10) Short shortWrapperValue, @QueryParam(value="longWrapperValue") @Size(min=5, max=10) Long longWrapperValue, @QueryParam(value="floatWrapperValue") @Size(min=5, max=10) Float floatWrapperValue, @QueryParam(value="doubleWrapperValue") @Size(min=5, max=10) Double doubleWrapperValue, @QueryParam(value="bigIntegerWrapperValue") @Size(min=5, max=10) BigInteger bigIntegerWrapperValue, @QueryParam(value="bigDecimalWrapperValue") @Size(min=5, max=10) BigDecimal bigDecimalWrapperValue) {
    }

    private void beanValidationSizeOnString(@QueryParam(value="stringValue") @Size(min=5, max=10) String stringValue) {
    }

    private void beanValidationMin(@QueryParam(value="value") @Min(value=5L) int value) {
    }

    private void beanValidationMax(@QueryParam(value="value") @Max(value=10L) int value) {
    }

    private void beanValidationDecimalMin(@QueryParam(value="inclusiveValue") @DecimalMin(value="5.5") double inclusiveValue, @QueryParam(value="exclusiveValue") @DecimalMin(value="5.5", inclusive=false) double exclusiveValue) {
    }

    private void beanValidationDecimalMax(@QueryParam(value="inclusiveMax") @DecimalMax(value="10.5") double inclusiveValue, @QueryParam(value="exclusiveMax") @DecimalMax(value="10.5", inclusive=false) double exclusiveValue) {
    }

    private void beanValidationPattern(@QueryParam(value="patternValue") @Pattern(regexp="^[A-Z]+$") String patternValue) {
    }

    private void beanValidationArrayParametrizedMethod(@HeaderParam(value="intValues") @Size(min=5, max=10) @Min(value=5L) @Max(value=10L) List<Integer> intValues, @HeaderParam(value="doubleValues") @Size(min=5, max=10) @DecimalMin(value="5.5", inclusive=false) @DecimalMax(value="10.5", inclusive=false) List<Double> doubleValues, @HeaderParam(value="stringValues") @Size(min=5, max=10) @Pattern(regexp="^[A-Z]+$") List<String> stringValues, @ApiParam(allowMultiple=true) @HeaderParam(value="allowMultipleValues") @Size(min=5, max=10) String allowMultipleValues) {
    }

    @Test(description="parse parameters from method")
    public void parameterProcessorTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("parametrizedMethod", String.class, List.class, String.class, String.class, Integer.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        PathParameter p1 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((String)p1.getIn(), (String)"path");
        Assert.assertEquals((String)p1.getName(), (String)"paramName1");
        Assert.assertEquals((String)p1.getDescription(), (String)"paramValue1");
        Assert.assertEquals((Object)p1.getDefaultValue(), (Object)"value1");
        Assert.assertTrue((boolean)p1.getRequired());
        Assert.assertEquals((Collection)p1.getEnum(), Arrays.asList("one", "two", "three"));
        Assert.assertNull((Object)p1.getAccess());
        QueryParameter p2 = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter().items((Property)new IntegerProperty()), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)p2);
        IntegerProperty items = (IntegerProperty)p2.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((String)p2.getIn(), (String)"query");
        Assert.assertEquals((String)p2.getName(), (String)"paramName2");
        Assert.assertNull((Object)p2.getDescription());
        Assert.assertEquals((int)items.getDefault(), (int)10);
        Assert.assertFalse((boolean)p2.getRequired());
        Assert.assertEquals((String)p2.getAccess(), (String)"test");
        Parameter p3 = ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[2], Arrays.asList(paramAnnotations[2]));
        Assert.assertNull((Object)p3);
        Parameter p4 = ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[3], Arrays.asList(paramAnnotations[3]));
        Assert.assertNull((Object)p4);
        BodyParameter p5 = (BodyParameter)ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[4], Arrays.asList(paramAnnotations[4]));
        Assert.assertNotNull((Object)p5);
        Assert.assertEquals((String)p5.getIn(), (String)"body");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="arrayParam", value="paramValue1", dataType="string", paramType="path", allowMultiple=true)})
    private void implicitArrayParametrizedMethod() {
    }

    @Test(description="parse implicit parameters from method")
    public void implicitArrayParameterProcessorTest() throws NoSuchMethodException {
        ApiImplicitParams params = this.getClass().getDeclaredMethod("implicitArrayParametrizedMethod", new Class[0]).getAnnotation(ApiImplicitParams.class);
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), String.class, Collections.singletonList(params.value()[0]));
        Assert.assertEquals((String)param0.getType(), (String)"array");
        Assert.assertEquals((String)param0.getItems().getType(), (String)"string");
    }

    @Test(description="parse implicit parameters from method")
    public void implicitParameterProcessorTest() throws NoSuchMethodException {
        ApiImplicitParams params = this.getClass().getDeclaredMethod("implicitParametrizedMethod", new Class[0]).getAnnotation(ApiImplicitParams.class);
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), String.class, Collections.singletonList(params.value()[0]));
        Assert.assertNotNull((Object)param0);
        Assert.assertEquals((String)param0.getIn(), (String)"path");
        Assert.assertEquals((String)param0.getName(), (String)"paramName1");
        Assert.assertEquals((String)param0.getDescription(), (String)"paramValue1");
        Assert.assertNull((Object)param0.getEnum());
        Assert.assertNotNull((Object)param0.getItems());
        BodyParameter param1 = (BodyParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new BodyParameter(), String.class, Collections.singletonList(params.value()[1]));
        Assert.assertNotNull((Object)param1);
        Assert.assertEquals((String)param1.getIn(), (String)"body");
        Assert.assertEquals((String)param1.getName(), (String)"body");
        Assert.assertEquals((String)param1.getDescription(), (String)"paramValue2");
        Assert.assertEquals((String)param1.getAccess(), (String)"test");
        ModelImpl model = (ModelImpl)param1.getSchema();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)model.getDefaultValue(), (Object)"10");
    }

    @Test
    public void resourceWithParamRangeTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("rangedParametrizedMethod", Integer.class, Double.class, Integer.class, Integer.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param0);
        Assert.assertEquals((Object)param0.getDefaultValue(), (Object)"5");
        Assert.assertEquals((Object)param0.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertEquals((Object)param0.getMaximum(), (Object)new BigDecimal(10.0));
        Assert.assertEquals((String)param0.getCollectionFormat(), (String)"multi");
        PathParameter param1 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)param1);
        Assert.assertEquals((Object)param1.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertNull((Object)param1.getMaximum(), null);
        Assert.assertTrue((boolean)param1.isExclusiveMinimum());
        Assert.assertTrue((boolean)param1.isExclusiveMaximum());
        PathParameter param2 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[2], Arrays.asList(paramAnnotations[2]));
        Assert.assertNotNull((Object)param2);
        Assert.assertNull((Object)param2.getMinimum());
        Assert.assertEquals((Object)param2.getMaximum(), (Object)new BigDecimal(100.0));
        PathParameter param3 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter().items((Property)new IntegerProperty()), (Type)genericParameterTypes[3], Arrays.asList(paramAnnotations[3]));
        Assert.assertNotNull((Object)param3);
        IntegerProperty items = (IntegerProperty)param3.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((Object)items.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertEquals((Object)items.getMaximum(), (Object)new BigDecimal(5.0));
        Assert.assertTrue((boolean)items.getExclusiveMinimum());
        Assert.assertTrue((boolean)items.getExclusiveMaximum());
    }

    @Test
    public void resourceWithArrayParamTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("arrayParametrizedMethod", List.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        HeaderParameter param = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new HeaderParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((int)param.getMinItems(), (int)5);
        Assert.assertEquals((int)param.getMaxItems(), (int)10);
    }

    @Test
    public void beanValidationSizeOnNumberTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationSizeOnNumber", Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Integer.class, Short.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < 12; ++i) {
            QueryParameter param = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[i], Arrays.asList(paramAnnotations[i]));
            Assert.assertNotNull((Object)param);
            Assert.assertEquals((Object)param.getMinimum(), (Object)new BigDecimal(5));
            Assert.assertEquals((Object)param.getMaximum(), (Object)new BigDecimal(10));
        }
    }

    @Test
    public void beanValidationSizeOnStringTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationSizeOnString", String.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter param = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((Integer)param.getMinLength(), (Integer)new Integer(5));
        Assert.assertEquals((Integer)param.getMaxLength(), (Integer)new Integer(10));
    }

    @Test
    public void beanValidationMinTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationMin", Integer.TYPE);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter param = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((Object)param.getMinimum(), (Object)new BigDecimal(5));
    }

    @Test
    public void beanValidationMaxTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationMax", Integer.TYPE);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter param = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((Object)param.getMaximum(), (Object)new BigDecimal(10));
    }

    @Test
    public void beanValidationDecimalMinTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationDecimalMin", Double.TYPE, Double.TYPE);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter inclusiveParam = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)inclusiveParam);
        Assert.assertEquals((Object)inclusiveParam.getMinimum(), (Object)new BigDecimal(5.5));
        Assert.assertNull((Object)inclusiveParam.isExclusiveMinimum());
        QueryParameter exclusiveParam = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)exclusiveParam);
        Assert.assertEquals((Object)exclusiveParam.getMinimum(), (Object)new BigDecimal(5.5));
        Assert.assertTrue((boolean)exclusiveParam.isExclusiveMinimum());
    }

    @Test
    public void beanValidationDecimalMaxTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationDecimalMax", Double.TYPE, Double.TYPE);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter inclusiveParam = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)inclusiveParam);
        Assert.assertEquals((Object)inclusiveParam.getMaximum(), (Object)new BigDecimal(10.5));
        Assert.assertNull((Object)inclusiveParam.isExclusiveMaximum());
        QueryParameter exclusiveParam = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)exclusiveParam);
        Assert.assertEquals((Object)exclusiveParam.getMaximum(), (Object)new BigDecimal(10.5));
        Assert.assertTrue((boolean)exclusiveParam.isExclusiveMaximum());
    }

    @Test
    public void beanValidationPatternTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationPattern", String.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        QueryParameter param = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((String)param.getPattern(), (String)TEST_PATTERN_REGXP);
    }

    @Test
    public void beanValidationArrayParametrizedMethodTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("beanValidationArrayParametrizedMethod", List.class, List.class, List.class, String.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        HeaderParameter headerParam1 = (HeaderParameter)((HeaderParameter)new HeaderParameter().type("array")).items((Property)new LongProperty());
        HeaderParameter param1 = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)headerParam1, (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param1);
        Assert.assertEquals((int)param1.getMinItems(), (int)5);
        Assert.assertEquals((int)param1.getMaxItems(), (int)10);
        Property items1 = param1.getItems();
        Assert.assertTrue((boolean)(items1 instanceof LongProperty));
        LongProperty longItems = (LongProperty)items1;
        Assert.assertEquals((Object)longItems.getMinimum(), (Object)new BigDecimal(5));
        Assert.assertNull((Object)longItems.getExclusiveMinimum());
        Assert.assertEquals((Object)longItems.getMaximum(), (Object)new BigDecimal(10));
        Assert.assertNull((Object)longItems.getExclusiveMaximum());
        HeaderParameter headerParam2 = (HeaderParameter)((HeaderParameter)new HeaderParameter().type("array")).items((Property)new DoubleProperty());
        HeaderParameter param2 = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)headerParam2, (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)param2);
        Assert.assertEquals((int)param2.getMinItems(), (int)5);
        Assert.assertEquals((int)param2.getMaxItems(), (int)10);
        Property items2 = param2.getItems();
        Assert.assertTrue((boolean)(items2 instanceof DoubleProperty));
        DoubleProperty doubleItems = (DoubleProperty)items2;
        Assert.assertEquals((Object)doubleItems.getMinimum(), (Object)new BigDecimal(5.5));
        Assert.assertTrue((boolean)doubleItems.getExclusiveMinimum());
        Assert.assertEquals((Object)doubleItems.getMaximum(), (Object)new BigDecimal(10.5));
        Assert.assertTrue((boolean)doubleItems.getExclusiveMaximum());
        HeaderParameter headerParam3 = (HeaderParameter)((HeaderParameter)new HeaderParameter().type("array")).items((Property)new StringProperty());
        HeaderParameter param3 = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)headerParam3, (Type)genericParameterTypes[2], Arrays.asList(paramAnnotations[2]));
        Assert.assertNotNull((Object)param3);
        Assert.assertEquals((int)param3.getMinItems(), (int)5);
        Assert.assertEquals((int)param3.getMaxItems(), (int)10);
        Property items3 = param3.getItems();
        Assert.assertTrue((boolean)(items3 instanceof StringProperty));
        StringProperty stringItems = (StringProperty)items3;
        Assert.assertEquals((String)stringItems.getPattern(), (String)TEST_PATTERN_REGXP);
        HeaderParameter headerParam4 = (HeaderParameter)new HeaderParameter().type("string");
        HeaderParameter param4 = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)headerParam4, (Type)genericParameterTypes[3], Arrays.asList(paramAnnotations[3]));
        Assert.assertNotNull((Object)param4);
        Assert.assertEquals((String)param4.getType(), (String)"array");
        Assert.assertEquals((int)param4.getMinItems(), (int)5);
        Assert.assertEquals((int)param4.getMaxItems(), (int)10);
        Property items4 = param4.getItems();
        Assert.assertTrue((boolean)(items4 instanceof StringProperty));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="long", paramType="path", required=true)})
    private void implicitParametrizedMethodLongType() {
    }

    @Test(description="test for issue #1873 fixing.")
    public void implicitParameterLongTypeProcessorTest() throws NoSuchMethodException {
        ApiImplicitParams params = this.getClass().getDeclaredMethod("implicitParametrizedMethodLongType", new Class[0]).getAnnotation(ApiImplicitParams.class);
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), String.class, Collections.singletonList(params.value()[0]));
        Assert.assertEquals((String)param0.getName(), (String)"id");
        Assert.assertEquals((String)param0.getIn(), (String)"path");
        Assert.assertEquals((boolean)param0.getRequired(), (boolean)true);
        Assert.assertEquals((String)param0.getType(), (String)"integer");
        Assert.assertEquals((String)param0.getFormat(), (String)"int64");
    }
}

