/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.deserialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.util.Json;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.util.Map;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class JsonDeserializationTest {
    private final ObjectMapper m = Json.mapper();

    @Test(description="it should deserialize the petstore")
    public void testPetstore() throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), "specFiles/petstore.json");
        Object swagger = this.m.readValue(json, Swagger.class);
        Assert.assertTrue((boolean)(swagger instanceof Swagger));
    }

    @Test(description="it should deserialize the composition test")
    public void testCompositionTest() throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), "specFiles/compositionTest.json");
        Object swagger = this.m.readValue(json, Swagger.class);
        Assert.assertTrue((boolean)(swagger instanceof Swagger));
    }

    @Test(description="it should deserialize a simple ObjectProperty")
    public void testObjectProperty() throws IOException {
        String json = "{\n   \"type\":\"object\",\n   \"title\":\"objectProperty\",\n   \"description\":\"top level object\",\n   \"properties\":{\n      \"property1\":{\n         \"type\":\"string\",\n         \"description\":\"First property\"\n      },\n      \"property2\":{\n         \"type\":\"string\",\n         \"description\":\"Second property\"\n      },\n      \"property3\":{\n         \"type\":\"string\",\n         \"description\":\"Third property\"\n      }\n   }\n}";
        Property result = (Property)this.m.readValue("{\n   \"type\":\"object\",\n   \"title\":\"objectProperty\",\n   \"description\":\"top level object\",\n   \"properties\":{\n      \"property1\":{\n         \"type\":\"string\",\n         \"description\":\"First property\"\n      },\n      \"property2\":{\n         \"type\":\"string\",\n         \"description\":\"Second property\"\n      },\n      \"property3\":{\n         \"type\":\"string\",\n         \"description\":\"Third property\"\n      }\n   }\n}", Property.class);
        Assert.assertTrue((boolean)(result instanceof ObjectProperty));
        Assert.assertEquals((int)3, (int)((ObjectProperty)result).getProperties().size());
        Assert.assertEquals((String)"objectProperty", (String)((ObjectProperty)result).getTitle());
    }

    @Test(description="it should deserialize nested ObjectProperty(s)")
    public void testNestedObjectProperty() throws IOException {
        String json = "{\n   \"type\":\"object\",\n   \"description\":\"top level object\",\n   \"properties\":{\n      \"property1\":{\n         \"type\":\"string\",\n         \"description\":\"First property\"\n      },\n      \"property2\":{\n         \"type\":\"string\",\n         \"description\":\"Second property\"\n      },\n      \"property3\":{\n         \"type\":\"object\",\n         \"description\":\"Third property\",\n         \"properties\":{\n            \"property1\":{\n               \"type\":\"string\",\n               \"description\":\"First nested property\"\n            }\n         }\n      }\n   }\n}";
        Property result = (Property)this.m.readValue("{\n   \"type\":\"object\",\n   \"description\":\"top level object\",\n   \"properties\":{\n      \"property1\":{\n         \"type\":\"string\",\n         \"description\":\"First property\"\n      },\n      \"property2\":{\n         \"type\":\"string\",\n         \"description\":\"Second property\"\n      },\n      \"property3\":{\n         \"type\":\"object\",\n         \"description\":\"Third property\",\n         \"properties\":{\n            \"property1\":{\n               \"type\":\"string\",\n               \"description\":\"First nested property\"\n            }\n         }\n      }\n   }\n}", Property.class);
        Assert.assertTrue((boolean)(result instanceof ObjectProperty));
        Map firstLevelProperties = ((ObjectProperty)result).getProperties();
        Assert.assertEquals((int)firstLevelProperties.size(), (int)3);
        Property property3 = (Property)firstLevelProperties.get("property3");
        Assert.assertTrue((boolean)(property3 instanceof ObjectProperty));
        Map secondLevelProperties = ((ObjectProperty)property3).getProperties();
        Assert.assertEquals((int)secondLevelProperties.size(), (int)1);
    }

    @Test(description="it should deserialize untyped additionalProperties")
    public void testNestedUntypedProperty() throws IOException {
        String json = "{\n   \"type\":\"object\",\n   \"description\":\"top level object\",\n   \"additionalProperties\":{\n      \"description\":\"map value\"\n   }\n}";
        Property result = (Property)this.m.readValue("{\n   \"type\":\"object\",\n   \"description\":\"top level object\",\n   \"additionalProperties\":{\n      \"description\":\"map value\"\n   }\n}", Property.class);
        Assert.assertTrue((boolean)(result instanceof MapProperty));
        Property additionalProperties = ((MapProperty)result).getAdditionalProperties();
        Assert.assertTrue((boolean)(additionalProperties instanceof UntypedProperty));
        Assert.assertEquals((String)additionalProperties.getDescription(), (String)"map value");
    }

    @Test(description="it should deserialize an array untyped")
    public void testArrayUntypedModel() throws IOException {
        String json = "{\n   \"description\":\"top level object\",\n   \"items\":{}}";
        Model result = (Model)this.m.readValue("{\n   \"description\":\"top level object\",\n   \"items\":{}}", Model.class);
        Assert.assertTrue((boolean)(result instanceof ArrayModel));
        ArrayModel array = (ArrayModel)result;
        Assert.assertEquals((String)array.getType(), (String)"array");
        Assert.assertEquals((String)array.getDescription(), (String)"top level object");
        AssertJUnit.assertNotNull((Object)array.getItems());
    }
}

