/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.filter;

import com.google.common.collect.Sets;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.filter.DefinitionAllowedFilter;
import io.swagger.filter.InternalModelPropertiesRemoverFilter;
import io.swagger.filter.NoGetOperationsFilter;
import io.swagger.filter.NoOpOperationsFilter;
import io.swagger.filter.NoUserOperationsFilter;
import io.swagger.filter.RemoveInternalParamsFilter;
import io.swagger.filter.RemoveUnreferencedDefinitionsFilter;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.Json;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpecFilterTest {
    @Test(description="it should clone everything")
    public void cloneEverything() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)new NoOpOperationsFilter(), null, null, null);
        Assert.assertEquals((String)Json.pretty((Object)swagger), (String)Json.pretty((Object)filtered));
    }

    @Test(description="it should clone everything concurrently")
    public void cloneEverythingConcurrent() throws IOException {
        final Swagger swagger = this.getSwagger("specFiles/petstore.json");
        ThreadGroup tg = new ThreadGroup("SpecFilterTest|" + System.currentTimeMillis());
        final ConcurrentHashMap<String, Swagger> filteredMap = new ConcurrentHashMap<String, Swagger>();
        int i = 0;
        while (i < 10) {
            final int id = i++;
            new Thread(tg, "SpecFilterTest"){

                @Override
                public void run() {
                    try {
                        filteredMap.put("filtered " + id, new SpecFilter().filter(swagger, (SwaggerSpecFilter)new NoOpOperationsFilter(), null, null, null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        new Thread(new FailureHandler(tg, filteredMap, swagger)).start();
    }

    @Test(description="it should clone everything from JSON without models")
    public void cloneWithoutModels() throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), "specFiles/noModels.json");
        Swagger swagger = (Swagger)Json.mapper().readValue(json, Swagger.class);
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)new NoOpOperationsFilter(), null, null, null);
        SerializationMatchers.assertEqualsToJson(filtered, json);
    }

    @Test(description="it should filter away get operations in a resource")
    public void filterAwayGetOperations() throws IOException {
        NoGetOperationsFilter filter;
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)(filter = new NoGetOperationsFilter()), null, null, null);
        if (filtered.getPaths() != null) {
            for (Map.Entry entry : filtered.getPaths().entrySet()) {
                Assert.assertNull((Object)((Path)entry.getValue()).getGet());
            }
        } else {
            Assert.fail((String)"paths should not be null");
        }
    }

    @Test(description="it should filter away the store resource")
    public void filterAwayStoreResource() throws IOException {
        NoUserOperationsFilter filter;
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)(filter = new NoUserOperationsFilter()), null, null, null);
        if (filtered.getPaths() != null) {
            for (Map.Entry entry : filtered.getPaths().entrySet()) {
                Assert.assertNotEquals(entry.getKey(), (Object)"/user");
            }
        } else {
            Assert.fail((String)"paths should not be null");
        }
    }

    @Test(description="it should filter away secret parameters")
    public void filterAwaySecretParameters() throws IOException {
        RemoveInternalParamsFilter filter;
        Swagger swagger = this.getSwagger("specFiles/sampleSpec.json");
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)(filter = new RemoveInternalParamsFilter()), null, null, null);
        if (filtered.getPaths() != null) {
            for (Map.Entry entry : filtered.getPaths().entrySet()) {
                Operation get = ((Path)entry.getValue()).getGet();
                for (Parameter param : get.getParameters()) {
                    String description = param.getDescription();
                    Assert.assertNotNull((Object)description);
                    Assert.assertFalse((boolean)description.startsWith("secret"));
                }
            }
        } else {
            Assert.fail((String)"paths should not be null");
        }
    }

    @Test(description="it should filter away internal model properties")
    public void filterAwayInternalModelProperties() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/sampleSpec.json");
        InternalModelPropertiesRemoverFilter filter = new InternalModelPropertiesRemoverFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)filter, null, null, null);
        for (Map.Entry entry : filtered.getDefinitions().entrySet()) {
            for (String propName : ((Model)entry.getValue()).getProperties().keySet()) {
                Assert.assertFalse((boolean)propName.startsWith("_"));
            }
        }
    }

    @Test(description="it should filter away broken reference model properties")
    public void filterAwayBrokenReferenceModelProperties() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/paramAndResponseRef.json");
        Assert.assertNotNull(swagger.getDefinitions().get("Order"));
        Assert.assertNotNull(swagger.getDefinitions().get("NoPropertiesModel"));
        Assert.assertNotNull(swagger.getDefinitions().get("OrderTag"));
        Assert.assertNotNull(swagger.getDefinitions().get("Tag"));
        NoOpOperationsFilter noOpfilter = new NoOpOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)noOpfilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("Order"));
        Assert.assertNotNull(filtered.getDefinitions().get("NoPropertiesModel"));
        Assert.assertNotNull(filtered.getDefinitions().get("OrderTag"));
        Assert.assertNotNull(filtered.getDefinitions().get("Tag"));
        RemoveUnreferencedDefinitionsFilter refFilter = new RemoveUnreferencedDefinitionsFilter();
        filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)refFilter, null, null, null);
        Assert.assertNull(filtered.getDefinitions().get("Order"));
        Assert.assertNull(filtered.getDefinitions().get("NoPropertiesModel"));
        Assert.assertNull(filtered.getDefinitions().get("OrderTag"));
        Assert.assertNotNull(filtered.getDefinitions().get("Tag"));
    }

    @Test(description="it should filter away specific definitions")
    public void filterAwayDefinition() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/filteredDefinition.json");
        Assert.assertNotNull(swagger.getDefinitions().get("User"));
        NoOpOperationsFilter noOpfilter = new NoOpOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)noOpfilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("User"));
        DefinitionAllowedFilter refFilter = new DefinitionAllowedFilter();
        filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)refFilter, null, null, null);
        Assert.assertNull(filtered.getDefinitions().get("User"));
    }

    @Test(description="it should retain non-broken reference model properties")
    public void retainNonBrokenReferenceModelProperties() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/paramAndResponseRefArray.json");
        Assert.assertNotNull(swagger.getDefinitions().get("User"));
        NoOpOperationsFilter noOpfilter = new NoOpOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)noOpfilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("User"));
        RemoveUnreferencedDefinitionsFilter refFilter = new RemoveUnreferencedDefinitionsFilter();
        filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)refFilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("User"));
        Assert.assertNotNull(filtered.getDefinitions().get("Pet"));
    }

    @Test(description="it should retain non-broken reference model composed properties")
    public void retainNonBrokenReferenceModelComposedProperties() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/paramAndResponseRefComposed.json");
        Assert.assertNotNull(swagger.getDefinitions().get("User"));
        NoOpOperationsFilter noOpfilter = new NoOpOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)noOpfilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("User"));
        RemoveUnreferencedDefinitionsFilter refFilter = new RemoveUnreferencedDefinitionsFilter();
        filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)refFilter, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("User"));
        Assert.assertNotNull(filtered.getDefinitions().get("Pet"));
    }

    @Test(description="recursive models, e.g. A-> A or A-> B and B -> A should not result in stack overflow")
    public void removeUnreferencedDefinitionsOfRecuriveModels() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/recursivemodels.json");
        RemoveUnreferencedDefinitionsFilter remover = new RemoveUnreferencedDefinitionsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)remover, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("SelfReferencingModel"));
        Assert.assertNotNull(filtered.getDefinitions().get("IndirectRecursiveModelA"));
        Assert.assertNotNull(filtered.getDefinitions().get("IndirectRecursiveModelB"));
    }

    @Test(description="broken references should not result in NPE")
    public void removeUnreferencedModelOverride() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/brokenrefmodel.json");
        RemoveUnreferencedDefinitionsFilter remover = new RemoveUnreferencedDefinitionsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)remover, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("RootModel"));
    }

    @Test(description="Retain models referenced from additonalProperties")
    public void retainModelsReferencesFromAdditionalProperties() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/additionalpropsmodel.json");
        RemoveUnreferencedDefinitionsFilter remover = new RemoveUnreferencedDefinitionsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)remover, null, null, null);
        Assert.assertNotNull(filtered.getDefinitions().get("A"));
        Assert.assertNotNull(filtered.getDefinitions().get("B"));
    }

    @Test(description="Clone should retain any 'deperecated' flags present on operations")
    public void cloneRetainDeperecatedFlags() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/deprecatedoperationmodel.json");
        RemoveUnreferencedDefinitionsFilter remover = new RemoveUnreferencedDefinitionsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)remover, null, null, null);
        Operation operation = (Operation)filtered.getPath("/test").getOperations().get(0);
        Boolean deprectedFlag = operation.isDeprecated();
        Assert.assertNotNull((Object)deprectedFlag);
        Assert.assertEquals((Boolean)deprectedFlag, (Boolean)Boolean.TRUE);
    }

    @Test(description="it should filter models where some fields have no properties")
    public void filterNoPropertiesModels() throws IOException {
        String modelName = "Array";
        ModelImpl model = new ModelImpl().type("object").name("Array");
        Swagger swagger = new Swagger();
        swagger.addDefinition("Array", (Model)model);
        Map filtered = new SpecFilter().filterDefinitions((SwaggerSpecFilter)new NoOpOperationsFilter(), swagger.getDefinitions(), null, null, null);
        if (filtered.size() != 1) {
            Assert.fail((String)"ModelImpl with no properties failed to filter");
        }
    }

    @Test(description="it should contain all tags in the top level Swagger object")
    public void shouldContainAllTopLevelTags() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        NoOpOperationsFilter filter = new NoOpOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)filter, null, null, null);
        Assert.assertEquals((Set)this.getTagNames(filtered), (Set)Sets.newHashSet((Object[])new String[]{"pet", "user", "store"}));
    }

    @Test(description="it should not contain user tags in the top level Swagger object")
    public void shouldNotContainTopLevelUserTags() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        NoUserOperationsFilter filter = new NoUserOperationsFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)filter, null, null, null);
        Assert.assertEquals((Set)this.getTagNames(filtered), (Set)Sets.newHashSet((Object[])new String[]{"pet", "store"}));
    }

    @Test(description="it should filter with null definitions")
    public void filterWithNullDefinitions() throws IOException {
        Swagger swagger = this.getSwagger("specFiles/petstore.json");
        swagger.setDefinitions(null);
        InternalModelPropertiesRemoverFilter filter = new InternalModelPropertiesRemoverFilter();
        Swagger filtered = new SpecFilter().filter(swagger, (SwaggerSpecFilter)filter, null, null, null);
        Assert.assertNotNull((Object)filtered);
    }

    private Set getTagNames(Swagger swagger) {
        HashSet<String> result = new HashSet<String>();
        for (Tag item : swagger.getTags()) {
            result.add(item.getName());
        }
        return result;
    }

    private Swagger getSwagger(String path) throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), path);
        return (Swagger)Json.mapper().readValue(json, Swagger.class);
    }

    class FailureHandler
    implements Runnable {
        ThreadGroup tg;
        Map<String, Swagger> filteredMap;
        private Swagger swagger;

        public FailureHandler(ThreadGroup tg, Map<String, Swagger> filteredMap, Swagger swagger) {
            this.tg = tg;
            this.filteredMap = filteredMap;
            this.swagger = swagger;
        }

        @Override
        public void run() {
            try {
                Thread[] thds = new Thread[this.tg.activeCount()];
                this.tg.enumerate(thds);
                for (Thread t : thds) {
                    if (t == null) continue;
                    t.join(10000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Swagger filtered : this.filteredMap.values()) {
                Assert.assertEquals((String)Json.pretty((Object)this.swagger), (String)Json.pretty((Object)filtered));
            }
        }
    }
}

