/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class InheritedBeanTest
extends SwaggerTestBase {
    private ModelResolver modelResolver;
    private ModelConverterContextImpl context;

    @BeforeTest
    public void setup() {
        this.modelResolver = new ModelResolver(new ObjectMapper());
        this.context = new ModelConverterContextImpl((ModelConverter)this.modelResolver);
    }

    @Test
    public void testInheritedBean() throws Exception {
        Model baseModel = this.context.resolve(BaseBean.class);
        Assert.assertNotNull((Object)baseModel);
        this.assertBasePropertiesValid(baseModel.getProperties());
        Model subModel = (Model)this.context.getDefinedModels().get("Sub1Bean");
        Assert.assertNotNull((Object)subModel);
        Assert.assertTrue((boolean)(subModel instanceof ComposedModel));
        ComposedModel cm = (ComposedModel)subModel;
        Assert.assertEquals((String)cm.getParent().getReference(), (String)"#/definitions/BaseBean");
        this.assertSub1PropertiesValid(cm.getChild().getProperties());
    }

    @Test
    public void testInheritedChildBean() throws Exception {
        Model subModel = this.context.resolve(Sub1Bean.class);
        Assert.assertNotNull((Object)subModel);
        Assert.assertTrue((boolean)(subModel instanceof ComposedModel));
        ComposedModel cm = (ComposedModel)subModel;
        Assert.assertEquals((String)cm.getParent().getReference(), (String)"#/definitions/BaseBean");
        this.assertSub1PropertiesValid(cm.getChild().getProperties());
        Model baseModel = (Model)this.context.getDefinedModels().get("BaseBean");
        Assert.assertNotNull((Object)baseModel);
        this.assertBasePropertiesValid(baseModel.getProperties());
    }

    private void assertBasePropertiesValid(Map<String, Property> baseProperites) {
        Assert.assertEquals((int)baseProperites.size(), (int)3);
        for (Map.Entry<String, Property> entry : baseProperites.entrySet()) {
            String name = entry.getKey();
            Property prop = entry.getValue();
            if ("type".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                continue;
            }
            if ("a".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"integer");
                Assert.assertEquals((String)prop.getFormat(), (String)"int32");
                continue;
            }
            if (!"b".equals(name)) continue;
            Assert.assertEquals((String)prop.getType(), (String)"string");
        }
    }

    private void assertSub1PropertiesValid(Map<String, Property> subProperties) {
        Assert.assertEquals((int)subProperties.size(), (int)1);
        for (Map.Entry<String, Property> entry : subProperties.entrySet()) {
            String name = entry.getKey();
            Property prop = entry.getValue();
            if (!"c".equals(name)) continue;
            Assert.assertEquals((String)prop.getType(), (String)"integer");
            Assert.assertEquals((String)prop.getFormat(), (String)"int32");
        }
    }

    @Test
    public void testMultipleInheritedBean() throws Exception {
        Model baseModel = this.context.resolve(MultipleBaseBean.class);
        Assert.assertNotNull((Object)baseModel);
        this.assertBasePropertiesValid(baseModel.getProperties());
        Model sub1Model = (Model)this.context.getDefinedModels().get("MultipleSub1Bean");
        Assert.assertNotNull((Object)sub1Model);
        Assert.assertTrue((boolean)(sub1Model instanceof ComposedModel));
        ComposedModel cm1 = (ComposedModel)sub1Model;
        Assert.assertEquals((String)cm1.getParent().getReference(), (String)"#/definitions/MultipleBaseBean");
        this.assertSub1PropertiesValid(cm1.getChild().getProperties());
        Model sub2Model = (Model)this.context.getDefinedModels().get("MultipleSub2Bean");
        Assert.assertNotNull((Object)sub2Model);
        Assert.assertTrue((boolean)(sub2Model instanceof ComposedModel));
        ComposedModel cm2 = (ComposedModel)sub2Model;
        Assert.assertEquals((String)cm2.getParent().getReference(), (String)"#/definitions/MultipleBaseBean");
        this.assertSub2PropertiesValid(cm2.getChild().getProperties());
    }

    @Test
    public void testMultipleInheritedChildBean() throws Exception {
        Model subModel = this.context.resolve(MultipleSub1Bean.class);
        Assert.assertNotNull((Object)subModel);
        Assert.assertTrue((boolean)(subModel instanceof ComposedModel));
        ComposedModel cm = (ComposedModel)subModel;
        Assert.assertEquals((String)cm.getParent().getReference(), (String)"#/definitions/MultipleBaseBean");
        this.assertSub1PropertiesValid(cm.getChild().getProperties());
        Model baseModel = (Model)this.context.getDefinedModels().get("MultipleBaseBean");
        Assert.assertNotNull((Object)baseModel);
        this.assertBasePropertiesValid(baseModel.getProperties());
        Model sub1Model = (Model)this.context.getDefinedModels().get("MultipleSub1Bean");
        Assert.assertNotNull((Object)sub1Model);
        Assert.assertTrue((boolean)(sub1Model instanceof ComposedModel));
        ComposedModel cm1 = (ComposedModel)sub1Model;
        Assert.assertEquals((String)cm1.getParent().getReference(), (String)"#/definitions/MultipleBaseBean");
        this.assertSub1PropertiesValid(cm1.getChild().getProperties());
        Model sub2Model = (Model)this.context.getDefinedModels().get("MultipleSub2Bean");
        Assert.assertNotNull((Object)sub2Model);
        Assert.assertTrue((boolean)(sub2Model instanceof ComposedModel));
        ComposedModel cm2 = (ComposedModel)sub2Model;
        Assert.assertEquals((String)cm2.getParent().getReference(), (String)"#/definitions/MultipleBaseBean");
        this.assertSub2PropertiesValid(cm2.getChild().getProperties());
    }

    private void assertSub2PropertiesValid(Map<String, Property> subProperties) {
        Assert.assertEquals((int)subProperties.size(), (int)1);
        for (Map.Entry<String, Property> entry : subProperties.entrySet()) {
            String name = entry.getKey();
            Property prop = entry.getValue();
            if (!"d".equals(name)) continue;
            Assert.assertEquals((String)prop.getType(), (String)"integer");
            Assert.assertEquals((String)prop.getFormat(), (String)"int32");
        }
    }

    @ApiModel(description="MultipleSub2Bean", parent=MultipleBaseBean.class)
    static class MultipleSub2Bean
    extends MultipleBaseBean {
        public int d;

        MultipleSub2Bean() {
        }
    }

    @ApiModel(description="MultipleSub1Bean", parent=MultipleBaseBean.class)
    static class MultipleSub1Bean
    extends MultipleBaseBean {
        public int c;

        MultipleSub1Bean() {
        }
    }

    @JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.NAME, property="type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=MultipleSub1Bean.class, name="multipleSub1"), @JsonSubTypes.Type(value=MultipleSub2Bean.class, name="multipleSub2")})
    @ApiModel(description="MultipleBaseBean", discriminator="type", subTypes={MultipleSub1Bean.class, MultipleSub2Bean.class})
    static class MultipleBaseBean {
        public String type;
        public int a;
        public String b;

        MultipleBaseBean() {
        }
    }

    @ApiModel(description="Sub1Bean", parent=BaseBean.class)
    static class Sub1Bean
    extends BaseBean {
        public int c;

        Sub1Bean() {
        }
    }

    @JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.NAME, property="type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Sub1Bean.class, name="sub1")})
    @ApiModel(description="BaseBean", discriminator="type", subTypes={Sub1Bean.class})
    static class BaseBean {
        public String type;
        public int a;
        public String b;

        BaseBean() {
        }
    }
}

