/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Link;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlRootElement;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ModelResolverTest
extends SwaggerTestBase {
    @Test(dataProvider="testXmlNamespaceData")
    public void testXmlNamespace(Class clazz, String name, String namespace) throws Exception {
        ObjectMapper mapper = ModelResolverTest.mapper();
        ModelResolver modelResolver = new ModelResolver(mapper);
        ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)modelResolver);
        JavaType javaType = mapper.constructType((Type)clazz);
        Model model = modelResolver.resolve(javaType, (ModelConverterContext)context, null);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        Xml xml = ((ModelImpl)model).getXml();
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((String)xml.getName(), (String)name);
        Assert.assertEquals((String)xml.getNamespace(), (String)namespace);
    }

    @DataProvider
    private Object[][] testXmlNamespaceData() {
        return new Object[][]{{Link.class, "link", null}, {TypeWithNamespace.class, "TypeWithNamespace", "http://io.swagger/jackson"}, {TypeWithoutNamespace.class, "TypeWithOutNamespace", "http://io.swagger/jackson/package"}};
    }

    @Test
    public void testResolvePropertyWithAtomicReference() {
        ObjectMapper mapper = ModelResolverTest.mapper();
        ModelResolver modelResolver = new ModelResolver(mapper);
        JavaType javaType = TypeFactory.defaultInstance().constructType(TypeWithAtomicReferenceMember.class);
        BeanDescription beanDescription = mapper.getSerializationConfig().introspect(javaType);
        JavaType atomicReferenceBigDecimalType = null;
        for (BeanPropertyDefinition propDef : beanDescription.findProperties()) {
            if (!"member".equals(propDef.getName())) continue;
            atomicReferenceBigDecimalType = propDef.getPrimaryType();
        }
        Assert.assertNotNull(atomicReferenceBigDecimalType, (String)"Failed to read atomic reference field 'member'");
        Property actualProperty = modelResolver.resolveProperty(atomicReferenceBigDecimalType, (ModelConverterContext)new ModelConverterContextImpl((ModelConverter)modelResolver), new Annotation[0], null);
        Assert.assertEquals((String)actualProperty.getType(), (String)"number", (String)"Got wrong type for AtomicReference member");
    }

    private static final class TypeWithAtomicReferenceMember {
        AtomicReference<BigDecimal> member;

        private TypeWithAtomicReferenceMember() {
        }

        public AtomicReference<BigDecimal> getMember() {
            return this.member;
        }

        public void setMember(AtomicReference<BigDecimal> member) {
            this.member = member;
        }
    }

    @XmlRootElement(name="TypeWithOutNamespace")
    public static class TypeWithoutNamespace {
    }

    @XmlRootElement(name="TypeWithNamespace", namespace="http://io.swagger/jackson")
    public static class TypeWithNamespace {
    }
}

