/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.properties;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PropertySerializationTest {
    private final ObjectMapper m = Json.mapper();

    @Test(description="it should serialize a BooleanProperty")
    public void serializeBooleanProperty() throws IOException {
        BooleanProperty p = new BooleanProperty()._default(true);
        String json = "{\"type\":\"boolean\",\"default\":true}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"boolean\",\"default\":true}");
    }

    @Test(description="it should deserialize a BooleanProperty")
    public void deserializeBooleanProperty() throws IOException {
        String json = "{\"type\":\"boolean\",\"default\":false}";
        Property p = (Property)this.m.readValue("{\"type\":\"boolean\",\"default\":false}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"boolean");
        Assert.assertNull((Object)p.getFormat());
        Assert.assertEquals(p.getClass(), BooleanProperty.class);
        Assert.assertEquals((Boolean)((BooleanProperty)p).getDefault(), (Boolean)Boolean.FALSE);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"boolean\",\"default\":false}");
    }

    @Test(description="it should serialize a DateProperty")
    public void serializeDateProperty() throws IOException {
        DateProperty p = new DateProperty();
        String json = "{\"type\":\"string\",\"format\":\"date\"}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"format\":\"date\"}");
    }

    @Test(description="it should deserialize a DateProperty")
    public void deserializeDateProperty() throws IOException {
        String json = "{\"type\":\"string\",\"format\":\"date\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"string\",\"format\":\"date\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"string");
        Assert.assertEquals((String)p.getFormat(), (String)"date");
        Assert.assertEquals(p.getClass(), DateProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"format\":\"date\"}");
    }

    @Test(description="it should serialize a DateTimeProperty")
    public void serializeDateTimeProperty() throws IOException {
        DateTimeProperty p = new DateTimeProperty();
        String json = "{\"type\":\"string\",\"format\":\"date-time\"}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"format\":\"date-time\"}");
    }

    @Test(description="it should deserialize a DateTimeProperty")
    public void deserializeDateTimeProperty() throws IOException {
        String json = "{\"type\":\"string\",\"format\":\"date-time\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"string\",\"format\":\"date-time\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"string");
        Assert.assertEquals((String)p.getFormat(), (String)"date-time");
        Assert.assertEquals(p.getClass(), DateTimeProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"format\":\"date-time\"}");
    }

    @Test(description="it should serialize a DoubleProperty")
    public void serializeDoubleProperty() throws IOException {
        DoubleProperty p = new DoubleProperty()._default(Double.valueOf(3.14159));
        String json = "{\"type\":\"number\",\"format\":\"double\",\"default\":3.14159}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"number\",\"format\":\"double\",\"default\":3.14159}");
    }

    @Test(description="it should deserialize a DoubleProperty")
    public void deserializeDoubleProperty() throws IOException {
        String json = "{\"type\":\"number\",\"format\":\"double\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"number\",\"format\":\"double\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"number");
        Assert.assertEquals((String)p.getFormat(), (String)"double");
        Assert.assertEquals(p.getClass(), DoubleProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"number\",\"format\":\"double\"}");
    }

    @Test(description="it should serialize a FloatProperty")
    public void serializeFloatProperty() throws IOException {
        FloatProperty p = new FloatProperty()._default(Float.valueOf(1.2f));
        String json = "{\"type\":\"number\",\"format\":\"float\",\"default\":1.2}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"number\",\"format\":\"float\",\"default\":1.2}");
    }

    @Test(description="it should deserialize a FloatProperty")
    public void deserializeFloatProperty() throws IOException {
        String json = "{\"type\":\"number\",\"format\":\"float\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"number\",\"format\":\"float\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"number");
        Assert.assertEquals((String)p.getFormat(), (String)"float");
        Assert.assertEquals(p.getClass(), FloatProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"number\",\"format\":\"float\"}");
    }

    @Test(description="it should serialize an IntegerProperty")
    public void serializeIntegerProperty() throws IOException {
        IntegerProperty p = new IntegerProperty()._default(Integer.valueOf(32));
        String json = "{\"type\":\"integer\",\"format\":\"int32\",\"default\":32}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"integer\",\"format\":\"int32\",\"default\":32}");
    }

    @Test(description="it should deserialize a IntegerProperty")
    public void deserializeIntegerProperty() throws IOException {
        String json = "{\"type\":\"integer\",\"format\":\"int32\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"integer\",\"format\":\"int32\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"integer");
        Assert.assertEquals((String)p.getFormat(), (String)"int32");
        Assert.assertEquals(p.getClass(), IntegerProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"integer\",\"format\":\"int32\"}");
    }

    @Test(description="it should serialize a LongProperty")
    public void serializeLongProperty() throws IOException {
        LongProperty p = new LongProperty()._default(Long.valueOf(8675309L));
        String json = "{\"type\":\"integer\",\"format\":\"int64\",\"default\":8675309}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"integer\",\"format\":\"int64\",\"default\":8675309}");
    }

    @Test(description="it should deserialize a LongProperty")
    public void deserializeLongProperty() throws IOException {
        String json = "{\"type\":\"integer\",\"format\":\"int64\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"integer\",\"format\":\"int64\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"integer");
        Assert.assertEquals((String)p.getFormat(), (String)"int64");
        Assert.assertEquals(p.getClass(), LongProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"integer\",\"format\":\"int64\"}");
    }

    @Test(description="it should serialize a string MapProperty")
    public void serializeStringMapProperty() throws IOException {
        MapProperty p = new MapProperty((Property)new StringProperty());
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"string\"}}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"string\"}}");
    }

    @Test(description="it should deserialize a string MapProperty")
    public void deserializeStringMapProperty() throws IOException {
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"string\"}}";
        Property p = (Property)this.m.readValue("{\"type\":\"object\",\"additionalProperties\":{\"type\":\"string\"}}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"object");
        Assert.assertEquals(p.getClass(), MapProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"string\"}}");
    }

    @Test(description="it should serialize a integer MapProperty")
    public void serializeIntegerMapProperty() throws IOException {
        MapProperty p = new MapProperty((Property)new IntegerProperty());
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int32\"}}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int32\"}}");
    }

    @Test(description="it should deserialize a integer MapProperty")
    public void deserializeIntegerMapProperty() throws IOException {
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int32\"}}";
        Property p = (Property)this.m.readValue("{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int32\"}}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"object");
        Assert.assertEquals(p.getClass(), MapProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int32\"}}");
    }

    @Test(description="it should serialize a long MapProperty")
    public void serializeLongMapProperty() throws IOException {
        MapProperty p = new MapProperty((Property)new LongProperty());
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int64\"}}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int64\"}}");
    }

    @Test(description="it should deserialize a long MapProperty")
    public void deserializeLongMapProperty() throws IOException {
        String json = "{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int64\"}}";
        Property p = (Property)this.m.readValue("{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int64\"}}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"object");
        Assert.assertEquals(p.getClass(), MapProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"additionalProperties\":{\"type\":\"integer\",\"format\":\"int64\"}}");
    }

    @Test(description="it should serialize a RefProperty")
    public void serializeRefProperty() throws IOException {
        RefProperty p = new RefProperty("Dog");
        String json = "{\"$ref\":\"#/definitions/Dog\"}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"$ref\":\"#/definitions/Dog\"}");
    }

    @Test(description="it should deserialize a RefProperty")
    public void deserializeRefProperty() throws IOException {
        String json = "{\"$ref\":\"#/definitions/Dog\"}";
        Property p = (Property)this.m.readValue("{\"$ref\":\"#/definitions/Dog\"}", Property.class);
        Assert.assertEquals(p.getClass(), RefProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"$ref\":\"#/definitions/Dog\"}");
    }

    @Test(description="it should serialize a StringProperty")
    public void serializeStringProperty() throws IOException {
        StringProperty p = new StringProperty()._default("Bob");
        String json = "{\"type\":\"string\",\"default\":\"Bob\"}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"default\":\"Bob\"}");
    }

    @Test(description="it should deserialize a StringProperty")
    public void deserializeStringProperty() throws IOException {
        String json = "{\"type\":\"string\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"string\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"string");
        Assert.assertEquals(p.getClass(), StringProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\"}");
    }

    @Test(description="it should serialize a StringProperty with enums")
    public void serializeEnumStringProperty() throws IOException {
        StringProperty p = new StringProperty()._enum("a")._enum("b");
        String json = "{\"type\":\"string\",\"enum\":[\"a\",\"b\"]}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"enum\":[\"a\",\"b\"]}");
    }

    @Test(description="it should deserialize a StringProperty with enums")
    public void deserializeEnumStringProperty() throws IOException {
        String json = "{\"type\":\"string\",\"enum\":[\"a\",\"b\"]}";
        Property p = (Property)this.m.readValue("{\"type\":\"string\",\"enum\":[\"a\",\"b\"]}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"string");
        List _enum = ((StringProperty)p).getEnum();
        Assert.assertNotNull((Object)_enum);
        Assert.assertEquals((Collection)_enum, Arrays.asList("a", "b"));
        Assert.assertEquals(p.getClass(), StringProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"enum\":[\"a\",\"b\"]}");
    }

    @Test(description="it should deserialize an IntegerProperty with enums")
    public void deserializeEnumIntegerProperty() throws IOException {
        String json = "{\"type\":\"integer\",\"format\":\"int32\",\"enum\":[1,2]}";
        Property p = (Property)this.m.readValue("{\"type\":\"integer\",\"format\":\"int32\",\"enum\":[1,2]}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"integer");
        List _enum = ((IntegerProperty)p).getEnum();
        Assert.assertNotNull((Object)_enum);
        Assert.assertEquals((Collection)_enum, Arrays.asList(1, 2));
        Assert.assertEquals(p.getClass(), IntegerProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"integer\",\"format\":\"int32\",\"enum\":[1,2]}");
    }

    @Test(description="it should serialize a string array property")
    public void serializeArrayStringProperty() throws IOException {
        ArrayProperty p = new ArrayProperty().items((Property)new StringProperty());
        String json = "{\"type\":\"array\",\"items\":{\"type\":\"string\"}}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"array\",\"items\":{\"type\":\"string\"}}");
    }

    @Test(description="it should deserialize a string array property")
    public void deserializeArrayStringProperty() throws IOException {
        String json = "{\"type\":\"array\",\"items\":{\"type\":\"string\"}}";
        Property p = (Property)this.m.readValue("{\"type\":\"array\",\"items\":{\"type\":\"string\"}}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"array");
        Assert.assertEquals(p.getClass(), ArrayProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"array\",\"items\":{\"type\":\"string\"}}");
    }

    @Test(description="it should serialize a string property with readOnly set")
    public void serializeReadOnlyStringProperty() throws IOException {
        StringProperty p = new StringProperty().readOnly();
        String json = "{\"type\":\"string\",\"readOnly\":true}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\",\"readOnly\":true}");
    }

    @Test(description="it should serialize a string property with readOnly unset")
    public void deserializeNotReadOnlyStringProperty() throws IOException {
        StringProperty p = new StringProperty();
        p.setReadOnly(Boolean.valueOf(false));
        String json = "{\"type\":\"string\"}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"string\"}");
    }

    @Test(description="it should read a file property")
    public void serializeFileProperty() throws IOException {
        String json = "{\"type\":\"file\"}";
        Property p = (Property)this.m.readValue("{\"type\":\"file\"}", Property.class);
        Assert.assertEquals((String)p.getType(), (String)"file");
        Assert.assertEquals(p.getClass(), FileProperty.class);
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"file\"}");
    }

    @Test(description="it should serialize an object property with required set")
    public void serializeObjectPropertyWithRequiredProperties() throws IOException {
        ObjectProperty p = new ObjectProperty().property("stringProperty", (Property)new StringProperty().required(true));
        String json = "{\"type\":\"object\",\"properties\":{\"stringProperty\":{\"type\":\"string\"}},\"required\":[\"stringProperty\"]}";
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"object\",\"properties\":{\"stringProperty\":{\"type\":\"string\"}},\"required\":[\"stringProperty\"]}");
    }

    @Test(description="it should deserialize an object property with required set")
    public void deserializeObjectPropertyWithRequiredProperties() throws IOException {
        ObjectProperty p = new ObjectProperty().property("stringProperty", (Property)new StringProperty().required(true));
        String json = "{\"type\":\"object\",\"properties\":{\"stringProperty\":{\"type\":\"string\"}},\"required\":[\"stringProperty\"]}";
        Assert.assertEquals((Object)p, (Object)this.m.readValue("{\"type\":\"object\",\"properties\":{\"stringProperty\":{\"type\":\"string\"}},\"required\":[\"stringProperty\"]}", ObjectProperty.class));
    }
}

