/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.dataformat.yaml.JacksonYAMLParseException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Swagger;
import io.swagger.util.ObjectMapperFactory;
import io.swagger.util.ResourceUtils;
import org.testng.annotations.Test;
import org.yaml.snakeyaml.LoaderOptions;

public class YamlSerializationTest {
    @Test
    public void testSerializeYAMLWithCustomFactory() throws Exception {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x500000);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loaderOptions).build();
        String yaml = ResourceUtils.loadClassResource(this.getClass(), "specFiles/petstore.yaml");
        Swagger swagger = (Swagger)ObjectMapperFactory.createYaml((YAMLFactory)yamlFactory).readValue(yaml, Swagger.class);
        SerializationMatchers.assertEqualsToYaml(swagger, yaml);
    }

    @Test(expectedExceptions={JacksonYAMLParseException.class})
    public void testSerializeYAMLWithCustomFactoryAndCodePointLimitReached() throws Exception {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(1);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loaderOptions).build();
        String yaml = ResourceUtils.loadClassResource(this.getClass(), "specFiles/petstore.yaml");
        Swagger swagger = (Swagger)ObjectMapperFactory.createYaml((YAMLFactory)yamlFactory).readValue(yaml, Swagger.class);
    }
}

