/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.swagger.jackson.PackageVersion;
import io.swagger.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

public class SwaggerAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        Schema ann = (Schema)m.getAnnotation(Schema.class);
        return ann != null && ann.hidden();
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        Schema ann = (Schema)m.getAnnotation(Schema.class);
        if (ann != null) {
            return ann.required();
        }
        XmlElement elem = (XmlElement)m.getAnnotation(XmlElement.class);
        if (elem != null && elem.required()) {
            return true;
        }
        return null;
    }

    public String findPropertyDescription(Annotated a) {
        Schema model = (Schema)a.getAnnotation(Schema.class);
        if (model != null && !"".equals(model.description())) {
            return model.description();
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        return Collections.emptyList();
    }

    public String findTypeName(AnnotatedClass ac) {
        return null;
    }
}

