/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.converter.ModelConverters;
import io.swagger.oas.annotations.Parameter;
import io.swagger.oas.annotations.enums.Explode;
import io.swagger.oas.annotations.media.ExampleObject;
import io.swagger.oas.annotations.media.Schema;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.BinarySchema;
import io.swagger.oas.models.media.ByteArraySchema;
import io.swagger.oas.models.media.DateSchema;
import io.swagger.oas.models.media.DateTimeSchema;
import io.swagger.oas.models.media.EmailSchema;
import io.swagger.oas.models.media.IntegerSchema;
import io.swagger.oas.models.media.PasswordSchema;
import io.swagger.oas.models.media.StringSchema;
import io.swagger.oas.models.media.UUIDSchema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.util.Json;
import io.swagger.util.PrimitiveType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static io.swagger.oas.models.parameters.Parameter applyAnnotations(OpenAPI openAPI, io.swagger.oas.models.parameters.Parameter parameter, Type type, List<Annotation> annotations) {
        io.swagger.oas.models.media.Schema filled;
        ArraySchema as;
        AnnotationsHelper helper = new AnnotationsHelper(annotations, type);
        if (helper.isContext()) {
            return null;
        }
        if (parameter == null) {
            parameter = new io.swagger.oas.models.parameters.Parameter();
        }
        for (Annotation annotation : annotations) {
            io.swagger.oas.models.media.Schema schema;
            if (annotation instanceof Schema && (schema = ParameterProcessor.processSchema((Schema)annotation)) != null) {
                parameter.setSchema(schema);
            }
            if (annotation instanceof Parameter) {
                io.swagger.oas.models.media.Schema arraySchema;
                Parameter p = (Parameter)annotation;
                if (StringUtils.isNotBlank((CharSequence)p.description())) {
                    parameter.setDescription(p.description());
                }
                if (StringUtils.isNotBlank((CharSequence)p.name())) {
                    parameter.setName(p.name());
                }
                if (StringUtils.isNotBlank((CharSequence)p.in())) {
                    parameter.setIn(p.in());
                }
                if (StringUtils.isNotBlank((CharSequence)p.example())) {
                    try {
                        parameter.setExample((Object)Json.mapper().readTree(p.example()));
                    }
                    catch (IOException e) {
                        parameter.setExample((Object)p.example());
                    }
                }
                if (p.deprecated()) {
                    parameter.setDeprecated(Boolean.valueOf(p.deprecated()));
                }
                if (p.required()) {
                    parameter.setRequired(Boolean.valueOf(p.required()));
                }
                if (p.allowEmptyValue()) {
                    parameter.setAllowEmptyValue(Boolean.valueOf(p.allowEmptyValue()));
                }
                if (p.allowReserved()) {
                    parameter.setAllowReserved(Boolean.valueOf(p.allowReserved()));
                }
                HashMap exampleMap = new HashMap();
                for (ExampleObject exampleObject : p.examples()) {
                    ParameterProcessor.getExample(exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
                }
                if (exampleMap.size() > 0) {
                    parameter.setExamples(exampleMap);
                }
                ParameterProcessor.setParameterStyle(parameter, p);
                ParameterProcessor.setParameterExplode(parameter, p);
                if (ParameterProcessor.hasSchemaAnnotation(p.schema())) {
                    io.swagger.oas.models.media.Schema schema2 = ParameterProcessor.processSchema(p.schema());
                    if (schema2 == null) continue;
                    parameter.setSchema(schema2);
                    continue;
                }
                if (!ParameterProcessor.hasArrayAnnotation(p.array()) || (arraySchema = ParameterProcessor.processArraySchema(p.array())) == null) continue;
                parameter.setSchema(arraySchema);
                continue;
            }
            if (annotation.annotationType().getName().equals("javax.ws.rs.PathParam")) {
                try {
                    String name = (String)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                    if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                    parameter.setName(name);
                }
                catch (Exception name) {}
                continue;
            }
            if (!annotation.annotationType().getName().equals("javax.validation.constraints.Size")) continue;
            try {
                Integer max;
                if (parameter.getSchema() == null) {
                    parameter.setSchema((io.swagger.oas.models.media.Schema)new ArraySchema());
                }
                if (!(parameter.getSchema() instanceof ArraySchema)) continue;
                as = (ArraySchema)parameter.getSchema();
                Integer min = (Integer)annotation.annotationType().getMethod("min", new Class[0]).invoke((Object)annotation, new Object[0]);
                if (min != null) {
                    as.setMinItems(min);
                }
                if ((max = (Integer)annotation.annotationType().getMethod("max", new Class[0]).invoke((Object)annotation, new Object[0])) == null) continue;
                as.setMaxItems(max);
            }
            catch (Exception e) {
                LOGGER.error("failed on " + annotation.annotationType().getName(), (Throwable)e);
            }
        }
        if (type != null && (filled = ParameterProcessor.fillSchema(parameter.getSchema(), type)) != null) {
            parameter.setSchema(filled);
        }
        String defaultValue = helper.getDefaultValue();
        io.swagger.oas.models.media.Schema paramSchema = parameter.getSchema();
        if (paramSchema != null) {
            if (paramSchema instanceof ArraySchema) {
                as = (ArraySchema)paramSchema;
                if (defaultValue != null) {
                    as.getItems().setDefault((Object)defaultValue);
                }
            } else if (defaultValue != null) {
                paramSchema.setDefault((Object)defaultValue);
            }
        }
        return parameter;
    }

    public static Optional<Example> getExample(ExampleObject example) {
        if (example == null) {
            return Optional.empty();
        }
        if (StringUtils.isNotBlank((CharSequence)example.name())) {
            Example exampleObject = new Example();
            if (StringUtils.isNotBlank((CharSequence)example.name())) {
                exampleObject.setDescription(example.name());
            }
            if (StringUtils.isNotBlank((CharSequence)example.summary())) {
                exampleObject.setSummary(example.summary());
            }
            if (StringUtils.isNotBlank((CharSequence)example.externalValue())) {
                exampleObject.setExternalValue(example.externalValue());
            }
            if (StringUtils.isNotBlank((CharSequence)example.value())) {
                try {
                    exampleObject.setValue((Object)Json.mapper().readTree(example.value()));
                }
                catch (IOException e) {
                    exampleObject.setValue((Object)example.value());
                }
            }
            return Optional.of(exampleObject);
        }
        return Optional.empty();
    }

    private static boolean hasArrayAnnotation(io.swagger.oas.annotations.media.ArraySchema array) {
        return array.uniqueItems() || array.maxItems() != Integer.MIN_VALUE || array.minItems() != Integer.MAX_VALUE || ParameterProcessor.hasSchemaAnnotation(array.schema());
    }

    private static io.swagger.oas.models.media.Schema processArraySchema(io.swagger.oas.annotations.media.ArraySchema array) {
        ArraySchema output = new ArraySchema();
        io.swagger.oas.models.media.Schema schema = ParameterProcessor.processSchema(array.schema());
        output.setItems(schema);
        return output;
    }

    public static void setParameterExplode(io.swagger.oas.models.parameters.Parameter parameter, Parameter p) {
        if (ParameterProcessor.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private static boolean isExplodable(Parameter p) {
        Class implementation;
        Schema schema = p.schema();
        boolean explode = true;
        if (schema != null && (implementation = schema.implementation()) == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    public static void setParameterStyle(io.swagger.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toUpperCase()));
        }
    }

    public static io.swagger.oas.models.media.Schema fillSchema(io.swagger.oas.models.media.Schema schema, Type type) {
        if (schema != null) {
            if (schema != null && StringUtils.isBlank((CharSequence)schema.getType())) {
                PrimitiveType pt = PrimitiveType.fromType(type);
                if (pt != null) {
                    io.swagger.oas.models.media.Schema inner = pt.createProperty();
                    return ParameterProcessor.merge(schema, inner);
                }
                return ParameterProcessor.merge(schema, ModelConverters.getInstance().resolveProperty(type));
            }
            if ("array".equals(schema.getType())) {
                io.swagger.oas.models.media.Schema inner = ParameterProcessor.fillSchema(((ArraySchema)schema).getItems(), type);
                ArraySchema as = (ArraySchema)schema;
                as.setItems(inner);
                as.setMinItems(schema.getMinItems());
                as.setMaxItems(schema.getMaxItems());
                return as;
            }
        } else {
            PrimitiveType pt = PrimitiveType.fromType(type);
            if (pt != null) {
                io.swagger.oas.models.media.Schema inner = pt.createProperty();
                return ParameterProcessor.merge(schema, inner);
            }
            return ModelConverters.getInstance().resolveProperty(type);
        }
        return schema;
    }

    public static io.swagger.oas.models.media.Schema merge(io.swagger.oas.models.media.Schema from, io.swagger.oas.models.media.Schema to) {
        if (from == null) {
            return to;
        }
        if (to.getDefault() == null) {
            to.setDefault(from.getDefault());
        }
        if (to.getDeprecated() == null) {
            to.setDeprecated(from.getDeprecated());
        }
        if (to.getDescription() == null) {
            to.setDescription(from.getDescription());
        }
        if (to.getEnum() == null) {
            to.setEnum(from.getEnum());
        }
        if (to.getExample() == null) {
            to.setExample(from.getExample());
        }
        if (to.getExclusiveMaximum() == null) {
            to.setExclusiveMaximum(from.getExclusiveMaximum());
        }
        if (to.getExclusiveMinimum() == null) {
            to.setExclusiveMinimum(from.getExclusiveMinimum());
        }
        if (to.getExtensions() == null) {
            to.setExtensions(from.getExtensions());
        }
        if (to.getExternalDocs() == null) {
            to.setExternalDocs(from.getExternalDocs());
        }
        if (to.getFormat() == null) {
            to.setFormat(from.getFormat());
        }
        if (to.getMaximum() == null) {
            to.setMaximum(from.getMaximum());
        }
        if (to.getMaxLength() == null) {
            to.setMaxLength(from.getMaxLength());
        }
        if (to.getMinimum() == null) {
            to.setMinimum(from.getMinimum());
        }
        if (to.getMinLength() == null) {
            to.setMinLength(from.getMinLength());
        }
        if (to.getMultipleOf() == null) {
            to.setMultipleOf(from.getMultipleOf());
        }
        if (to.getNullable() == null) {
            to.setNullable(from.getNullable());
        }
        if (to.getPattern() == null) {
            to.setPattern(from.getPattern());
        }
        if (to.getReadOnly() == null) {
            to.setReadOnly(from.getReadOnly());
        }
        if (to.getRequired() == null) {
            to.setRequired(from.getRequired());
        }
        if (to.getTitle() == null) {
            to.setTitle(from.getTitle());
        }
        if (to.getXml() == null) {
            to.setXml(from.getXml());
        }
        if (to.getWriteOnly() == null) {
            to.setWriteOnly(from.getWriteOnly());
        }
        return to;
    }

    private static boolean hasSchemaAnnotation(Schema schema) {
        return !StringUtils.isBlank((CharSequence)schema.type()) || !StringUtils.isBlank((CharSequence)schema.format()) || !StringUtils.isBlank((CharSequence)schema.title()) || !StringUtils.isBlank((CharSequence)schema.description()) || !StringUtils.isBlank((CharSequence)schema.ref()) || !StringUtils.isBlank((CharSequence)schema.name()) || schema.multipleOf() != 0.0 || !StringUtils.isBlank((CharSequence)schema.maximum()) || !StringUtils.isBlank((CharSequence)schema.minimum()) || schema.exclusiveMinimum() || schema.exclusiveMaximum() || schema.maxLength() != Integer.MIN_VALUE || schema.minLength() != Integer.MAX_VALUE || schema.minProperties() != 0 || schema.maxProperties() != 0 || schema.requiredProperties().length != 1 || !StringUtils.isBlank((CharSequence)schema.requiredProperties()[0]) || schema.required() || schema.nullable() || schema.readOnly() || schema.writeOnly() || schema.deprecated() || schema.allowableValues().length != 1 || !StringUtils.isBlank((CharSequence)schema.allowableValues()[0]) || !StringUtils.isBlank((CharSequence)schema.defaultValue()) || !StringUtils.isBlank((CharSequence)schema.example()) || !StringUtils.isBlank((CharSequence)schema.pattern()) || !schema.not().equals(Void.class) || schema.oneOf().length != 1 || !schema.oneOf()[0].equals(Void.class) || schema.anyOf().length != 1 || !schema.anyOf()[0].equals(Void.class);
    }

    private static io.swagger.oas.models.media.Schema processSchema(Schema schema) {
        Object output = null;
        if (schema.type() != null) {
            if ("integer".equals(schema.type())) {
                output = new IntegerSchema();
                if (StringUtils.isNotBlank((CharSequence)schema.format())) {
                    output.format(schema.format());
                }
            } else {
                output = "string".equals(schema.type()) ? ("password".equals(schema.format()) ? new PasswordSchema() : ("binary".equals(schema.format()) ? new BinarySchema() : ("byte".equals(schema.format()) ? new ByteArraySchema() : ("date".equals(schema.format()) ? new DateSchema() : ("date-time".equals(schema.format()) ? new DateTimeSchema() : ("email".equals(schema.format()) ? new EmailSchema() : ("uuid".equals(schema.format()) ? new UUIDSchema() : new StringSchema()))))))) : new io.swagger.oas.models.media.Schema();
            }
        }
        if (output != null) {
            if (StringUtils.isNotBlank((CharSequence)schema.defaultValue())) {
                output.setDefault((Object)schema.defaultValue());
            }
            if (StringUtils.isNotBlank((CharSequence)schema.pattern())) {
                output.setPattern(schema.pattern());
            }
            if (StringUtils.isNotBlank((CharSequence)schema.format())) {
                output.setFormat(schema.format());
            }
            if (StringUtils.isNotBlank((CharSequence)schema.description())) {
                output.setDescription(schema.description());
            }
            if (schema.allowableValues() != null) {
                for (String v : schema.allowableValues()) {
                    if (!StringUtils.isNotBlank((CharSequence)v)) continue;
                    output.addEnumItemObject((Object)v);
                }
            }
            if (schema.exclusiveMinimum()) {
                output.exclusiveMinimum(Boolean.valueOf(true));
            }
            if (schema.exclusiveMaximum()) {
                output.exclusiveMaximum(Boolean.valueOf(true));
            }
            if (schema.readOnly()) {
                output.readOnly(Boolean.valueOf(true));
            }
            if (StringUtils.isNotBlank((CharSequence)schema.minimum())) {
                output.minimum(new BigDecimal(schema.minimum()));
            }
            if (StringUtils.isNotBlank((CharSequence)schema.maximum())) {
                output.maximum(new BigDecimal(schema.maximum()));
            }
            if (schema.minProperties() > 0) {
                output.minProperties(Integer.valueOf(schema.minProperties()));
            }
            if (schema.maxProperties() > 0) {
                output.maxProperties(Integer.valueOf(schema.maxProperties()));
            }
        }
        return output;
    }

    private static class AnnotationsHelper {
        private boolean context;
        private String type;
        private String format;
        private String defaultValue;
        private Integer minItems;
        private Integer maxItems;
        private Boolean required;
        private BigDecimal min;
        private boolean minExclusive = false;
        private BigDecimal max;
        private boolean maxExclusive = false;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private Boolean allowEmptyValue;
        private String collectionFormat;

        public AnnotationsHelper(List<Annotation> annotations, Type _type) {
            String rsDefault = null;
            Size size = null;
            if (annotations != null) {
                for (Annotation item : annotations) {
                    if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                        this.context = true;
                        continue;
                    }
                    if ("javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) {
                        try {
                            rsDefault = (String)item.annotationType().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Invocation of value method failed", (Throwable)ex);
                        }
                        continue;
                    }
                    if (item instanceof Size) {
                        size = (Size)item;
                        continue;
                    }
                    if (item instanceof NotNull) {
                        this.required = true;
                        continue;
                    }
                    if (item instanceof Min) {
                        this.min = new BigDecimal(((Min)item).value());
                        continue;
                    }
                    if (item instanceof Max) {
                        this.max = new BigDecimal(((Max)item).value());
                        continue;
                    }
                    if (item instanceof DecimalMin) {
                        DecimalMin decimalMinAnnotation = (DecimalMin)item;
                        this.min = new BigDecimal(decimalMinAnnotation.value());
                        this.minExclusive = !decimalMinAnnotation.inclusive();
                        continue;
                    }
                    if (item instanceof DecimalMax) {
                        DecimalMax decimalMaxAnnotation = (DecimalMax)item;
                        this.max = new BigDecimal(decimalMaxAnnotation.value());
                        this.maxExclusive = !decimalMaxAnnotation.inclusive();
                        continue;
                    }
                    if (!(item instanceof Pattern)) continue;
                    this.pattern = ((Pattern)item).regexp();
                }
            }
            this.defaultValue = rsDefault;
        }

        private boolean isAssignableToNumber(Class<?> clazz) {
            return Number.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
        }

        public boolean isContext() {
            return this.context;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinItems() {
            return this.minItems;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public boolean isMaxExclusive() {
            return this.maxExclusive;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isMinExclusive() {
            return this.minExclusive;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Boolean getAllowEmptyValue() {
            return this.allowEmptyValue;
        }

        public String getCollectionFormat() {
            return this.collectionFormat;
        }
    }
}

