/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.models.HibernateBeanValidationsModel;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HibernateBeanValidationsTest {
    @Test(description="it should read hibernate validations")
    public void readHibernateValidations() {
        Map schemas = ModelConverters.getInstance().readAll(HibernateBeanValidationsModel.class);
        Map properties = ((Model)schemas.get("HibernateBeanValidationsModel")).getProperties();
        IntegerProperty age = (IntegerProperty)properties.get("age");
        Assert.assertEquals((double)age.getMinimum().doubleValue(), (double)13.0, (double)0.01);
        Assert.assertEquals((double)age.getMaximum().doubleValue(), (double)99.0, (double)0.01);
        StringProperty password = (StringProperty)properties.get("password");
        Assert.assertEquals((int)password.getMinLength(), (int)6);
        Assert.assertEquals((int)password.getMaxLength(), (int)20);
        Assert.assertTrue((boolean)((DoubleProperty)properties.get("minBalance")).getExclusiveMinimum());
        Assert.assertTrue((boolean)((DoubleProperty)properties.get("maxBalance")).getExclusiveMaximum());
    }

    @Test
    public void shouldUnderstandNotEmpty() {
        Map schemas = ModelConverters.getInstance().readAll(HibernateBeanValidationsModel.class);
        Map properties = ((Model)schemas.get("HibernateBeanValidationsModel")).getProperties();
        StringProperty notEmptyString = (StringProperty)properties.get("notEmptyString");
        Assert.assertEquals((int)notEmptyString.getMinLength(), (int)1);
        ArrayProperty notEmptyArray = (ArrayProperty)properties.get("notEmptyArray");
        Assert.assertEquals((int)notEmptyArray.getMinItems(), (int)1);
    }
}

