/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

public class HibernateBeanValidationsModel {
    @NotNull
    protected Long id;
    @Min(value=13L)
    @Max(value=99L)
    protected Integer age;
    @Length(min=2, max=20)
    protected String username;
    @Size(min=6, max=20)
    protected String password;
    @NotBlank
    protected String passwordHint;
    @Email
    protected String email;
    @DecimalMin(value="0.1", inclusive=false)
    protected Double minBalance;
    @DecimalMax(value="1000000", inclusive=false)
    protected Double maxBalance;
    @Range(min=1900L, max=2015L)
    protected Integer birthYear;
    @NotEmpty
    protected String notEmptyString;
    @NotEmpty
    protected List<String> notEmptyArray;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordHint() {
        return this.passwordHint;
    }

    public void setPasswordHint(String passwordHint) {
        this.passwordHint = passwordHint;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Double getMinBalance() {
        return this.minBalance;
    }

    public void setMinBalance(Double minBalance) {
        this.minBalance = minBalance;
    }

    public Double getMaxBalance() {
        return this.maxBalance;
    }

    public void setMaxBalance(Double maxBalance) {
        this.maxBalance = maxBalance;
    }

    public Integer getBirthYear() {
        return this.birthYear;
    }

    public void setBirthYear(Integer birthYear) {
        this.birthYear = birthYear;
    }

    public String getNotEmptyString() {
        return this.notEmptyString;
    }

    public void setNotEmptyString(String notEmptyString) {
        this.notEmptyString = notEmptyString;
    }

    public List<String> getNotEmptyArray() {
        return this.notEmptyArray;
    }

    public void setNotEmptyArray(List<String> notEmptyArray) {
        this.notEmptyArray = notEmptyArray;
    }
}

