/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.xml.JacksonJaxbXMLProvider;
import io.swagger.config.FilterFactory;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.inflector.config.Configuration;
import io.swagger.inflector.controllers.InflectResultController;
import io.swagger.inflector.controllers.SwaggerOperationController;
import io.swagger.inflector.controllers.SwaggerResourceController;
import io.swagger.inflector.converters.Converter;
import io.swagger.inflector.converters.InputConverter;
import io.swagger.inflector.models.InflectResult;
import io.swagger.inflector.processors.JsonExampleProvider;
import io.swagger.inflector.processors.JsonNodeExampleSerializer;
import io.swagger.inflector.processors.JsonProvider;
import io.swagger.inflector.processors.XMLExampleProvider;
import io.swagger.inflector.processors.YamlExampleProvider;
import io.swagger.inflector.utils.DefaultSpecFilter;
import io.swagger.inflector.utils.ResolverUtil;
import io.swagger.inflector.validators.Validator;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerInflector
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerInflector.class);
    private Configuration config;
    private String basePath;
    private String originalBasePath;
    private ServletContext servletContext;
    private Map<String, List<String>> missingOperations = new HashMap<String, List<String>>();
    private Set<String> unimplementedMappedModels = new TreeSet<String>();

    public SwaggerInflector(Configuration configuration) {
        this.init(configuration);
    }

    public SwaggerInflector(@Context ServletContext ctx) {
        this.servletContext = ctx;
        Configuration config = null;
        if (this.servletContext != null && this.servletContext.getInitParameter("inflector-config") != null) {
            try {
                config = Configuration.read(this.servletContext.getInitParameter("inflector-config"));
            }
            catch (Exception e) {
                LOGGER.error("unable to read configuration from init param");
            }
        }
        if (config == null) {
            config = Configuration.read();
        }
        this.init(config);
    }

    protected void init(Configuration configuration) {
        String clsName;
        this.config = configuration;
        SwaggerDeserializationResult swaggerParseResult = new SwaggerParser().readWithInfo(this.config.getSwaggerUrl(), null, true);
        Swagger swagger = swaggerParseResult.getSwagger();
        if (this.config.isValidatePayloads()) {
            LOGGER.info("resolving swagger");
            new ResolverUtil().resolveFully(swagger);
        }
        if (swagger != null) {
            this.originalBasePath = swagger.getBasePath();
            StringBuilder b = new StringBuilder();
            if (!"".equals(configuration.getRootPath())) {
                b.append(configuration.getRootPath());
            }
            if (swagger.getBasePath() != null) {
                b.append(swagger.getBasePath());
            }
            if (b.length() > 0) {
                swagger.setBasePath(b.toString());
            }
            Map paths = swagger.getPaths();
            Map definitions = swagger.getDefinitions();
            for (String pathString : paths.keySet()) {
                Path path = (Path)paths.get(pathString);
                Resource.Builder builder = Resource.builder();
                this.basePath = configuration.getRootPath() + swagger.getBasePath();
                builder.path(this.basePath(this.originalBasePath, pathString));
                Operation operation = path.getGet();
                if (operation != null) {
                    this.addOperation(pathString, builder, "GET", operation, definitions);
                }
                if ((operation = path.getPost()) != null) {
                    this.addOperation(pathString, builder, "POST", operation, definitions);
                }
                if ((operation = path.getPut()) != null) {
                    this.addOperation(pathString, builder, "PUT", operation, definitions);
                }
                if ((operation = path.getDelete()) != null) {
                    this.addOperation(pathString, builder, "DELETE", operation, definitions);
                }
                if ((operation = path.getOptions()) != null) {
                    this.addOperation(pathString, builder, "OPTIONS", operation, definitions);
                }
                if ((operation = path.getPatch()) != null) {
                    this.addOperation(pathString, builder, "PATCH", operation, definitions);
                }
                this.registerResources(new Resource[]{builder.build()});
            }
        } else {
            LOGGER.error("No swagger definition detected!  Not much to do...");
        }
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new JsonNodeExampleSerializer());
        if (this.config.getFilterClass() != null) {
            if (!this.config.getFilterClass().isEmpty()) {
                try {
                    FilterFactory.setFilter((SwaggerSpecFilter)((SwaggerSpecFilter)SwaggerInflector.class.getClassLoader().loadClass(this.config.getFilterClass()).newInstance()));
                }
                catch (Exception e) {
                    LOGGER.error("Unable to set filter class " + this.config.getFilterClass());
                }
            }
        } else {
            FilterFactory.setFilter((SwaggerSpecFilter)new DefaultSpecFilter());
        }
        if (swagger == null) {
            LOGGER.error("the swagger definition is not valid");
        }
        if (this.config.getEntityProcessors().contains("json")) {
            Json.mapper().registerModule((Module)simpleModule);
            this.register(JacksonJsonProvider.class);
            this.register(JsonExampleProvider.class);
            this.register(JsonProvider.class);
            this.enableSwaggerJSON(swagger);
        }
        if (this.config.getEntityProcessors().contains("xml")) {
            this.register(JacksonJaxbXMLProvider.class);
            this.register(XMLExampleProvider.class);
        }
        if (this.config.getEntityProcessors().contains("yaml")) {
            Yaml.mapper().registerModule((Module)simpleModule);
            this.register(YamlExampleProvider.class);
            this.enableSwaggerYAML(swagger);
        }
        this.register(new MultiPartFeature());
        this.register(SwaggerSerializers.class);
        for (Class<?> exceptionMapper : this.config.getExceptionMappers()) {
            this.register(exceptionMapper);
        }
        if (this.config.getInputValidators() != null && this.config.getInputValidators().size() > 0) {
            InputConverter.getInstance().getValidators().clear();
            for (String inputValidator : this.config.getInputValidators()) {
                try {
                    clsName = inputValidator;
                    if ("requiredFieldValidator".equalsIgnoreCase(inputValidator)) {
                        clsName = "io.swagger.inflector.validators.DefaultValidator";
                    }
                    if ("numericValidator".equalsIgnoreCase(inputValidator)) {
                        clsName = "io.swagger.inflector.validators.NumericValidator";
                    }
                    if ("stringValidator".equalsIgnoreCase(inputValidator)) {
                        clsName = "io.swagger.inflector.validators.StringTypeValidator";
                    }
                    InputConverter.getInstance().addValidator((Validator)Class.forName(clsName).newInstance());
                }
                catch (Exception e) {
                    LOGGER.warn("unable to add validator `" + inputValidator + "`");
                    e.printStackTrace();
                }
            }
        } else {
            InputConverter.getInstance().defaultValidators();
        }
        if (this.config.getInputConverters() != null && this.config.getInputConverters().size() > 0) {
            InputConverter.getInstance().getConverters().clear();
            for (String converter : this.config.getInputConverters()) {
                try {
                    clsName = converter;
                    if ("defaultConverter".equalsIgnoreCase(converter)) {
                        clsName = "io.swagger.inflector.converters.DefaultConverter";
                    }
                    LOGGER.debug("adding converter `" + clsName + "`");
                    InputConverter.getInstance().addConverter((Converter)Class.forName(clsName).newInstance());
                }
                catch (Exception e) {
                    LOGGER.warn("unable to add validator `" + converter + "`");
                }
            }
        } else {
            InputConverter.getInstance().defaultConverters();
        }
        InflectResult result = new InflectResult();
        for (String key : swaggerParseResult.getMessages()) {
            result.specParseMessage(key);
        }
        for (String key : this.missingOperations.keySet()) {
            result.unimplementedControllers(key, this.missingOperations.get(key));
        }
        for (String model : this.config.getUnimplementedModels()) {
            result.unimplementedModel(model);
        }
        for (String model : this.unimplementedMappedModels) {
            result.unimplementedModel(model);
        }
        if (Configuration.Environment.DEVELOPMENT.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.debug("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.debug(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.debug(" - " + val);
                }
            }
            Resource.Builder builder = Resource.builder();
            builder.path(this.basePath(this.originalBasePath, this.config.getSwaggerBase() + "debug.json")).addMethod("GET").produces(new String[]{"application/json"}).handledBy((Inflector)new InflectResultController(result)).build();
            this.registerResources(new Resource[]{builder.build()});
        } else if (Configuration.Environment.STAGING.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.warn("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.warn(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.warn(" - " + val);
                }
            }
        } else if (Configuration.Environment.PRODUCTION.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.error("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.error(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.error(" - " + val);
                }
            }
            if (this.missingOperations.size() > 0) {
                LOGGER.error("Unable to start due to unimplemented methods");
                throw new RuntimeException("Unable to start due to unimplemented methods");
            }
        }
    }

    private String basePath(String basePath, String path) {
        if (StringUtils.isEmpty((CharSequence)basePath) || "/".equals(basePath)) {
            return path;
        }
        return basePath + path;
    }

    private void enableSwaggerJSON(Swagger swagger) {
        Resource.Builder builder = Resource.builder();
        builder.path(this.basePath(this.originalBasePath, this.config.getSwaggerBase() + "swagger.json")).addMethod("GET").produces(new String[]{"application/json"}).handledBy((Inflector)new SwaggerResourceController(swagger)).build();
        this.registerResources(new Resource[]{builder.build()});
    }

    private void enableSwaggerYAML(Swagger swagger) {
        Resource.Builder builder = Resource.builder();
        builder.path(this.basePath(this.originalBasePath, this.config.getSwaggerBase() + "swagger.yaml")).addMethod("GET").produces(new String[]{"application/yaml"}).handledBy((Inflector)new SwaggerResourceController(swagger)).build();
        this.registerResources(new Resource[]{builder.build()});
    }

    private void addOperation(String pathString, Resource.Builder builder, String method, Operation operation, Map<String, Model> definitions) {
        LOGGER.debug("adding operation for `" + pathString + "` " + method);
        SwaggerOperationController controller = new SwaggerOperationController(this.config, pathString, method, operation, definitions);
        if (controller.getMethod() == null && controller.getMethodName() != null) {
            List<String> missingMethods = this.missingOperations.get(controller.getControllerName());
            if (missingMethods == null) {
                missingMethods = new ArrayList<String>();
                this.missingOperations.put(controller.getControllerName(), missingMethods);
            }
            missingMethods.add(controller.getOperationSignature());
        }
        this.unimplementedMappedModels.addAll(controller.getUnimplementedMappedModels());
        builder.addMethod(method).handledBy((Inflector)controller);
    }
}

