/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.controllers;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.inflector.config.Configuration;
import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.converters.InputConverter;
import io.swagger.inflector.examples.ExampleBuilder;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.models.ApiError;
import io.swagger.inflector.models.RequestContext;
import io.swagger.inflector.models.ResponseContext;
import io.swagger.inflector.processors.EntityProcessorFactory;
import io.swagger.inflector.schema.SchemaValidator;
import io.swagger.inflector.utils.ApiException;
import io.swagger.inflector.utils.ReflectionUtils;
import io.swagger.inflector.validators.ValidationException;
import io.swagger.inflector.validators.ValidationMessage;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerOperationController
extends ReflectionUtils
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerOperationController.class);
    private static Set<String> commonHeaders = new HashSet<String>();
    private boolean validatePayload = true;
    private String path;
    private String httpMethod;
    private Operation operation;
    private Object controller = null;
    private Method method = null;
    private JavaType[] parameterClasses = null;
    private Map<String, Model> definitions;
    private InputConverter validator;
    private String controllerName;
    private String methodName;
    private String operationSignature;

    public SwaggerOperationController(Configuration config, String path, String httpMethod, Operation operation, Map<String, Model> definitions) {
        this.setConfiguration(config);
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
        this.definitions = definitions;
        this.validator = InputConverter.getInstance();
        this.method = this.detectMethod(operation);
        if (this.method == null) {
            LOGGER.debug("no method `" + this.methodName + "` in `" + this.controllerName + "` to map to, using mock response");
        }
    }

    public Method detectMethod(Operation operation) {
        this.controllerName = this.getControllerName(operation);
        this.methodName = this.getMethodName(this.path, this.httpMethod, operation);
        JavaType[] args = this.getOperationParameterClasses(operation, this.definitions);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName(this.path, this.httpMethod, operation)).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                builder.append(RequestContext.class.getCanonicalName()).append(" request");
                continue;
            }
            builder.append(", ");
            if (args[i] == null) {
                LOGGER.error("didn't expect a null class for " + ((Parameter)operation.getParameters().get(i - 1)).getName());
                continue;
            }
            if (args[i].getRawClass() == null) continue;
            String className = args[i].getRawClass().getName();
            if (className.startsWith("java.lang.")) {
                className = className.substring("java.lang.".length());
            }
            builder.append(className);
            builder.append(" ").append(((Parameter)operation.getParameters().get(i - 1)).getName());
        }
        builder.append(")");
        this.operationSignature = "public io.swagger.inflector.models.ResponseContext " + builder.toString();
        LOGGER.info("looking for method: `" + this.operationSignature + "` in class `" + this.controllerName + "`");
        this.parameterClasses = args;
        if (this.controllerName != null && this.methodName != null) {
            try {
                Method[] methods;
                Class<?> cls;
                try {
                    cls = Class.forName(this.controllerName);
                }
                catch (ClassNotFoundException e) {
                    this.controllerName = this.controllerName + "Controller";
                    cls = Class.forName(this.controllerName);
                }
                for (Method method : methods = cls.getMethods()) {
                    Class<?>[] methodArgs;
                    if (!this.methodName.equals(method.getName()) || (methodArgs = method.getParameterTypes()).length != args.length) continue;
                    int i = 0;
                    boolean matched = true;
                    if (!args[i].getRawClass().equals(methodArgs[i])) {
                        LOGGER.debug("failed to match " + args[i] + ", " + methodArgs[i]);
                        matched = false;
                    }
                    if (!matched) continue;
                    this.parameterClasses = args;
                    this.controller = this.config.getControllerFactory().instantiateController(cls);
                    LOGGER.debug("found class `" + this.controllerName + "`");
                    return method;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("didn't find class " + this.controller);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Response apply(ContainerRequestContext ctx) {
        List parameters = this.operation.getParameters();
        RequestContext requestContext = new RequestContext(ctx);
        String path = ctx.getUriInfo().getPath();
        Object[] args = new Object[parameters.size() + 1];
        if (parameters != null) {
            int i = 0;
            args[i] = requestContext;
            ++i;
            ArrayList<ValidationMessage> missingParams = new ArrayList<ValidationMessage>();
            UriInfo uri = ctx.getUriInfo();
            String formDataString = null;
            String[] parts = null;
            HashSet<String> existingKeys = new HashSet<String>();
            Iterator x = uri.getQueryParameters().keySet().iterator();
            while (x.hasNext()) {
                existingKeys.add((String)x.next() + ": qp");
            }
            x = uri.getPathParameters().keySet().iterator();
            while (x.hasNext()) {
                existingKeys.add((String)x.next() + ": pp");
            }
            for (String key : ctx.getHeaders().keySet()) {
            }
            for (Parameter p : parameters) {
                if (!(p instanceof FormParameter) || formDataString != null) continue;
                try {
                    formDataString = IOUtils.toString((InputStream)ctx.getEntityStream(), (String)"UTF-8");
                    for (String part : parts = formDataString.split("&")) {
                        String[] kv = part.split("=");
                        existingKeys.add(kv[0] + ": fp");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (Parameter parameter : parameters) {
                Object o;
                block60: {
                    String in = parameter.getIn();
                    o = null;
                    try {
                        if ("formData".equals(in)) {
                            SerializableParameter sp = (SerializableParameter)parameter;
                            if ("file".equals(sp.getType())) {
                                o = ctx.getEntityStream();
                            } else if (formDataString != null) {
                                for (String part : parts) {
                                    String[] kv = part.split("=");
                                    if (kv == null) continue;
                                    if (kv.length > 0) {
                                        existingKeys.remove(kv[0] + ": fp");
                                    }
                                    if (kv.length != 2) continue;
                                    String key = kv[0];
                                    String value = kv[1];
                                    if (!parameter.getName().equals(key)) continue;
                                    JavaType jt = this.parameterClasses[i];
                                    Class cls = jt.getRawClass();
                                    try {
                                        o = this.validator.convertAndValidate(Arrays.asList(value), parameter, cls, this.definitions);
                                    }
                                    catch (ConversionException e) {
                                        missingParams.add(e.getError());
                                    }
                                    catch (ValidationException e) {
                                        missingParams.add(e.getValidationMessage());
                                    }
                                }
                            }
                            break block60;
                        }
                        try {
                            String paramName = parameter.getName();
                            if ("query".equals(in)) {
                                existingKeys.remove(paramName + ": qp");
                            }
                            if ("path".equals(in)) {
                                existingKeys.remove(paramName + ": pp");
                            }
                            JavaType jt = this.parameterClasses[i];
                            Class cls = jt.getRawClass();
                            if ("body".equals(in)) {
                                if (ctx.hasEntity()) {
                                    BodyParameter body = (BodyParameter)parameter;
                                    o = EntityProcessorFactory.readValue(ctx.getMediaType(), ctx.getEntityStream(), cls);
                                    if (o != null && this.validatePayload) {
                                        this.validate(o, body.getSchema(), SchemaValidator.Direction.INPUT);
                                    }
                                } else if (parameter.getRequired()) {
                                    ValidationException e = new ValidationException();
                                    e.message(new ValidationMessage().message("The input body `" + paramName + "` is required"));
                                    throw e;
                                }
                            }
                            if ("query".equals(in)) {
                                o = this.validator.convertAndValidate((List)uri.getQueryParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                            } else if ("path".equals(in)) {
                                o = this.validator.convertAndValidate((List)uri.getPathParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                            } else if ("header".equals(in)) {
                                o = this.validator.convertAndValidate((List)ctx.getHeaders().get((Object)parameter.getName()), parameter, cls, this.definitions);
                            }
                        }
                        catch (ConversionException e) {
                            missingParams.add(e.getError());
                        }
                        catch (ValidationException e) {
                            missingParams.add(e.getValidationMessage());
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Couldn't find " + parameter.getName() + " (" + in + ") to " + this.parameterClasses[i], (Throwable)e);
                    }
                }
                args[i] = o;
                ++i;
            }
            if (existingKeys.size() > 0) {
                LOGGER.debug("unexpected keys: " + existingKeys);
            }
            if (missingParams.size() > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("Input error");
                if (missingParams.size() > 1) {
                    builder.append("s");
                }
                builder.append(": ");
                int count = 0;
                for (ValidationMessage message : missingParams) {
                    if (count > 0) {
                        builder.append(", ");
                    }
                    if (message != null && message.getMessage() != null) {
                        builder.append(message.getMessage());
                    } else {
                        builder.append("no additional input");
                    }
                    ++count;
                }
                int statusCode = this.config.getInvalidRequestStatusCode();
                ApiError error = new ApiError().code(statusCode).message(builder.toString());
                throw new ApiException(error);
            }
        }
        if (this.method != null) {
            LOGGER.info("calling method " + this.method + " on controller " + this.controller + " with args " + Arrays.toString(args));
            try {
                Object response = this.method.invoke(this.controller, args);
                if (response instanceof ResponseContext) {
                    ResponseContext wrapper = (ResponseContext)response;
                    Response.ResponseBuilder builder = Response.status((int)wrapper.getStatus());
                    for (String key : wrapper.getHeaders().keySet()) {
                        builder.header(key, wrapper.getHeaders().get((Object)key));
                    }
                    if (wrapper.getContentType() != null) {
                        builder.type(wrapper.getContentType());
                    }
                    if (wrapper.getEntity() != null) {
                        builder.entity(wrapper.getEntity());
                        if (this.validatePayload && this.operation.getResponses() != null) {
                            String responseCode = "" + wrapper.getStatus();
                            io.swagger.models.Response responseSchema = (io.swagger.models.Response)this.operation.getResponses().get(responseCode);
                            if (responseSchema == null) {
                                responseSchema = (io.swagger.models.Response)this.operation.getResponses().get("default");
                            }
                            if (responseSchema != null && responseSchema.getSchema() != null) {
                                this.validate(wrapper.getEntity(), responseSchema.getSchema(), SchemaValidator.Direction.OUTPUT);
                            } else {
                                LOGGER.debug("no response schema for code " + responseCode + " to validate against");
                            }
                        }
                    }
                    return builder.build();
                }
                return Response.ok().entity(response).build();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error("failed to invoke method " + this.method, (Throwable)e);
                Throwable cause = e.getCause();
                while (cause != null) {
                    if (cause instanceof ApiException) {
                        throw (ApiException)cause;
                    }
                    Throwable next = cause.getCause();
                    cause = next == cause || next == null ? null : next;
                }
                ApiError error = new ApiError().message("failed to invoke controller").code(500);
                throw new ApiException(error, (Throwable)e);
            }
        }
        Map responses = this.operation.getResponses();
        if (responses != null) {
            io.swagger.models.Response response;
            Example output;
            String[] keys = new String[responses.keySet().size()];
            Arrays.sort(responses.keySet().toArray(keys));
            int code = 0;
            String defaultKey = null;
            for (String key : keys) {
                if (key.startsWith("2")) {
                    defaultKey = key;
                    code = Integer.parseInt(key);
                    break;
                }
                if (!"default".equals(key)) continue;
                defaultKey = key;
                code = 200;
            }
            if ((output = ExampleBuilder.fromProperty((response = (io.swagger.models.Response)responses.get(defaultKey)).getSchema(), this.definitions)) != null) {
                ResponseContext resp = new ResponseContext().entity(output);
                this.setContentType(requestContext, resp, this.operation);
                if (resp.getContentType() != null) {
                    return Response.status((int)code).entity((Object)output).type(resp.getContentType()).build();
                }
                return Response.status((int)code).entity((Object)output).build();
            }
            return Response.status((int)code).build();
        }
        return Response.ok().build();
    }

    public void validate(Object o, Property property, SchemaValidator.Direction direction) throws ApiException {
        boolean isValid;
        if (this.config.isValidatePayloads() && !(isValid = SchemaValidator.validate(o, Json.pretty((Object)property), direction))) {
            if (SchemaValidator.Direction.INPUT.equals((Object)direction)) {
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("Input does not match the expected structure"));
            }
            throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("The server generated an invalid response"));
        }
    }

    public void validate(Object o, Model model, SchemaValidator.Direction direction) throws ApiException {
        boolean isValid;
        if (this.config.isValidatePayloads() && !(isValid = SchemaValidator.validate(o, Json.pretty((Object)model), direction))) {
            if (SchemaValidator.Direction.INPUT.equals((Object)direction)) {
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("Input does not match the expected structure"));
            }
            throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("The server generated an invalid response"));
        }
    }

    public void setContentType(RequestContext res, ResponseContext resp, Operation operation) {
        if (resp.getContentType() != null) {
            return;
        }
        List available = operation.getProduces();
        if (available != null) {
            for (String a : available) {
                MediaType mt = MediaType.valueOf((String)a);
                for (MediaType acceptable : res.getAcceptableMediaTypes()) {
                    if (!mt.isCompatible(acceptable)) continue;
                    resp.setContentType(mt);
                    return;
                }
            }
            if (available.size() > 0) {
                resp.setContentType(MediaType.valueOf((String)((String)available.get(0))));
            }
        }
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public void setOperationSignature(String operationSignature) {
        this.operationSignature = operationSignature;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    static {
        commonHeaders.add("Host");
        commonHeaders.add("User-Agent");
        commonHeaders.add("Accept");
        commonHeaders.add("Content-Type");
        commonHeaders.add("Content-Length");
    }
}

