/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.examples;

import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.ObjectExample;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlExampleSerializer {
    int depth = 0;

    public String serialize(Example o) {
        XMLStreamWriter writer = null;
        try {
            XMLOutputFactory f = XMLOutputFactory.newFactory();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            writer = f.createXMLStreamWriter(out);
            writer.writeStartDocument("UTF-8", "1.1");
            this.writeTo(writer, o);
            writer.close();
            return out.toString();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeTo(XMLStreamWriter writer, Example o) throws XMLStreamException {
        ++this.depth;
        if (o instanceof ObjectExample) {
            ObjectExample or = (ObjectExample)o;
            String name = o.getName();
            if (this.depth == 1 && name == null) {
                name = this.getTypeName(o);
            }
            writer.writeStartElement(o.getPrefix(), name, o.getNamespace());
            for (String key : or.keySet()) {
                Object obj = or.get(key);
                if (!(obj instanceof Example)) continue;
                this.writeTo(writer, (Example)obj);
            }
            writer.writeEndElement();
        } else if (o instanceof ArrayExample) {
            ArrayExample ar = (ArrayExample)o;
            if (o.getWrapped() != null && o.getWrapped().booleanValue()) {
                if (o.getWrappedName() != null) {
                    writer.writeStartElement(o.getPrefix(), o.getWrappedName(), o.getNamespace());
                } else {
                    writer.writeStartElement(o.getPrefix(), o.getName() + "s", o.getNamespace());
                }
            }
            for (Example item : ar.getItems()) {
                if (item.getName() == null) {
                    writer.writeStartElement(o.getPrefix(), o.getName(), o.getNamespace());
                }
                this.writeTo(writer, item);
                if (item.getName() != null) continue;
                writer.writeEndElement();
            }
            if (o.getWrapped() != null && o.getWrapped().booleanValue()) {
                writer.writeEndElement();
            }
        } else {
            String name = o.getName();
            if (this.depth == 1 && name == null) {
                name = this.getTypeName(o);
            }
            if (o.getAttribute() != null && o.getAttribute().booleanValue()) {
                writer.writeAttribute(o.getPrefix(), name, o.getNamespace(), o.asString());
            } else if (name == null) {
                writer.writeCharacters(o.asString());
            } else {
                writer.writeStartElement(o.getPrefix(), name, o.getNamespace());
                writer.writeCharacters(o.asString());
                writer.writeEndElement();
            }
        }
    }

    public String getTypeName(Example o) {
        return o.getTypeName();
    }
}

