/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.processors;

import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.processors.EntityProcessor;
import io.swagger.inflector.processors.JacksonProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class EntityProcessorFactory {
    private static List<EntityProcessor> PROCESSORS = new ArrayList<EntityProcessor>();

    public static void addProcessor(EntityProcessor processor) {
        PROCESSORS.add(processor);
    }

    public static Object readValue(MediaType mediaType, InputStream entityStream, Class<?> class1) throws ConversionException {
        for (EntityProcessor p : EntityProcessorFactory.getProcessors()) {
            if (!p.supports(mediaType)) continue;
            return p.process(mediaType, entityStream, class1);
        }
        return null;
    }

    public static List<EntityProcessor> getProcessors() {
        return PROCESSORS;
    }

    static {
        PROCESSORS.add(new JacksonProcessor());
    }
}

