/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.inflector.models.ApiError;
import io.swagger.inflector.utils.ApiException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        if (exception instanceof ApiException) {
            ApiException ae = (ApiException)exception;
            return Response.status((int)ae.getError().getCode()).entity((Object)ae.getError()).build();
        }
        if (exception instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)exception;
            ApiError output = new ApiError().code(e.getResponse().getStatus()).message(e.getMessage());
            return Response.status((int)e.getResponse().getStatus()).entity((Object)output).build();
        }
        ApiError output = new ApiError().code(500).message(exception.getMessage());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)output).build();
    }
}

