/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.examples;

import io.swagger.inflector.examples.models.AbstractExample;
import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.BooleanExample;
import io.swagger.inflector.examples.models.DecimalExample;
import io.swagger.inflector.examples.models.DoubleExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.FloatExample;
import io.swagger.inflector.examples.models.IntegerExample;
import io.swagger.inflector.examples.models.LongExample;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.examples.models.StringExample;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleBuilder.class);
    public static final String SAMPLE_EMAIL_PROPERTY_VALUE = "apiteam@swagger.io";
    public static final String SAMPLE_UUID_PROPERTY_VALUE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    public static final String SAMPLE_STRING_PROPERTY_VALUE = "string";
    public static final int SAMPLE_INT_PROPERTY_VALUE = 0;
    public static final int SAMPLE_LONG_PROPERTY_VALUE = 0;
    public static final int SAMPLE_BASE_INTEGER_PROPERTY_VALUE = 0;
    public static final float SAMPLE_FLOAT_PROPERTY_VALUE = 1.1f;
    public static final double SAMPLE_DOUBLE_PROPERTY_VALUE = (double)1.1f;
    public static final boolean SAMPLE_BOOLEAN_PROPERTY_VALUE = true;
    public static final String SAMPLE_DATE_PROPERTY_VALUE = "2015-07-20";
    public static final String SAMPLE_DATETIME_PROPERTY_VALUE = "2015-07-20T15:49:04-07:00";
    public static final double SAMPLE_DECIMAL_PROPERTY_VALUE = 1.5;

    public static Example fromProperty(Property property, Map<String, Model> definitions) {
        return ExampleBuilder.fromProperty(property, definitions, new HashMap<String, Example>());
    }

    public static Example fromProperty(Property property, Map<String, Model> definitions, Set<String> processedModels) {
        return ExampleBuilder.fromProperty(property, definitions, ExampleBuilder.createNullFiledMap(processedModels));
    }

    public static Example fromProperty(Property property, Map<String, Model> definitions, Map<String, Example> processedModels) {
        Model model;
        RefProperty ref;
        Example output;
        Boolean wrapped;
        Boolean attribute;
        String prefix;
        String namespace;
        String name;
        block63: {
            MapProperty mp;
            Property inner;
            block77: {
                Example innerExample;
                block78: {
                    Object example;
                    block76: {
                        block75: {
                            block74: {
                                List enums;
                                block73: {
                                    block72: {
                                        Object defaultValue;
                                        block71: {
                                            List enums2;
                                            block70: {
                                                block69: {
                                                    block68: {
                                                        block67: {
                                                            block66: {
                                                                block65: {
                                                                    block64: {
                                                                        block62: {
                                                                            if (property == null) {
                                                                                return null;
                                                                            }
                                                                            name = null;
                                                                            namespace = null;
                                                                            prefix = null;
                                                                            attribute = false;
                                                                            wrapped = false;
                                                                            if (property.getXml() != null) {
                                                                                Xml xml = property.getXml();
                                                                                name = xml.getName();
                                                                                namespace = xml.getNamespace();
                                                                                prefix = xml.getPrefix();
                                                                                attribute = xml.getAttribute();
                                                                                wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
                                                                            }
                                                                            output = null;
                                                                            example = property.getExample();
                                                                            if (!(property instanceof RefProperty)) break block62;
                                                                            ref = (RefProperty)property;
                                                                            if (processedModels.containsKey(ref.getSimpleRef())) {
                                                                                return ExampleBuilder.alreadyProcessedRefExample(ref.getSimpleRef(), definitions, processedModels);
                                                                            }
                                                                            processedModels.put(ref.getSimpleRef(), null);
                                                                            if (definitions != null && (model = definitions.get(ref.getSimpleRef())) != null) {
                                                                                output = ExampleBuilder.fromModel(ref.getSimpleRef(), model, definitions, processedModels);
                                                                                processedModels.put(ref.getSimpleRef(), output);
                                                                            }
                                                                            break block63;
                                                                        }
                                                                        if (!(property instanceof EmailProperty)) break block64;
                                                                        if (example != null) {
                                                                            output = new StringExample(example.toString());
                                                                        } else {
                                                                            defaultValue = ((EmailProperty)property).getDefault();
                                                                            if (defaultValue == null && (enums2 = ((EmailProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                                                defaultValue = (String)enums2.get(0);
                                                                            }
                                                                            output = new StringExample((String)(defaultValue == null ? SAMPLE_EMAIL_PROPERTY_VALUE : defaultValue));
                                                                        }
                                                                        break block63;
                                                                    }
                                                                    if (!(property instanceof UUIDProperty)) break block65;
                                                                    if (example != null) {
                                                                        output = new StringExample(example.toString());
                                                                    } else {
                                                                        defaultValue = ((UUIDProperty)property).getDefault();
                                                                        if (defaultValue == null && (enums2 = ((UUIDProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                                            defaultValue = (String)enums2.get(0);
                                                                        }
                                                                        output = new StringExample((String)(defaultValue == null ? SAMPLE_UUID_PROPERTY_VALUE : defaultValue));
                                                                    }
                                                                    break block63;
                                                                }
                                                                if (!(property instanceof StringProperty)) break block66;
                                                                if (example != null) {
                                                                    output = new StringExample(example.toString());
                                                                } else {
                                                                    defaultValue = ((StringProperty)property).getDefault();
                                                                    if (defaultValue == null && (enums2 = ((StringProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                                        defaultValue = (String)enums2.get(0);
                                                                    }
                                                                    output = new StringExample((String)(defaultValue == null ? SAMPLE_STRING_PROPERTY_VALUE : defaultValue));
                                                                }
                                                                break block63;
                                                            }
                                                            if (!(property instanceof IntegerProperty)) break block67;
                                                            if (example != null) {
                                                                try {
                                                                    output = new IntegerExample(Integer.parseInt(example.toString()));
                                                                }
                                                                catch (NumberFormatException defaultValue2) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (output == null) {
                                                                defaultValue = ((IntegerProperty)property).getDefault();
                                                                if (defaultValue == null && (enums2 = ((IntegerProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                                    defaultValue = (Integer)enums2.get(0);
                                                                }
                                                                output = new IntegerExample(defaultValue == null ? 0 : (Integer)defaultValue);
                                                            }
                                                            break block63;
                                                        }
                                                        if (!(property instanceof LongProperty)) break block68;
                                                        if (example != null) {
                                                            try {
                                                                output = new LongExample(Long.parseLong(example.toString()));
                                                            }
                                                            catch (NumberFormatException defaultValue3) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (output == null) {
                                                            defaultValue = ((LongProperty)property).getDefault();
                                                            if (defaultValue == null && (enums2 = ((LongProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                                defaultValue = (Long)enums2.get(0);
                                                            }
                                                            output = new LongExample(defaultValue == null ? 0L : (Long)defaultValue);
                                                        }
                                                        break block63;
                                                    }
                                                    if (!(property instanceof BaseIntegerProperty)) break block69;
                                                    if (example != null) {
                                                        try {
                                                            output = new IntegerExample(Integer.parseInt(example.toString()));
                                                        }
                                                        catch (NumberFormatException defaultValue4) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (output == null) {
                                                        output = new IntegerExample(0);
                                                    }
                                                    break block63;
                                                }
                                                if (!(property instanceof FloatProperty)) break block70;
                                                if (example != null) {
                                                    try {
                                                        output = new FloatExample(Float.parseFloat(example.toString()));
                                                    }
                                                    catch (NumberFormatException defaultValue4) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (output == null) {
                                                    defaultValue = ((FloatProperty)property).getDefault();
                                                    if (defaultValue == null && (enums2 = ((FloatProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                        defaultValue = (Float)enums2.get(0);
                                                    }
                                                    output = new FloatExample(defaultValue == null ? 1.1f : ((Float)defaultValue).floatValue());
                                                }
                                                break block63;
                                            }
                                            if (!(property instanceof DoubleProperty)) break block71;
                                            if (example != null) {
                                                try {
                                                    output = new DoubleExample(Double.parseDouble(example.toString()));
                                                }
                                                catch (NumberFormatException defaultValue5) {
                                                    // empty catch block
                                                }
                                            }
                                            if (output == null) {
                                                defaultValue = ((DoubleProperty)property).getDefault();
                                                if (defaultValue == null && (enums2 = ((DoubleProperty)property).getEnum()) != null && !enums2.isEmpty()) {
                                                    defaultValue = (Double)enums2.get(0);
                                                }
                                                output = new DoubleExample(defaultValue == null ? (double)1.1f : (Double)defaultValue);
                                            }
                                            break block63;
                                        }
                                        if (!(property instanceof BooleanProperty)) break block72;
                                        output = example != null ? new BooleanExample(Boolean.valueOf(example.toString())) : new BooleanExample((defaultValue = ((BooleanProperty)property).getDefault()) == null ? true : (Boolean)defaultValue);
                                        break block63;
                                    }
                                    if (!(property instanceof DateProperty)) break block73;
                                    output = example != null ? new StringExample(example.toString()) : ((enums = ((DateProperty)property).getEnum()) != null && !enums.isEmpty() ? new StringExample((String)enums.get(0)) : new StringExample(SAMPLE_DATE_PROPERTY_VALUE));
                                    break block63;
                                }
                                if (!(property instanceof DateTimeProperty)) break block74;
                                output = example != null ? new StringExample(example.toString()) : ((enums = ((DateTimeProperty)property).getEnum()) != null && !enums.isEmpty() ? new StringExample((String)enums.get(0)) : new StringExample(SAMPLE_DATETIME_PROPERTY_VALUE));
                                break block63;
                            }
                            if (!(property instanceof DecimalProperty)) break block75;
                            if (example != null) {
                                try {
                                    output = new DecimalExample(new BigDecimal(example.toString()));
                                }
                                catch (NumberFormatException enums) {
                                    // empty catch block
                                }
                            }
                            if (output == null) {
                                output = new DecimalExample(new BigDecimal(1.5));
                            }
                            break block63;
                        }
                        if (!(property instanceof ObjectProperty)) break block76;
                        if (processedModels.containsKey(property.getName())) {
                            return ExampleBuilder.alreadyProcessedRefExample(property.getName(), definitions, processedModels);
                        }
                        if (example != null) {
                            try {
                                output = (Example)Json.mapper().readValue(Json.mapper().writeValueAsString(example), ObjectExample.class);
                            }
                            catch (IOException e) {
                                LOGGER.error("unable to convert `" + example + "` to JsonNode");
                                output = new ObjectExample();
                            }
                        } else {
                            ObjectExample outputExample = new ObjectExample();
                            outputExample.setName(property.getName());
                            ObjectProperty op = (ObjectProperty)property;
                            if (op.getProperties() != null) {
                                for (String propertyname : op.getProperties().keySet()) {
                                    Property inner2 = (Property)op.getProperties().get(propertyname);
                                    Example innerExample2 = ExampleBuilder.fromProperty(inner2, definitions, processedModels);
                                    outputExample.put(propertyname, innerExample2);
                                }
                            }
                            output = outputExample;
                        }
                        break block63;
                    }
                    if (!(property instanceof ArrayProperty)) break block77;
                    if (example == null) break block78;
                    try {
                        output = (Example)Json.mapper().readValue(Json.mapper().writeValueAsString(example), ArrayExample.class);
                    }
                    catch (IOException e) {
                        LOGGER.error("unable to convert `" + example + "` to JsonNode");
                        output = new ArrayExample();
                    }
                    break block63;
                }
                ArrayProperty ap = (ArrayProperty)property;
                inner = ap.getItems();
                if (inner == null || (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) == null || !(innerExample instanceof Example)) break block63;
                if (ap.getXml() == null || Boolean.FALSE.equals(ap.getXml().getWrapped())) {
                    innerExample.setName(null);
                }
                ArrayExample an = new ArrayExample();
                an.add(innerExample);
                an.setName(property.getName());
                output = an;
                break block63;
            }
            if (property instanceof MapProperty && (inner = (mp = (MapProperty)property).getAdditionalProperties()) != null) {
                ObjectExample on = new ObjectExample();
                for (int i = 1; i <= 3; ++i) {
                    Example innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels);
                    if (innerExample == null) continue;
                    String key = "additionalProp" + i;
                    on.put(key, innerExample);
                    output = on;
                }
            }
        }
        if (property instanceof RefProperty && output == null && definitions != null) {
            ref = (RefProperty)property;
            model = definitions.get(ref.getSimpleRef());
            if (model != null) {
                output = ExampleBuilder.fromModel(ref.getSimpleRef(), model, definitions, processedModels);
            }
            if (output != null) {
                output.setName(ref.getSimpleRef());
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue()) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static Example alreadyProcessedRefExample(String name, Map<String, Model> definitions, Map<String, Example> processedExamples) {
        ModelImpl impl;
        if (processedExamples.get(name) != null) {
            return processedExamples.get(name);
        }
        Model model = definitions.get(name);
        if (model == null) {
            return null;
        }
        Example output = null;
        if (model instanceof ModelImpl && (impl = (ModelImpl)model).getType() != null) {
            if ("object".equals(impl.getType())) {
                return new ObjectExample();
            }
            if (SAMPLE_STRING_PROPERTY_VALUE.equals(impl.getType())) {
                return new StringExample("");
            }
            if ("integer".equals(impl.getType())) {
                return new IntegerExample(0);
            }
            if ("long".equals(impl.getType())) {
                return new LongExample(0L);
            }
            if ("float".equals(impl.getType())) {
                return new FloatExample(0.0f);
            }
            if ("double".equals(impl.getType())) {
                return new DoubleExample(0.0);
            }
        }
        return output;
    }

    public static Example fromModel(String name, Model model, Map<String, Model> definitions, Set<String> processedModels) {
        return ExampleBuilder.fromModel(name, model, definitions, ExampleBuilder.createNullFiledMap(processedModels));
    }

    private static Map<String, Example> createNullFiledMap(Set<String> processedModels) {
        HashMap<String, Example> processedModelsMap = new HashMap<String, Example>();
        if (processedModels != null) {
            for (String processedModel : processedModels) {
                processedModelsMap.put(processedModel, null);
            }
        }
        return processedModelsMap;
    }

    public static <T extends Number> Example fromNumberModel(ModelImpl impl, Class<T> clazz) {
        Object example = impl.getExample();
        AbstractExample output = null;
        if (example != null) {
            try {
                output = Integer.class.isAssignableFrom(clazz) ? new IntegerExample(Integer.parseInt(example.toString())) : (Long.class.isAssignableFrom(clazz) ? new LongExample(Long.parseLong(example.toString())) : (Double.class.isAssignableFrom(clazz) ? new DoubleExample(Double.parseDouble(example.toString())) : (Float.class.isAssignableFrom(clazz) ? new FloatExample(Float.parseFloat(example.toString())) : new IntegerExample(Integer.parseInt(example.toString())))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (output == null) {
            List enums;
            Object defaultValue = null;
            try {
                if (Integer.class.isAssignableFrom(clazz)) {
                    defaultValue = impl.getDefaultValue() == null ? null : Integer.valueOf(defaultValue.toString());
                } else if (Long.class.isAssignableFrom(clazz)) {
                    defaultValue = impl.getDefaultValue() == null ? null : Long.valueOf(defaultValue.toString());
                } else if (Double.class.isAssignableFrom(clazz)) {
                    defaultValue = impl.getDefaultValue() == null ? null : Double.valueOf(defaultValue.toString());
                } else if (Float.class.isAssignableFrom(clazz)) {
                    defaultValue = impl.getDefaultValue() == null ? null : Float.valueOf(defaultValue.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defaultValue == null && (enums = impl.getEnum()) != null && !enums.isEmpty()) {
                try {
                    if (Integer.class.isAssignableFrom(clazz)) {
                        defaultValue = impl.getDefaultValue() == null ? null : Integer.valueOf((String)enums.get(0));
                    } else if (Long.class.isAssignableFrom(clazz)) {
                        defaultValue = impl.getDefaultValue() == null ? null : Long.valueOf((String)enums.get(0));
                    } else if (Double.class.isAssignableFrom(clazz)) {
                        defaultValue = impl.getDefaultValue() == null ? null : Double.valueOf((String)enums.get(0));
                    } else if (Float.class.isAssignableFrom(clazz)) {
                        defaultValue = impl.getDefaultValue() == null ? null : Float.valueOf((String)enums.get(0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                output = new IntegerExample(defaultValue == null ? 0 : (Integer)defaultValue);
            } else if (Long.class.isAssignableFrom(clazz)) {
                output = new LongExample(defaultValue == null ? 0L : (Long)defaultValue);
            } else if (Double.class.isAssignableFrom(clazz)) {
                output = new DoubleExample(defaultValue == null ? (double)1.1f : (Double)defaultValue);
            } else if (Float.class.isAssignableFrom(clazz)) {
                output = new FloatExample(defaultValue == null ? 1.1f : ((Float)defaultValue).floatValue());
            }
        }
        return output;
    }

    public static Example fromModel(String name, Model model, Map<String, Model> definitions, Map<String, Example> processedModels) {
        if (model == null) {
            return null;
        }
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        Boolean wrapped = false;
        Example output = null;
        Object example = model.getExample();
        if (model instanceof ModelImpl) {
            String modelType;
            ModelImpl impl = (ModelImpl)model;
            String string = modelType = impl.getType() != null ? impl.getType() : "";
            if (impl.getXml() != null) {
                Xml xml = impl.getXml();
                name = xml.getName();
                namespace = xml.getNamespace();
                prefix = xml.getPrefix();
                attribute = xml.getAttribute();
                wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
            }
            ObjectExample ex = new ObjectExample();
            block11 : switch (modelType) {
                case "string": {
                    List enums;
                    String defaultValue;
                    if (example != null) {
                        output = new StringExample(example.toString());
                        break;
                    }
                    String string2 = defaultValue = impl.getDefaultValue() == null ? null : impl.getDefaultValue().toString();
                    if (defaultValue == null && (enums = impl.getEnum()) != null && !enums.isEmpty()) {
                        defaultValue = (String)enums.get(0);
                    }
                    String samplePropertyValue = SAMPLE_STRING_PROPERTY_VALUE;
                    if (!StringUtils.isBlank((CharSequence)impl.getFormat())) {
                        switch (impl.getFormat()) {
                            case "email": {
                                samplePropertyValue = SAMPLE_EMAIL_PROPERTY_VALUE;
                                break;
                            }
                            case "uuid": {
                                samplePropertyValue = SAMPLE_UUID_PROPERTY_VALUE;
                                break;
                            }
                            case "date": {
                                samplePropertyValue = SAMPLE_DATE_PROPERTY_VALUE;
                                break;
                            }
                            case "datetime": {
                                samplePropertyValue = SAMPLE_DATETIME_PROPERTY_VALUE;
                                break;
                            }
                            default: {
                                samplePropertyValue = SAMPLE_STRING_PROPERTY_VALUE;
                            }
                        }
                    }
                    output = new StringExample(defaultValue == null ? samplePropertyValue : defaultValue);
                    break;
                }
                case "integer": {
                    if (StringUtils.isBlank((CharSequence)impl.getFormat())) {
                        output = ExampleBuilder.fromNumberModel(impl, Integer.class);
                        break;
                    }
                    switch (impl.getFormat()) {
                        case "int32": {
                            output = ExampleBuilder.fromNumberModel(impl, Integer.class);
                            break block11;
                        }
                        case "int64": {
                            output = ExampleBuilder.fromNumberModel(impl, Long.class);
                            break block11;
                        }
                    }
                    output = ExampleBuilder.fromNumberModel(impl, Integer.class);
                    break;
                }
                case "number": {
                    if (StringUtils.isBlank((CharSequence)impl.getFormat())) {
                        output = ExampleBuilder.fromNumberModel(impl, Double.class);
                        break;
                    }
                    switch (impl.getFormat()) {
                        case "double": {
                            output = ExampleBuilder.fromNumberModel(impl, Double.class);
                            break block11;
                        }
                        case "float": {
                            output = ExampleBuilder.fromNumberModel(impl, Float.class);
                            break block11;
                        }
                    }
                    output = ExampleBuilder.fromNumberModel(impl, Double.class);
                    break;
                }
                case "boolean": {
                    if (example != null) {
                        output = new BooleanExample(Boolean.valueOf(example.toString()));
                        break;
                    }
                    Boolean defaultValue = impl.getDefaultValue() == null ? null : Boolean.valueOf(impl.getDefaultValue().toString());
                    output = new BooleanExample(defaultValue == null ? true : defaultValue);
                    break;
                }
                default: {
                    if (example != null) {
                        try {
                            output = (Example)Json.mapper().readValue(Json.mapper().writeValueAsString(example), ObjectExample.class);
                        }
                        catch (IOException e) {
                            LOGGER.error("unable to convert `" + example + "` to JsonNode");
                            output = new ObjectExample();
                        }
                        break;
                    }
                    if (impl.getProperties() != null) {
                        for (String key : impl.getProperties().keySet()) {
                            Property property = (Property)impl.getProperties().get(key);
                            if (property instanceof ObjectProperty) {
                                property.setName(StringUtils.capitalize((String)key));
                            }
                            Example propExample = ExampleBuilder.fromProperty(property, definitions, processedModels);
                            ex.put(key, propExample);
                        }
                    }
                    if (impl.getAdditionalProperties() != null) {
                        Property additionalProperties = impl.getAdditionalProperties();
                        for (int i = 1; i <= 3; ++i) {
                            Example propExample = ExampleBuilder.fromProperty(additionalProperties, definitions, processedModels);
                            String key = "additionalProp" + i;
                            if (propExample == null || ex.keySet().contains(key)) continue;
                            ex.put(key, propExample);
                        }
                    }
                    output = ex;
                }
            }
        } else if (model instanceof ComposedModel) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(Json.mapper().writeValueAsString(example), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ComposedModel cm = (ComposedModel)model;
                List models = cm.getAllOf();
                ObjectExample ex = new ObjectExample();
                ArrayList<Example> innerExamples = new ArrayList<Example>();
                if (models != null) {
                    for (Model im : models) {
                        Example innerExample = ExampleBuilder.fromModel(null, im, definitions, processedModels);
                        if (innerExample == null) continue;
                        innerExamples.add(innerExample);
                    }
                }
                ExampleBuilder.mergeTo(ex, innerExamples);
                output = ex;
            }
        } else if (model instanceof ArrayModel) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(Json.mapper().writeValueAsString(example), ArrayExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                Example innerExample;
                Property inner;
                ArrayModel am = (ArrayModel)model;
                if (am.getXml() != null) {
                    Xml xml = am.getXml();
                    name = xml.getName();
                    namespace = xml.getNamespace();
                    prefix = xml.getPrefix();
                    attribute = xml.getAttribute();
                    wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
                }
                if ((inner = am.getItems()) != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null) {
                    ArrayExample an = new ArrayExample();
                    an.add(innerExample);
                    output = an;
                }
            }
        } else if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            if (processedModels.containsKey(ref.getSimpleRef())) {
                output = ExampleBuilder.alreadyProcessedRefExample(ref.getSimpleRef(), definitions, processedModels);
            } else {
                Model refedModel;
                processedModels.put(ref.getSimpleRef(), null);
                if (definitions != null && (refedModel = definitions.get(ref.getSimpleRef())) != null) {
                    output = ExampleBuilder.fromModel(ref.getSimpleRef(), refedModel, definitions, processedModels);
                    processedModels.put(ref.getSimpleRef(), output);
                }
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue() && name != null) {
                output.setWrappedName(name);
            }
            if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static void mergeTo(ObjectExample output, List<Example> examples) {
        for (Example ex : examples) {
            ObjectExample objectExample;
            Map<String, Example> values;
            if (!(ex instanceof ObjectExample) || (values = (objectExample = (ObjectExample)ex).getValues()) == null) continue;
            output.putAll(values);
        }
    }
}

