/*
 *  Copyright 2016 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.swagger.inflector.examples.models;

public class BooleanExample extends AbstractExample {
    private Boolean value;

    public BooleanExample() {
        super.setTypeName("boolean");
    }

    public BooleanExample(boolean value) {
        this();
        this.value = value;
    }

    public String asString() {
        return value.toString();
    }

    public Boolean getValue() {
        return value != null ? value : false;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }
}
