/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.examples;

import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.BooleanExample;
import io.swagger.inflector.examples.models.DecimalExample;
import io.swagger.inflector.examples.models.DoubleExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.FloatExample;
import io.swagger.inflector.examples.models.IntegerExample;
import io.swagger.inflector.examples.models.LongExample;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.examples.models.StringExample;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleBuilder.class);

    public static Example fromProperty(Property property, Map<String, Model> definitions) {
        return ExampleBuilder.fromProperty(property, definitions, new HashSet<String>());
    }

    public static Example fromProperty(Property property, Map<String, Model> definitions, Set<String> processedModels) {
        MapProperty mp;
        Example innerExample;
        Property inner;
        Model model;
        RefProperty ref;
        if (property == null) {
            return null;
        }
        String name = null;
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        Boolean wrapped = false;
        if (property.getXml() != null) {
            Xml xml = property.getXml();
            name = xml.getName();
            namespace = xml.getNamespace();
            prefix = xml.getPrefix();
            attribute = xml.getAttribute();
            wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
        }
        Example output = null;
        Object example = property.getExample();
        if (property instanceof RefProperty) {
            ref = (RefProperty)property;
            if (processedModels.contains(ref.getSimpleRef())) {
                return null;
            }
            processedModels.add(ref.getSimpleRef());
            if (definitions != null && (model = definitions.get(ref.getSimpleRef())) != null && model.getExample() != null) {
                try {
                    String str = model.getExample().toString();
                    output = (Example)Json.mapper().readValue(str, ObjectExample.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        } else if (property instanceof EmailProperty) {
            if (example != null) {
                return new StringExample(example.toString());
            }
            output = new StringExample("apiteam@swagger.io");
        } else if (property instanceof UUIDProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            }
            output = new StringExample("3fa85f64-5717-4562-b3fc-2c963f66afa6");
        } else if (property instanceof StringProperty) {
            output = example != null ? new StringExample(example.toString()) : new StringExample("string");
        } else if (property instanceof IntegerProperty) {
            output = example != null ? new IntegerExample(Integer.parseInt(example.toString())) : new IntegerExample(0);
        } else if (property instanceof LongProperty) {
            if (example != null) {
                output = new LongExample(Long.parseLong(example.toString()));
            }
            output = new LongExample(0L);
        } else if (property instanceof FloatProperty) {
            if (example != null) {
                output = new FloatExample(Float.parseFloat(example.toString()));
            }
            output = new FloatExample(1.1f);
        } else if (property instanceof DoubleProperty) {
            if (example != null) {
                output = new DoubleExample(Double.parseDouble(example.toString()));
            }
            output = new DoubleExample(1.23);
        } else if (property instanceof BooleanProperty) {
            if (example != null) {
                output = new BooleanExample(Boolean.parseBoolean(example.toString()));
            }
            output = new BooleanExample(true);
        } else if (property instanceof DateProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            }
            output = new StringExample("2015-07-20");
        } else if (property instanceof DateTimeProperty) {
            if (example != null) {
                output = new StringExample(example.toString());
            }
            output = new StringExample("2015-07-20T15:49:04-07:00");
        } else if (property instanceof DecimalProperty) {
            if (example != null) {
                output = new DecimalExample(new BigDecimal(example.toString()));
            }
            output = new DecimalExample(new BigDecimal(1.5));
        } else if (property instanceof ObjectProperty) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample outputExample = new ObjectExample();
                outputExample.setName(property.getName());
                ObjectProperty op = (ObjectProperty)property;
                if (op.getProperties() != null) {
                    for (String propertyname : op.getProperties().keySet()) {
                        Property inner2 = (Property)op.getProperties().get(propertyname);
                        Example innerExample2 = ExampleBuilder.fromProperty(inner2, definitions);
                        outputExample.put(propertyname, innerExample2);
                    }
                }
                output = outputExample;
            }
        } else if (property instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)property;
            inner = ap.getItems();
            if (inner != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null && innerExample instanceof Example) {
                ArrayExample an = new ArrayExample();
                an.add(innerExample);
                an.setName(property.getName());
                output = an;
            }
        } else if (property instanceof MapProperty && (inner = (mp = (MapProperty)property).getAdditionalProperties()) != null && (innerExample = ExampleBuilder.fromProperty(inner, definitions, processedModels)) != null) {
            ObjectExample on = new ObjectExample();
            if (innerExample instanceof Example) {
                StringExample key = new StringExample("key");
                key.setName("key");
                on.put("key", key);
                Example in = innerExample;
                if (in.getName() == null) {
                    in.setName("value");
                }
                on.put("value", in);
                output = on;
            } else {
                ObjectExample outputMap = new ObjectExample();
                outputMap.put("key", new ObjectExample());
                output = outputMap;
            }
        }
        if (property instanceof RefProperty && output == null && definitions != null) {
            ref = (RefProperty)property;
            model = definitions.get(ref.getSimpleRef());
            if (model != null) {
                ModelImpl i;
                if (model instanceof ModelImpl && (i = (ModelImpl)model).getXml() != null) {
                    Xml xml = i.getXml();
                    name = xml.getName();
                    attribute = xml.getAttribute();
                    namespace = xml.getNamespace();
                    prefix = xml.getPrefix();
                    wrapped = xml.getWrapped();
                }
                if (model.getExample() != null) {
                    try {
                        Example n = (Example)Json.mapper().readValue(model.getExample().toString(), Example.class);
                        output = n;
                    }
                    catch (IOException e) {
                        LOGGER.error("unable to convert value", (Throwable)e);
                    }
                } else {
                    ObjectExample values = new ObjectExample();
                    Map properties = model.getProperties();
                    if (properties != null) {
                        for (String key : properties.keySet()) {
                            Property innerProp = (Property)properties.get(key);
                            Example p = ExampleBuilder.fromProperty(innerProp, definitions, processedModels);
                            if (p == null) continue;
                            if (p.getName() == null) {
                                p.setName(key);
                            }
                            values.put(key, p);
                            processedModels.add(key);
                        }
                    }
                    output = values;
                }
            }
            if (output != null) {
                output.setName(ref.getSimpleRef());
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue()) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }
}

