/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.processors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.processors.EntityProcessor;
import io.swagger.inflector.validators.ValidationError;
import io.swagger.inflector.validators.ValidationMessage;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonProcessor
implements EntityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonProcessor.class);
    private static XmlMapper XML = new XmlMapper();
    private static MediaType APPLICATION_YAML = new MediaType("application", "yaml");
    private static Collection<MediaType> SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE, APPLICATION_YAML, MediaType.TEXT_PLAIN_TYPE));

    @Override
    public boolean supports(MediaType mediaType) {
        for (MediaType item : SUPPORTED_TYPES) {
            if (!item.isCompatible(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, JavaType javaType) {
        try {
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
                return Json.mapper().readValue(entityStream, javaType);
            }
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
                return XML.readValue(entityStream, javaType);
            }
            if (APPLICATION_YAML.isCompatible(mediaType)) {
                return Yaml.mapper().readValue(entityStream, javaType);
            }
        }
        catch (IOException e) {
            LOGGER.error("unable to extract entity from content-type `" + mediaType + "` to " + javaType.toCanonical(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, Class<?> cls) throws ConversionException {
        try {
            if (String.class.equals(cls)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)entityStream, (OutputStream)outputStream);
                return ((Object)outputStream).toString();
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
                return Json.mapper().readValue(entityStream, cls);
            }
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
                return XML.readValue(entityStream, cls);
            }
            if (APPLICATION_YAML.isCompatible(mediaType)) {
                return Yaml.mapper().readValue(entityStream, cls);
            }
        }
        catch (Exception e) {
            LOGGER.trace("unable to extract entity from content-type `" + mediaType + "` to " + cls.getCanonicalName(), (Throwable)e);
            throw new ConversionException().message(new ValidationMessage().code(ValidationError.UNACCEPTABLE_VALUE).message("unable to convert input to " + cls.getCanonicalName()));
        }
        return null;
    }
}

