/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.processors;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.swagger.inflector.examples.models.ArrayExample;
import io.swagger.inflector.examples.models.BooleanExample;
import io.swagger.inflector.examples.models.DecimalExample;
import io.swagger.inflector.examples.models.DoubleExample;
import io.swagger.inflector.examples.models.Example;
import io.swagger.inflector.examples.models.FloatExample;
import io.swagger.inflector.examples.models.IntegerExample;
import io.swagger.inflector.examples.models.LongExample;
import io.swagger.inflector.examples.models.ObjectExample;
import io.swagger.inflector.examples.models.StringExample;
import java.io.IOException;

public class JsonNodeExampleSerializer
extends JsonSerializer<Example> {
    public void serialize(Example value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)value;
            jgen.writeStartObject();
            this.writeTo(jgen, obj);
            jgen.writeEndObject();
        } else if (value instanceof ArrayExample) {
            ArrayExample obj = (ArrayExample)value;
            jgen.writeStartArray();
            for (Example item : obj.getItems()) {
                if (item instanceof ObjectExample) {
                    jgen.writeStartObject();
                }
                this.writeTo(jgen, item);
                if (!(item instanceof ObjectExample)) continue;
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        } else {
            this.writeTo(jgen, value);
        }
    }

    public void writeTo(JsonGenerator jgen, Example o) throws IOException {
        if (o instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)o;
            for (String key : obj.keySet()) {
                Example value = (Example)obj.get(key);
                this.writeValue(jgen, key, value);
            }
        } else if (o instanceof ArrayExample) {
            jgen.writeStartArray();
            this.writeTo(jgen, o);
            jgen.writeEndArray();
        } else {
            this.writeValue(jgen, null, o);
        }
    }

    public void writeValue(JsonGenerator jgen, String field, Example o) throws IOException {
        if (o instanceof ArrayExample) {
            ArrayExample obj = (ArrayExample)o;
            jgen.writeArrayFieldStart(field);
            for (Example item : obj.getItems()) {
                if (item.getName() != null) {
                    jgen.writeStartObject();
                    this.writeTo(jgen, item);
                    jgen.writeEndObject();
                    continue;
                }
                this.writeTo(jgen, item);
            }
            jgen.writeEndArray();
        } else if (o instanceof BooleanExample) {
            BooleanExample obj = (BooleanExample)o;
            if (field != null) {
                jgen.writeBooleanField(field, obj.getValue().booleanValue());
            } else {
                jgen.writeBoolean(obj.getValue().booleanValue());
            }
        } else if (o instanceof DecimalExample) {
            DecimalExample obj = (DecimalExample)o;
            if (field != null) {
                jgen.writeNumberField(field, obj.getValue());
            } else {
                jgen.writeNumber(obj.getValue());
            }
        } else if (o instanceof DoubleExample) {
            DoubleExample obj = (DoubleExample)o;
            if (field != null) {
                jgen.writeNumberField(field, obj.getValue().doubleValue());
            } else {
                jgen.writeNumber(obj.getValue().doubleValue());
            }
        } else if (o instanceof FloatExample) {
            FloatExample obj = (FloatExample)o;
            if (field != null) {
                jgen.writeNumberField(field, obj.getValue().floatValue());
            } else {
                jgen.writeNumber(obj.getValue().floatValue());
            }
        } else if (o instanceof IntegerExample) {
            IntegerExample obj = (IntegerExample)o;
            if (field != null) {
                jgen.writeNumberField(field, obj.getValue().intValue());
            } else {
                jgen.writeNumber(obj.getValue().intValue());
            }
        } else if (o instanceof LongExample) {
            LongExample obj = (LongExample)o;
            if (field != null) {
                jgen.writeNumberField(field, obj.getValue().longValue());
            } else {
                jgen.writeNumber(obj.getValue().longValue());
            }
        } else if (o instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)o;
            if (field != null) {
                jgen.writeObjectField(field, (Object)obj);
            }
        } else if (o instanceof StringExample) {
            StringExample obj = (StringExample)o;
            if (field != null) {
                jgen.writeStringField(field, obj.getValue());
            } else {
                jgen.writeString(obj.getValue());
            }
        }
    }

    public Class<Example> handledType() {
        return Example.class;
    }
}

