/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.inflector.Constants;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverUtil.class);
    private Map<String, Model> models;
    private Map<String, Model> resolvedModels = new HashMap<String, Model>();
    private Map<String, Property> resolvedProperties = new HashMap<String, Property>();

    public void resolveFully(Swagger swagger) {
        this.models = swagger.getDefinitions();
        if (this.models == null) {
            this.models = new HashMap<String, Model>();
        }
        for (String name : this.models.keySet()) {
            ArrayModel am;
            Model model = this.models.get(name);
            if (model instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                if (impl.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                impl.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (model instanceof ComposedModel) {
                ComposedModel cm = (ComposedModel)model;
                if (cm.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                cm.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (!(model instanceof ArrayModel) || (am = (ArrayModel)model).getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
            am.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
        }
        for (String pathname : swagger.getPaths().keySet()) {
            Path path = swagger.getPath(pathname);
            for (Operation op : path.getOperations()) {
                Model resolved;
                for (Parameter parameter : op.getParameters()) {
                    if (!(parameter instanceof BodyParameter)) continue;
                    BodyParameter body = (BodyParameter)parameter;
                    resolved = this.resolveFully(body.getSchema());
                    body.setSchema(resolved);
                }
                if (op.getResponses() == null) continue;
                for (String code : op.getResponses().keySet()) {
                    Response response = (Response)op.getResponses().get(code);
                    if (response.getSchema() == null) continue;
                    resolved = this.resolveFully(response.getSchema());
                    response.setSchema((Property)resolved);
                }
            }
        }
    }

    public Model resolveFully(Model schema) {
        ModelImpl model;
        if (schema instanceof RefModel) {
            RefModel ref = (RefModel)schema;
            Model resolved = this.models.get(ref.getSimpleRef());
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref.getSimpleRef());
                return schema;
            }
            if (this.resolvedModels.containsKey(ref.getSimpleRef())) {
                LOGGER.debug("avoiding infinite loop");
                return this.resolvedModels.get(ref.getSimpleRef());
            }
            this.resolvedModels.put(ref.getSimpleRef(), (Model)ref);
            Model model2 = this.resolveFully(resolved);
            this.resolvedModels.put(ref.getSimpleRef(), model2);
            return model2;
        }
        if (schema instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)schema;
            Property property = arrayModel.getItems();
            if (property instanceof RefProperty) {
                Property resolved = this.resolveFully(property);
                arrayModel.setItems(resolved);
            }
            return arrayModel;
        }
        if (schema instanceof ModelImpl && (model = (ModelImpl)schema).getProperties() != null) {
            LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
            for (String propertyName : model.getProperties().keySet()) {
                Property property = (Property)model.getProperties().get(propertyName);
                Property resolved = this.resolveFully(property);
                updated.put(propertyName, resolved);
            }
            Map existing = model.getProperties();
            for (String key : updated.keySet()) {
                Property property = (Property)updated.get(key);
                if (!(property instanceof ObjectProperty)) continue;
                ObjectProperty op = (ObjectProperty)property;
                if (op.getProperties() != model.getProperties()) {
                    model.addProperty(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                model.addProperty(key, (Property)new ObjectProperty());
            }
            return model;
        }
        LOGGER.error("no type match for " + schema);
        return schema;
    }

    public Property resolveFully(Property property) {
        if (property instanceof RefProperty) {
            RefProperty ref = (RefProperty)property;
            if (this.resolvedProperties.containsKey(ref.getSimpleRef())) {
                Property resolved = this.resolvedProperties.get(ref.getSimpleRef());
                if (resolved == property) {
                    LOGGER.debug("avoiding infinite loop, using generic object property");
                    return new ObjectProperty();
                }
                return this.resolvedProperties.get(ref.getSimpleRef());
            }
            this.resolvedProperties.put(ref.getSimpleRef(), (Property)ref);
            Model model = this.models.get(ref.getSimpleRef());
            if (model == null) {
                LOGGER.error("unresolved model " + ref.getSimpleRef());
                return property;
            }
            Property output = this.createObjectProperty(model);
            this.resolvedProperties.put(ref.getSimpleRef(), output);
            return output;
        }
        if (property instanceof ObjectProperty) {
            ObjectProperty obj = (ObjectProperty)property;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Property innerProperty = (Property)obj.getProperties().get(propertyName);
                    if (property == innerProperty) continue;
                    Property resolved = this.resolveFully(innerProperty);
                    updated.put(propertyName, resolved);
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)property;
            if (array.getItems() != null) {
                Property resolved = this.resolveFully(array.getItems());
                array.setItems(resolved);
            }
            return array;
        }
        return property;
    }

    public Property createObjectProperty(Model model) {
        if (model instanceof ModelImpl) {
            String name;
            ModelImpl m = (ModelImpl)this.resolveFully(model);
            ObjectProperty property = new ObjectProperty();
            property.setProperties(m.getProperties());
            property.setName(m.getName());
            property.setFormat(m.getFormat());
            property.setDefault(m.getDefaultValue());
            property.setDescription(m.getDescription());
            property.setXml(m.getXml());
            if (m.getExample() != null) {
                property.setExample(m.getExample().toString());
            }
            if ((name = (String)m.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) != null) {
                property.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
            }
            return property;
        }
        if (model instanceof ArrayModel) {
            ArrayModel m = (ArrayModel)model;
            ArrayProperty property = new ArrayProperty();
            Property inner = m.getItems();
            Property resolved = this.resolveFully(inner);
            property.setItems(resolved);
            property.setDescription(m.getDescription());
            return property;
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            Model inner = this.models.get(ref.getSimpleRef());
            return this.createObjectProperty(inner);
        }
        LOGGER.error("can't resolve " + model);
        return null;
    }
}

