/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.controllers;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.oas.inflector.config.Configuration;
import io.swagger.oas.inflector.config.ControllerFactory;
import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.converters.InputConverter;
import io.swagger.oas.inflector.examples.ExampleBuilder;
import io.swagger.oas.inflector.examples.models.ArrayExample;
import io.swagger.oas.inflector.examples.models.ObjectExample;
import io.swagger.oas.inflector.models.ApiError;
import io.swagger.oas.inflector.models.RequestContext;
import io.swagger.oas.inflector.models.ResponseContext;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.processors.EntityProcessorFactory;
import io.swagger.oas.inflector.schema.SchemaValidator;
import io.swagger.oas.inflector.utils.ApiErrorUtils;
import io.swagger.oas.inflector.utils.ApiException;
import io.swagger.oas.inflector.utils.ContentTypeSelector;
import io.swagger.oas.inflector.utils.ReflectionUtils;
import io.swagger.oas.inflector.validators.ValidationException;
import io.swagger.oas.inflector.validators.ValidationMessage;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIOperationController
extends ReflectionUtils
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIOperationController.class);
    private static final String RANDOM_EXAMPLE = "random";
    private static final String SEQUENCIAL_EXAMPLE = "sequence";
    private int sequence = 0;
    private static Set<String> commonHeaders = new HashSet<String>();
    private String path;
    private String httpMethod;
    private Operation operation;
    private Object controller = null;
    private Method method = null;
    private JavaType[] parameterClasses = null;
    private Map<String, Schema> definitions;
    private InputConverter validator;
    private String controllerName;
    private String methodName;
    private String operationSignature;
    @Inject
    private Provider<Providers> providersProvider;
    @Inject
    private Provider<HttpServletRequest> requestProvider;
    @Inject
    private Provider<HttpServletResponse> responseProvider;
    private ControllerFactory controllerFactoryCache = null;

    public OpenAPIOperationController(Configuration config, String path, String httpMethod, Operation operation, String mediaType, Map<String, Schema> definitions) {
        this.setConfiguration(config);
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
        this.definitions = definitions;
        this.validator = InputConverter.getInstance();
        this.method = this.detectMethod(operation, mediaType);
        if (this.method == null) {
            LOGGER.debug("no method `" + this.methodName + "` in `" + this.controllerName + "` to map to, using mock response");
        }
    }

    OpenAPIOperationController(Configuration config, String path, String httpMethod, Operation operation, String mediaType, Map<String, Schema> definitions, Provider<HttpServletRequest> requestProvider, Provider<HttpServletResponse> responseProvider) {
        this(config, path, httpMethod, operation, mediaType, definitions);
        this.requestProvider = requestProvider;
        this.responseProvider = responseProvider;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Object getController() {
        return this.controller;
    }

    public JavaType[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public InputConverter getValidator() {
        return this.validator;
    }

    public Method detectMethod(Operation operation, String mediaType) {
        this.controllerName = this.getControllerName(operation);
        this.methodName = this.getMethodName(this.path, this.httpMethod, operation);
        JavaType[] args = this.getOperationParameterClasses(operation, mediaType, this.definitions);
        this.buildOperationSignature(args);
        LOGGER.info("looking for method: `" + this.operationSignature + "` in class `" + this.controllerName + "`");
        this.parameterClasses = args;
        return this.matchBuildMethodToImplemented(args);
    }

    private Method matchBuildMethodToImplemented(JavaType[] args) {
        if (this.controllerName != null && this.methodName != null) {
            try {
                Method[] methods;
                Class<?> cls;
                try {
                    cls = Class.forName(this.controllerName);
                }
                catch (ClassNotFoundException e) {
                    this.controllerName = this.controllerName + "Controller";
                    cls = Class.forName(this.controllerName);
                }
                for (Method method : methods = cls.getMethods()) {
                    Class<?>[] methodArgs;
                    if (!this.methodName.equals(method.getName()) || (methodArgs = method.getParameterTypes()).length != args.length) continue;
                    boolean matched = true;
                    for (int i = 0; i < methodArgs.length; ++i) {
                        if (args[i].getRawClass().equals(methodArgs[i])) continue;
                        if (args[i].getRawClass().equals(InputStream.class)) {
                            args[i] = this.updateArgumentClass(methodArgs[i]);
                            continue;
                        }
                        LOGGER.debug("failed to match " + args[i] + ", " + methodArgs[i]);
                        matched = false;
                    }
                    if (!matched) continue;
                    this.parameterClasses = args;
                    this.controller = this.getControllerFactory().instantiateController(cls, this.operation);
                    LOGGER.debug("found class `" + this.controllerName + "`");
                    this.buildOperationSignature(args);
                    return method;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("didn't find class " + this.controller);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void buildOperationSignature(JavaType[] args) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName(this.path, this.httpMethod, this.operation)).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                builder.append(RequestContext.class.getCanonicalName()).append(" request");
                continue;
            }
            builder.append(", ");
            if (args[i] == null) {
                LOGGER.error("didn't expect a null class for the argument in operation " + this.operation.getOperationId());
                continue;
            }
            if (args[i].getRawClass() == null) continue;
            String className = args[i].getRawClass().getName();
            if (className.startsWith("java.lang.")) {
                className = className.substring("java.lang.".length());
            }
            builder.append(className);
            builder.append(" ").append(args[i]);
        }
        builder.append(")");
        this.operationSignature = "public ResponseContext " + builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response apply(ContainerRequestContext ctx) {
        block106: {
            block107: {
                block104: {
                    block105: {
                        block103: {
                            block101: {
                                block100: {
                                    block102: {
                                        block98: {
                                            parameters = this.operation.getParameters();
                                            requestContext = this.createContext(ctx);
                                            inputStreams = new HashMap<K, V>();
                                            args = new Object[this.parameterClasses.length];
                                            i = 0;
                                            args[i] = requestContext;
                                            ++i;
                                            missingParams = new ArrayList<ValidationMessage>();
                                            uri = ctx.getUriInfo();
                                            existingKeys = new HashSet<String>();
                                            x = uri.getQueryParameters().keySet().iterator();
                                            while (x.hasNext()) {
                                                existingKeys.add((String)x.next() + ": qp");
                                            }
                                            x = uri.getPathParameters().keySet().iterator();
                                            while (x.hasNext()) {
                                                existingKeys.add((String)x.next() + ": pp");
                                            }
                                            mediaType = requestContext.getMediaType();
                                            argument = null;
                                            if (parameters != null && parameters.size() > 0) {
                                                for (Parameter parameter : parameters) {
                                                    block97: {
                                                        in = parameter.getIn();
                                                        try {
                                                            try {
                                                                paramName = parameter.getName();
                                                                if ("query".equals(in)) {
                                                                    existingKeys.remove(paramName + ": qp");
                                                                }
                                                                if ("path".equals(in)) {
                                                                    existingKeys.remove(paramName + ": pp");
                                                                }
                                                                jt = this.parameterClasses[i];
                                                                cls = jt.getRawClass();
                                                                if ("query".equals(in)) {
                                                                    argument = this.validator.convertAndValidate((List)uri.getQueryParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                                                                    break block97;
                                                                }
                                                                if ("path".equals(in)) {
                                                                    argument = this.validator.convertAndValidate((List)uri.getPathParameters().get((Object)parameter.getName()), parameter, cls, this.definitions);
                                                                } else if ("header".equals(in)) {
                                                                    argument = this.validator.convertAndValidate((List)ctx.getHeaders().get((Object)parameter.getName()), parameter, cls, this.definitions);
                                                                }
                                                            }
                                                            catch (ConversionException e) {
                                                                missingParams.add(e.getError());
                                                            }
                                                            catch (ValidationException e) {
                                                                missingParams.add(e.getValidationMessage());
                                                            }
                                                        }
                                                        catch (NumberFormatException e) {
                                                            OpenAPIOperationController.LOGGER.error("Couldn't find " + parameter.getName() + " (" + in + ") to " + this.parameterClasses[i], (Throwable)e);
                                                        }
                                                    }
                                                    args[i] = argument;
                                                    ++i;
                                                }
                                            }
                                            if (this.operation.getRequestBody() != null) {
                                                body = this.operation.getRequestBody();
                                                if (ctx.hasEntity()) {
                                                    jt = this.parameterClasses[i];
                                                    cls = null;
                                                    if (jt != null) {
                                                        cls = jt.getRawClass();
                                                    }
                                                    try {
                                                        argument = EntityProcessorFactory.readValue(mediaType, ctx.getEntityStream(), cls, this);
                                                        if (argument == null) break block98;
                                                        if (mediaType.isCompatible(javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE) || mediaType.isCompatible(javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE) || mediaType.isCompatible(javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                                                            if (argument instanceof Object[]) {
                                                                args2 = (Object[])argument;
                                                                args2[0] = args[0];
                                                                args = args2;
                                                                break block98;
                                                            } else {
                                                                args[i] = argument;
                                                            }
                                                            break block98;
                                                        }
                                                        if (body.getContent() != null) {
                                                            content = body.getContent();
                                                            media = (MediaType)content.get((Object)mediaType.toString());
                                                            if (media == null) {
                                                                media = (MediaType)content.get((Object)"*/*");
                                                            }
                                                            if (media != null && media.getSchema() != null) {
                                                                this.validate(argument, media.getSchema(), SchemaValidator.Direction.INPUT);
                                                            }
                                                            args[i] = argument;
                                                            ++i;
                                                        }
                                                    }
                                                    catch (ConversionException e) {
                                                        missingParams.add(e.getError());
                                                    }
                                                } else if (this.operation.getRequestBody().getRequired().booleanValue()) {
                                                    e = new ValidationException();
                                                    e.message(new ValidationMessage().message("The input body `" + this.operation.getRequestBody() + "` is required"));
                                                    try {
                                                        throw e;
                                                    }
                                                    catch (ValidationException e1) {
                                                        missingParams.add(e.getValidationMessage());
                                                    }
                                                }
                                            }
                                        }
                                        if (existingKeys.size() > 0) {
                                            OpenAPIOperationController.LOGGER.debug("unexpected keys: " + existingKeys);
                                        }
                                        if (missingParams.size() <= 0) break block102;
                                        builder = new StringBuilder();
                                        builder.append("Input error");
                                        if (missingParams.size() > 1) {
                                            builder.append("s");
                                        }
                                        builder.append(": ");
                                        count = 0;
                                        e1 = missingParams.iterator();
                                        ** GOTO lbl164
                                    }
                                    if (this.method != null) {
                                        block99: {
                                            OpenAPIOperationController.LOGGER.info("calling method " + this.method + " on controller " + this.controller + " with args " + Arrays.toString(args));
                                            try {
                                                response = this.method.invoke(this.controller, args);
                                                if (!(response instanceof ResponseContext)) break block99;
                                                wrapper = (ResponseContext)response;
                                                builder = Response.status((int)wrapper.getStatus());
                                                error = wrapper.getHeaders().keySet().iterator();
                                                break block100;
                                            }
                                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                                cause = e.getCause();
                                                while (cause != null) {
                                                    if (cause instanceof ApiException) {
                                                        throw (ApiException)cause;
                                                    }
                                                    next = cause.getCause();
                                                    cause = next == cause || next == null ? null : next;
                                                }
                                                throw new ApiException(ApiErrorUtils.createInternalError(), (Throwable)e);
                                            }
                                        }
                                        wrapper = Response.ok().entity(response).build();
                                        return wrapper;
                                    }
                                    responses = this.operation.getResponses();
                                    if (responses != null) {
                                        keys = new String[responses.keySet().size()];
                                        Arrays.sort(responses.keySet().toArray(keys));
                                        code = 0;
                                        defaultKey = null;
                                        file = keys;
                                        key = file.length;
                                        break block101;
                                    } else {
                                        var13_14 = Response.ok().build();
                                        return var13_14;
                                    }
                                    finally {
                                        responseSchema = inputStreams.keySet().iterator();
                                        while (true) {
                                            if (!responseSchema.hasNext()) {
                                            }
                                            key = (String)responseSchema.next();
                                            file = (File)inputStreams.get(key);
                                            if (file == null) continue;
                                            OpenAPIOperationController.LOGGER.debug("deleting file " + file.getPath());
                                            file.delete();
                                        }
                                    }
lbl164:
                                    // 1 sources

                                    while (true) {
                                        if (!e1.hasNext()) {
                                            statusCode = this.config.getInvalidRequestStatusCode();
                                            error = new ApiError().code(statusCode).message(builder.toString());
                                            throw new ApiException((ApiError)error);
                                        }
                                        message = (ValidationMessage)e1.next();
                                        if (count > 0) {
                                            builder.append(", ");
                                        }
                                        if (message != null && message.getMessage() != null) {
                                            builder.append(message.getMessage());
                                        } else {
                                            builder.append("no additional input");
                                        }
                                        ++count;
                                    }
                                }
                                while (error.hasNext()) {
                                    key = (String)error.next();
                                    v = (List)wrapper.getHeaders().get((Object)key);
                                    if (v.size() == 1) {
                                        builder.header(key, v.get(0));
                                        continue;
                                    }
                                    builder.header(key, (Object)v);
                                }
                                if (wrapper.getEntity() != null) {
                                    builder.entity(wrapper.getEntity());
                                    if (wrapper.getContentType() != null) {
                                        builder.type(wrapper.getContentType());
                                    } else {
                                        selector = ((Providers)this.providersProvider.get()).getContextResolver(ContentTypeSelector.class, javax.ws.rs.core.MediaType.WILDCARD_TYPE);
                                        if (selector != null) {
                                            ((ContentTypeSelector)selector.getContext(this.getClass())).apply(ctx.getAcceptableMediaTypes(), builder);
                                        }
                                    }
                                    if (this.operation.getResponses() != null) {
                                        responseCode /* !! */  = String.valueOf(wrapper.getStatus());
                                        responseSchema = (ApiResponse)this.operation.getResponses().get((Object)responseCode /* !! */ );
                                        if (responseSchema == null) {
                                            responseSchema = (ApiResponse)this.operation.getResponses().get((Object)"default");
                                        }
                                        if (responseSchema != null) {
                                            if (responseSchema.getContent() != null) {
                                                for (String name : responseSchema.getContent().keySet()) {
                                                    if (((MediaType)responseSchema.getContent().get((Object)name)).getSchema() == null) continue;
                                                    this.validate(wrapper.getEntity(), ((MediaType)responseSchema.getContent().get((Object)name)).getSchema(), SchemaValidator.Direction.OUTPUT);
                                                }
                                            }
                                        } else {
                                            OpenAPIOperationController.LOGGER.debug("no response schema for code " + (String)responseCode /* !! */  + " to validate against");
                                        }
                                    }
                                }
                                responseCode /* !! */  = builder.build();
                                return responseCode /* !! */ ;
                            }
                            for (file = 0; file < key; ++file) {
                                key = file[file];
                                if (key.startsWith("2")) {
                                    defaultKey = key;
                                    code = Integer.parseInt(key);
                                    break;
                                }
                                if ("default".equals(key)) {
                                    defaultKey = key;
                                    code = 200;
                                    break;
                                }
                                if (!key.startsWith("3")) continue;
                                defaultKey = key;
                                code = Integer.parseInt(key);
                            }
                            if (defaultKey == null) break block103;
                            builder = Response.status((int)code);
                            response = (ApiResponse)responses.get(defaultKey);
                            if (response.getHeaders() == null || response.getHeaders().size() <= 0) break block104;
                            property = null;
                            output = null;
                            var20_36 = response.getHeaders().keySet().iterator();
                            break block105;
                        }
                        OpenAPIOperationController.LOGGER.debug("no response type to map to, assume 200");
                        code = 200;
                        builder = Response.status((int)code).build();
                        return builder;
                    }
                    while (var20_36.hasNext()) {
                        key = (String)var20_36.next();
                        headerProperty = (Header)response.getHeaders().get(key);
                        if (headerProperty.getSchema() == null) continue;
                        output = ExampleBuilder.fromSchema(headerProperty.getSchema(), this.definitions);
                        if (output instanceof ArrayExample) {
                            output = ((ArrayExample)output).asString();
                        } else if (output instanceof ObjectExample) {
                            OpenAPIOperationController.LOGGER.debug("not serializing output example, only primitives or arrays of primitives are supported");
                        } else {
                            output = ((io.swagger.oas.inflector.examples.models.Example)output).asString();
                        }
                        builder.header(key, output);
                    }
                }
                examples = new HashMap<K, V>();
                output = null;
                exampleProcessorList = this.config.getExampleProcessors();
                outputExample = null;
                if (response.getContent() == null) break block106;
                if (requestContext.getHeaders().get((Object)"Accept") == null) break block107;
                for (String acceptable : (List)requestContext.getHeaders().get((Object)"Accept")) {
                    block109: {
                        block110: {
                            block108: {
                                if (response.getContent().get((Object)acceptable) == null) break block108;
                                if (((MediaType)response.getContent().get((Object)acceptable)).getExamples() != null) {
                                    examples = ((MediaType)response.getContent().get((Object)acceptable)).getExamples();
                                }
                                if (examples == null || examples.size() <= 0) break block109;
                                var24_40 /* !! */  = requestContext.getAcceptableMediaTypes().iterator();
                                break block110;
                            }
                            var24_40 /* !! */  = response.getContent().keySet().iterator();
                            if (!var24_40 /* !! */ .hasNext()) continue;
                            media = (String)var24_40 /* !! */ .next();
                            output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get(media)).getSchema(), this.definitions);
                            continue;
                        }
                        while (var24_40 /* !! */ .hasNext()) {
                            key = (javax.ws.rs.core.MediaType)var24_40 /* !! */ .next();
                            media = javax.ws.rs.core.MediaType.valueOf((String)acceptable);
                            if (!media.isCompatible(key) || exampleProcessorList == null || exampleProcessorList.size() <= 0 || !(var27_43 = exampleProcessorList.iterator()).hasNext()) continue;
                            mode = var27_43.next();
                            if (mode.equals("random")) {
                                generator = new Random();
                                values = examples.values().toArray();
                                outputExample = (Example)values[generator.nextInt(values.length)];
                            } else if (mode.equals("sequence")) {
                                if (this.sequence >= examples.size()) {
                                    this.sequence = 0;
                                }
                                values = examples.values().toArray();
                                outputExample = (Example)values[this.sequence];
                                ++this.sequence;
                            }
                            builder.entity(outputExample).type(acceptable);
                            values = builder.build();
                            return values;
                        }
                    }
                    output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get((Object)acceptable)).getSchema(), this.definitions);
                }
                break block106;
            }
            for (String key : response.getContent().keySet()) {
                if (((MediaType)response.getContent().get((Object)key)).getExamples() != null) {
                    examples = ((MediaType)response.getContent().get((Object)key)).getExamples();
                }
                if (examples != null && examples.size() > 0) {
                    for (javax.ws.rs.core.MediaType media : requestContext.getAcceptableMediaTypes()) {
                        if (!javax.ws.rs.core.MediaType.valueOf((String)key).isCompatible(media) || exampleProcessorList == null || exampleProcessorList.size() <= 0 || !(media = exampleProcessorList.iterator()).hasNext()) continue;
                        mode = (String)media.next();
                        if (mode.equals("random")) {
                            generator = new Random();
                            values = examples.values().toArray();
                            outputExample = (Example)values[generator.nextInt(values.length)];
                        } else if (mode.equals("sequence")) {
                            if (this.sequence >= examples.size()) {
                                this.sequence = 0;
                            }
                            values = examples.values().toArray();
                            outputExample = (Example)values[this.sequence];
                            ++this.sequence;
                        }
                        builder.entity(outputExample).type(javax.ws.rs.core.MediaType.valueOf((String)key));
                        values = builder.build();
                        return values;
                    }
                }
                output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get((Object)key)).getSchema(), this.definitions);
            }
        }
        if (output != null) {
            resp = new ResponseContext().entity(output);
            this.setContentType(requestContext, resp, this.operation);
            builder.entity(output);
            if (resp.getContentType() != null) {
                builder.type(resp.getContentType());
            } else {
                processors = EntityProcessorFactory.getProcessors();
                responseMediaType = null;
                block34: for (EntityProcessor processor : processors) {
                    if (responseMediaType != null) break;
                    for (javax.ws.rs.core.MediaType mediaTypet : requestContext.getAcceptableMediaTypes()) {
                        OpenAPIOperationController.LOGGER.debug("checking type " + mediaType.toString() + " against " + processor.getClass().getName());
                        if (!processor.supports(mediaType)) continue;
                        builder.type(mediaTypet);
                        responseMediaType = mediaTypet;
                        continue block34;
                    }
                }
                if (responseMediaType == null) {
                    for (EntityProcessor processor : processors) {
                        supportedTypes = processor.getSupportedMediaTypes();
                        if (supportedTypes.size() <= 0) continue;
                        builder.type(supportedTypes.get(0));
                        break;
                    }
                }
            }
            builder.entity(output);
        }
        var22_38 = builder.build();
        return var22_38;
    }

    public void validate(Object o, Schema property, SchemaValidator.Direction direction) throws ApiException {
        this.doValidation(o, property, direction);
    }

    public void setContentType(RequestContext res, ResponseContext resp, Operation operation) {
        if (resp.getContentType() != null) {
            return;
        }
        ApiResponses responses = operation.getResponses();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                ApiResponse response = (ApiResponse)responses.get((Object)responseCode);
                Content content = response.getContent();
                if (content == null) {
                    return;
                }
                for (String key : content.keySet()) {
                    javax.ws.rs.core.MediaType mediaType = javax.ws.rs.core.MediaType.valueOf((String)key);
                    if (res.getHeaders().get((Object)"Accept") != null) {
                        for (String string : (List)res.getHeaders().get((Object)"Accept")) {
                            String subtype = string.substring(string.lastIndexOf("/") + 1);
                            resp.setContentType(mediaType);
                            if (!subtype.equals(mediaType.getSubtype())) continue;
                            return;
                        }
                        continue;
                    }
                    for (javax.ws.rs.core.MediaType mediaType2 : res.getAcceptableMediaTypes()) {
                        resp.setContentType(mediaType);
                        if (!mediaType.isCompatible(mediaType2)) continue;
                        return;
                    }
                }
            }
        }
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public void setOperationSignature(String operationSignature) {
        this.operationSignature = operationSignature;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    RequestContext createContext(ContainerRequestContext from) {
        HttpServletRequest request = this.getHttpServletRequest();
        HttpServletResponse response = this.getHttpServletResponse();
        return new RequestContext(from, request, response);
    }

    private HttpServletRequest getHttpServletRequest() {
        if (this.requestProvider != null) {
            return (HttpServletRequest)this.requestProvider.get();
        }
        LOGGER.warn("HttpServletRequest provider was null - returning null request!");
        return null;
    }

    private HttpServletResponse getHttpServletResponse() {
        if (this.responseProvider != null) {
            return (HttpServletResponse)this.responseProvider.get();
        }
        LOGGER.warn("HttpServletResponse provider was null - returning null response!");
        return null;
    }

    private void doValidation(Object value, Object schema, SchemaValidator.Direction direction) throws ApiException {
        if (this.config.getValidatePayloads().isEmpty()) {
            return;
        }
        switch (direction) {
            case INPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.IN) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("Input does not match the expected structure"));
            }
            case OUTPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.OUT) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("The server generated an invalid response"));
            }
        }
    }

    private ControllerFactory getControllerFactory() {
        if (this.controllerFactoryCache == null) {
            this.controllerFactoryCache = this.config.getControllerFactory();
        }
        return this.controllerFactoryCache;
    }

    static {
        commonHeaders.add("Host");
        commonHeaders.add("User-Agent");
        commonHeaders.add("Accept");
        commonHeaders.add("Content-Type");
        commonHeaders.add("Content-Length");
    }
}

