/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.models;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class RequestContext {
    ContainerRequestContext context;
    MultivaluedMap<String, String> headers;
    MediaType mediaType;
    List<MediaType> acceptableMediaTypes;
    private String remoteAddr;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RequestContext() {
        this(null, null, null);
    }

    public RequestContext(ContainerRequestContext context) {
        this(context, null, null);
    }

    public RequestContext(ContainerRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        if (context != null) {
            this.headers((MultivaluedMap<String, String>)context.getHeaders());
            this.mediaType(context.getMediaType());
            this.acceptableMediaTypes(context.getAcceptableMediaTypes());
        }
        this.request = request;
        if (request != null) {
            this.remoteAddr = request.getRemoteAddr();
        }
        this.response = response;
    }

    public RequestContext headers(MultivaluedMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public RequestContext mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public RequestContext acceptableMediaTypes(List<MediaType> acceptableMediaTypes) {
        this.acceptableMediaTypes = acceptableMediaTypes;
        return this;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.acceptableMediaTypes;
    }

    public void setAcceptableMediaTypes(List<MediaType> acceptableMediaTypes) {
        this.acceptableMediaTypes = acceptableMediaTypes;
    }

    public ContainerRequestContext getContext() {
        return this.context;
    }

    public void setContext(ContainerRequestContext context) {
        this.context = context;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }
}

