/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.splitresourcesTestImpl.SplitResourceImpl;
import com.subresourcesTest.RootResource;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BeanConfigTest {
    private final Set<?> expectedKeys = new HashSet<String>(Arrays.asList("/packageA", "/packageB", "/packageC"));
    private final Set<?> expectedKeysOnlyB = new HashSet<String>(Arrays.asList("/packageB"));
    private final Set<Scheme> expectedSchemas = EnumSet.of(Scheme.HTTP, Scheme.HTTPS);

    private BeanConfig createBeanConfig(String rp) {
        BeanConfig bc = new BeanConfig();
        bc.setResourcePackage(rp);
        bc.setSchemes(new String[]{"http", "https"});
        bc.setHost("petstore.swagger.io");
        bc.setBasePath("/api");
        bc.setTitle("Petstore Sample API");
        bc.setDescription("A sample API that uses a petstore as an example to demonstrate features in the swagger-2.0 specification");
        bc.setTermsOfServiceUrl("http://swagger.io/terms/");
        bc.setContact("Swagger API Team");
        bc.setLicense("MIT");
        bc.setLicenseUrl("http://github.com/gruntjs/grunt/blob/master/LICENSE-MIT");
        bc.setScan(true);
        return bc;
    }

    @Test(description="scan a simple resource")
    public void shouldScanASimpleResource() {
        Swagger swagger = this.createBeanConfig("com.my.project.resources,org.my.project.resources,org.myles.project.resources").getSwagger();
        Assert.assertNotNull((Object)swagger);
        Assert.assertEquals(swagger.getPaths().keySet(), this.expectedKeys);
        Assert.assertEquals((Collection)swagger.getSchemes(), this.expectedSchemas);
    }

    @Test(description="deep scan packages per #1011")
    public void shouldDeepScanPakagesPer1011() {
        Swagger swagger = this.createBeanConfig("com.my,org.my,org.myles").getSwagger();
        Assert.assertNotNull((Object)swagger);
        Assert.assertEquals(swagger.getPaths().keySet(), this.expectedKeys);
        Assert.assertEquals((Collection)swagger.getSchemes(), this.expectedSchemas);
    }

    @Test(description="don't take siblings to a specfied package name per #2127")
    public void shouldNotTakeSiblingsToSpecifiedPackagesPer2127() {
        Swagger swagger = this.createBeanConfig("org.my").getSwagger();
        Assert.assertNotNull((Object)swagger);
        Assert.assertEquals(swagger.getPaths().keySet(), this.expectedKeysOnlyB, (String)"Shouldn't pickup paths from 'org.myles' using package name 'org.my'");
        Assert.assertEquals((Collection)swagger.getSchemes(), this.expectedSchemas);
    }

    @Test
    public void testBeanConfigOnlyScansResourcesAnnoatedWithPaths() throws Exception {
        BeanConfig bc = new BeanConfig();
        bc.setResourcePackage("com.subresourcesTest");
        Set classes = bc.classes();
        Assert.assertEquals((int)classes.size(), (int)1, (String)"BeanConfig should only pick up the root resource because it has a @Path annotation at the class level");
        Assert.assertTrue((boolean)classes.contains(RootResource.class));
    }

    @Test
    public void testBeanConfigScansSplitResourcesAnnoatedWithPathAndApi() throws Exception {
        BeanConfig bc = new BeanConfig();
        bc.setResourcePackage("com.splitresourcesTestImpl");
        Set classes = bc.classes();
        Assert.assertEquals((int)classes.size(), (int)1, (String)"BeanConfig should pick up implementations annotated with @Api that have a superinterface with @Path");
        Assert.assertTrue((boolean)classes.contains(SplitResourceImpl.class));
    }
}

