/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.Api;
import io.swagger.jaxrs.DefaultParameterExtension;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.ListOfStringsBeanParam;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BeanParamTest {
    private final SwaggerExtension myDefaultParameterExtension = new DefaultParameterExtension(){

        protected boolean isBeanParametersAggregatorAnnotation(Annotation annotation) {
            return annotation instanceof MyBeanParam;
        }
    };
    private List<SwaggerExtension> originalExtensions;

    @BeforeMethod
    public void beforeMethod() {
        this.originalExtensions = SwaggerExtensions.getExtensions();
        SwaggerExtensions.setExtensions(Collections.singletonList(this.myDefaultParameterExtension));
    }

    @AfterMethod
    public void afterMethod() {
        SwaggerExtensions.setExtensions(this.originalExtensions);
    }

    @Test(description="check array type of serialized BeanParam containing QueryParams")
    public void shouldSerializeTypeParameter() {
        Swagger swagger = new Reader(new Swagger()).read(MyBeanParamResource.class);
        List getOperationParams = swagger.getPath("/").getGet().getParameters();
        Assert.assertEquals((int)getOperationParams.size(), (int)1);
        QueryParameter param = (QueryParameter)getOperationParams.get(0);
        Assert.assertEquals((String)param.getName(), (String)"listOfStrings");
        Assert.assertEquals((String)param.getType(), (String)"array");
        Property itemsProperty = param.getItems();
        Assert.assertEquals(itemsProperty.getClass(), StringProperty.class);
        Assert.assertEquals((String)itemsProperty.getType(), (String)"string");
    }

    @Api
    @Path(value="/")
    private static class MyBeanParamResource {
        private MyBeanParamResource() {
        }

        @GET
        public String getWithBeanParam(@MyBeanParam ListOfStringsBeanParam listOfStringsBean) {
            return "result";
        }
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyBeanParam {
    }
}

