/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.resources.ResourceWithChildType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ChildTypeTest {
    private final Swagger swagger = new Reader(new Swagger()).read(ResourceWithChildType.class);

    private BodyParameter getBodyParameter(Operation op, int index) {
        return (BodyParameter)op.getParameters().get(index);
    }

    @Test(description="Tests child type response schema ref is correctly set up")
    public void testChildTypeResponse() {
        Operation op = this.swagger.getPath("/childType/testChildTypeResponse").getGet();
        Model schema = ((Response)op.getResponsesObject().get((Object)"200")).getResponseSchema();
        Assert.assertEquals((String)schema.getClass().getName(), (String)RefModel.class.getName());
        Assert.assertEquals((String)((RefModel)schema).getSimpleRef(), (String)"Sub1Bean");
    }

    @Test(description="Tests child type response schema ref is correctly set up when specified on the operation")
    public void testChildTypeResponseOnOperation() {
        Operation op = this.swagger.getPath("/childType/testChildTypeResponseOnOperation").getGet();
        Model schema = ((Response)op.getResponsesObject().get((Object)"200")).getResponseSchema();
        Assert.assertEquals((String)schema.getClass().getName(), (String)RefModel.class.getName());
        Assert.assertEquals((String)((RefModel)schema).getSimpleRef(), (String)"Sub1Bean");
    }

    @Test(description="Tests schema ref is correctly set up for child type parameter")
    public void testChildTypeParameter() {
        Operation op = this.swagger.getPath("/childType/testChildTypeParameter").getPost();
        BodyParameter parameter = this.getBodyParameter(op, 0);
        Model schema = parameter.getSchema();
        Assert.assertEquals((String)schema.getClass().getName(), (String)RefModel.class.getName());
        Assert.assertEquals((String)((RefModel)schema).getSimpleRef(), (String)"Sub1Bean");
    }
}

