/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.resources.CollectionFormatResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CollectionFormatTest {
    private static final String MULTI = "multi";
    private static final String CSV = "csv";
    private final Swagger swagger = new Reader(new Swagger()).read(CollectionFormatResource.class);

    @Test(testName="check collection format for QueryParam")
    public void readQueryParamTest() {
        Operation operation = this.getOperation("testQueryParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)MULTI);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 1));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 2), (String)MULTI);
    }

    @Test(testName="check collection format for FormParam")
    public void readFormParamTest() {
        Operation operation = this.getOperation("testFormParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)MULTI);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 1));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 2), (String)MULTI);
    }

    @Test(testName="check collection format for PathParam")
    public void readPathParamTest() {
        Operation operation = this.getOperation("testPathParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)CSV);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 1));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 2), (String)CSV);
    }

    @Test(testName="check collection format for HeaderParam")
    public void readHeaderParamTest() {
        Operation operation = this.getOperation("testHeaderParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)CSV);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 1));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 2), (String)CSV);
    }

    @Test(testName="check collection format for CookieParam")
    public void readCookieParamTest() {
        Operation operation = this.getOperation("testCookieParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)CSV);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 1));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 2), (String)CSV);
    }

    @Test(testName="check collection format for Mixed Param")
    public void readMixedParamTest() {
        Operation operation = this.getOperation("testMixedParam");
        Assert.assertEquals((String)this.getCollectionFormat(operation, 0), (String)MULTI);
        Assert.assertEquals((String)this.getCollectionFormat(operation, 1), (String)CSV);
        Assert.assertNull((Object)this.getCollectionFormat(operation, 2));
        Assert.assertEquals((String)this.getCollectionFormat(operation, 3), (String)CSV);
    }

    private Operation getOperation(String name) {
        return this.swagger.getPath("/collectionFormat/" + name).getPost();
    }

    private String getCollectionFormat(Operation op, int index) {
        return ((AbstractSerializableParameter)op.getParameters().get(index)).getCollectionFormat();
    }
}

