/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.resources.ResourceWithConfigAndExtensions;
import io.swagger.util.Json;
import java.util.HashSet;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigAndExtensionScannerTest {
    @Test(description="scan a resource with extensions")
    public void scanResourceWithExtensions() {
        HashSet<Class<ResourceWithConfigAndExtensions>> classes = new HashSet<Class<ResourceWithConfigAndExtensions>>();
        classes.add(ResourceWithConfigAndExtensions.class);
        Swagger swagger = new Reader(new Swagger()).read(classes);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)1);
        Info info = swagger.getInfo();
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((String)info.getDescription(), (String)"Custom description");
        Assert.assertEquals((String)info.getTermsOfService(), (String)"do-what-you-want");
        Assert.assertEquals((String)info.getTitle(), (String)"TheAwesomeApi");
        Assert.assertEquals((String)info.getVersion(), (String)"V1.2.3");
        Assert.assertEquals((String)info.getContact().getName(), (String)"Sponge-Bob");
        Assert.assertEquals((String)info.getContact().getEmail(), (String)"sponge-bob@swagger.io");
        Assert.assertEquals((String)info.getContact().getUrl(), (String)"http://swagger.io");
        Assert.assertEquals((String)info.getLicense().getName(), (String)"Apache 2.0");
        Assert.assertEquals((String)info.getLicense().getUrl(), (String)"http://www.apache.org");
        Assert.assertEquals((int)swagger.getConsumes().size(), (int)2);
        Assert.assertTrue((boolean)swagger.getConsumes().contains("application/json"));
        Assert.assertTrue((boolean)swagger.getConsumes().contains("application/xml"));
        Assert.assertEquals((int)swagger.getProduces().size(), (int)2);
        swagger.getProduces().contains("application/json");
        swagger.getProduces().contains("application/xml");
        Assert.assertEquals((String)swagger.getExternalDocs().getDescription(), (String)"test");
        Assert.assertEquals((String)swagger.getExternalDocs().getUrl(), (String)"http://swagger.io");
        Assert.assertEquals((int)swagger.getSchemes().size(), (int)2);
        Assert.assertTrue((boolean)swagger.getSchemes().contains(Scheme.HTTP));
        Assert.assertTrue((boolean)swagger.getSchemes().contains(Scheme.HTTPS));
        Assert.assertEquals((int)swagger.getTags().size(), (int)7);
        Assert.assertEquals((String)((Tag)swagger.getTags().get(0)).getName(), (String)"Tag-added-before-read");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(1)).getName(), (String)"mytag");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(1)).getDescription(), (String)"my tag");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(2)).getName(), (String)"anothertag");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(2)).getDescription(), (String)"another tag");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(2)).getExternalDocs().getDescription(), (String)"test");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(2)).getExternalDocs().getUrl(), (String)"http://swagger.io");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(3)).getName(), (String)"tagwithextensions");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(3)).getDescription(), (String)"my tag");
        Map extensions = ((Tag)swagger.getTags().get(3)).getVendorExtensions();
        Assert.assertEquals((int)extensions.size(), (int)1);
        Assert.assertEquals(extensions.get("x-test"), (Object)"value");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(4)).getName(), (String)"externalinfo");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(5)).getName(), (String)"testingtag");
        Assert.assertEquals((String)((Tag)swagger.getTags().get(6)).getName(), (String)"Tag-added-after-read");
        extensions = swagger.getInfo().getVendorExtensions();
        Assert.assertEquals((int)extensions.size(), (int)3);
        Assert.assertEquals(extensions.get("x-test1"), (Object)"value1");
        Assert.assertEquals(extensions.get("x-test2"), (Object)"value2");
        extensions = (Map)extensions.get("x-test");
        Assert.assertEquals(extensions.get("test1"), (Object)"value1");
        Assert.assertEquals(extensions.get("test2"), (Object)"value2");
        extensions = ((Operation)swagger.getPath("/who/cares").getOperations().get(0)).getVendorExtensions();
        Assert.assertEquals(extensions.get("x-test"), (Object)"value");
        String json = Json.pretty((Object)swagger);
        Assert.assertNotEquals((Object)json.indexOf("\"x-test\" : {"), (Object)-1);
        Assert.assertNotEquals((Object)json.indexOf("\"x-test1\" : \"value1\""), (Object)-1);
        Assert.assertNotEquals((Object)json.indexOf("\"x-test2\" : \"value2\""), (Object)-1);
    }
}

