/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import io.swagger.jaxrs.Reader;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.TestEnum;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.resources.ResourceWithGenerics;
import io.swagger.resources.generics.UserApiRoute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GenericsTest {
    private final Swagger swagger = new Reader(new Swagger()).read(ResourceWithGenerics.class);
    private final Set<String> enumValues = Sets.newHashSet((Iterable)Collections2.transform(Arrays.asList(TestEnum.values()), (Function)Functions.toStringFunction()));

    private void testEnumCollection(QueryParameter p, String name) {
        this.testCollection(p, name, "string", null);
        StringProperty schema = (StringProperty)p.getItems();
        Assert.assertEquals((Collection)schema.getEnum(), this.enumValues);
    }

    private void testCollection(QueryParameter p, String name, String type, String format) {
        Assert.assertEquals((String)p.getName(), (String)name);
        Assert.assertEquals((String)p.getType(), (String)"array");
        Assert.assertEquals((String)p.getFormat(), null);
        Assert.assertEquals((String)p.getCollectionFormat(), (String)"multi");
        Assert.assertNotEquals((Object)p.getItems(), null);
        Property schema = p.getItems();
        Assert.assertEquals((String)schema.getType(), (String)type);
        Assert.assertEquals((String)schema.getFormat(), (String)format);
    }

    private void testScalar(QueryParameter p, String name, String type, String format) {
        Assert.assertEquals((String)p.getName(), (String)name);
        Assert.assertEquals((String)p.getType(), (String)type);
        Assert.assertEquals((String)p.getFormat(), (String)format);
        Assert.assertEquals((String)p.getCollectionFormat(), null);
        Assert.assertEquals((Object)p.getItems(), null);
    }

    private void testGenericType(Operation op, String type) {
        Assert.assertEquals((String)((RefModel)this.getBodyParameter(op, 0).getSchema()).getSimpleRef(), (String)type);
    }

    private BodyParameter getBodyParameter(Operation op, int index) {
        return (BodyParameter)op.getParameters().get(index);
    }

    private Operation getOperation(String name) {
        return this.swagger.getPath("/generics/" + name).getPost();
    }

    private QueryParameter getQueryParameter(Operation op, int index) {
        return (QueryParameter)op.getParameters().get(index);
    }

    private Property getProperty(String type, String name) {
        return (Property)((Model)this.swagger.getDefinitions().get(type)).getProperties().get(name);
    }

    @Test(description="check collections of integers")
    public void checkCollectionsOfIntegers() {
        Operation op = this.getOperation("testIntegerContainers");
        Assert.assertEquals((int)op.getParameters().size(), (int)8);
        this.testCollection(this.getQueryParameter(op, 0), "set", "integer", "int32");
        this.testCollection(this.getQueryParameter(op, 1), "list", "integer", "int32");
        this.testCollection(this.getQueryParameter(op, 2), "list2D", "string", null);
        this.testCollection(this.getQueryParameter(op, 3), "array", "integer", "int32");
        this.testCollection(this.getQueryParameter(op, 4), "arrayP", "integer", "int32");
        this.testScalar(this.getQueryParameter(op, 5), "scalar", "integer", "int32");
        this.testScalar(this.getQueryParameter(op, 6), "scalarP", "integer", "int32");
        this.testCollection(this.getQueryParameter(op, 7), "forced", "integer", "int32");
    }

    @Test(description="check collections of strings")
    public void checkCollectionsOfStrings() {
        Operation op = this.getOperation("testStringContainers");
        Assert.assertEquals((int)op.getParameters().size(), (int)5);
        QueryParameter set = this.getQueryParameter(op, 0);
        this.testCollection(set, "set", "string", null);
        Assert.assertEquals((Collection)((StringProperty)set.getItems()).getEnum(), Arrays.asList("1", "2", "3"));
        this.testCollection(this.getQueryParameter(op, 1), "list", "string", null);
        this.testCollection(this.getQueryParameter(op, 2), "list2D", "string", null);
        this.testCollection(this.getQueryParameter(op, 3), "array", "string", null);
        this.testScalar(this.getQueryParameter(op, 4), "scalar", "string", null);
    }

    @Test(description="check collections of objects")
    public void checkCollectionsOfObjects() {
        Operation op = this.getOperation("testObjectContainers");
        Assert.assertEquals((int)op.getParameters().size(), (int)5);
        this.testCollection(this.getQueryParameter(op, 0), "set", "string", null);
        this.testCollection(this.getQueryParameter(op, 1), "list", "string", null);
        this.testCollection(this.getQueryParameter(op, 2), "list2D", "string", null);
        this.testCollection(this.getQueryParameter(op, 3), "array", "string", null);
        this.testScalar(this.getQueryParameter(op, 4), "scalar", "string", null);
    }

    @Test(description="check collections of enumerations")
    public void checkCollectionsOfEnumerations() {
        Operation op = this.getOperation("testEnumContainers");
        Assert.assertEquals((int)op.getParameters().size(), (int)5);
        this.testEnumCollection(this.getQueryParameter(op, 0), "set");
        this.testEnumCollection(this.getQueryParameter(op, 1), "list");
        this.testCollection(this.getQueryParameter(op, 2), "list2D", "string", null);
        this.testEnumCollection(this.getQueryParameter(op, 3), "array");
        QueryParameter scalar = this.getQueryParameter(op, 4);
        this.testScalar(scalar, "scalar", "string", null);
        Assert.assertEquals((Collection)scalar.getEnum(), this.enumValues);
    }

    @Test(description="check collection of strings as body parameter")
    public void checkCollectionsOfStringsAsBodyParameter() {
        Operation op = this.getOperation("testStringsInBody");
        Assert.assertEquals((int)op.getParameters().size(), (int)1);
        BodyParameter p = this.getBodyParameter(op, 0);
        ArrayModel strArray = (ArrayModel)p.getSchema();
        Assert.assertEquals((String)strArray.getItems().getType(), (String)"string");
    }

    @Test(description="check collection of objects as body parameter")
    public void checkCollectionsOfObjectsAsBodyParameter() {
        Operation op = this.getOperation("testObjectsInBody");
        Assert.assertEquals((int)op.getParameters().size(), (int)1);
        BodyParameter p = this.getBodyParameter(op, 0);
        ArrayModel objArray = (ArrayModel)p.getSchema();
        Assert.assertEquals((String)((RefProperty)objArray.getItems()).getSimpleRef(), (String)"Tag");
    }

    @Test(description="check collection of enumerations as body parameter")
    public void checkCollectionsOfEnumerationsAsBodyParameter() {
        Operation op = this.getOperation("testEnumsInBody");
        Assert.assertEquals((int)op.getParameters().size(), (int)1);
        BodyParameter p = this.getBodyParameter(op, 0);
        ArrayModel enumArray = (ArrayModel)p.getSchema();
        Assert.assertEquals((Collection)((StringProperty)enumArray.getItems()).getEnum(), this.enumValues);
    }

    @Test(description="check 2D array as body parameter")
    public void check2DArrayAsBodyParameter() {
        Operation op = this.getOperation("test2DInBody");
        Assert.assertEquals((int)op.getParameters().size(), (int)1);
        BodyParameter p = this.getBodyParameter(op, 0);
        ArrayModel ddArray = (ArrayModel)p.getSchema();
        Assert.assertEquals((String)((RefProperty)((ArrayProperty)ddArray.getItems()).getItems()).getSimpleRef(), (String)"Tag");
    }

    @Test(description="check parameters of generic types")
    public void checkParametersOfGenericTypes() {
        HashSet<String> genericTypes = new HashSet<String>(Arrays.asList("GenericTypeString", "GenericTypeUUID", "GenericTypeGenericTypeString", "RenamedGenericTypeString", "RenamedGenericTypeRenamedGenericTypeString"));
        Assert.assertTrue((boolean)this.swagger.getDefinitions().keySet().containsAll(genericTypes));
        Operation opString = this.getOperation("testGenericType");
        this.testGenericType(opString, "GenericTypeString");
        Property strValue = this.getProperty("GenericTypeString", "value");
        Assert.assertNotEquals((Object)strValue, null);
        Assert.assertEquals((String)strValue.getClass().getName(), (String)StringProperty.class.getName());
        Operation opUUID = this.getOperation("testStringBasedGenericType");
        this.testGenericType(opUUID, "GenericTypeUUID");
        Property uuidValue = this.getProperty("GenericTypeUUID", "value");
        Assert.assertNotEquals((Object)uuidValue, null);
        Assert.assertEquals((String)uuidValue.getClass().getName(), (String)UUIDProperty.class.getName());
        Operation opComplex = this.getOperation("testComplexGenericType");
        this.testGenericType(opComplex, "GenericTypeGenericTypeString");
        Property complexValue = this.getProperty("GenericTypeGenericTypeString", "value");
        Assert.assertNotEquals((Object)complexValue, null);
        Assert.assertEquals((String)complexValue.getClass().getName(), (String)RefProperty.class.getName());
        Assert.assertEquals((String)((RefProperty)complexValue).getSimpleRef(), (String)"GenericTypeString");
        Operation opRenamed = this.getOperation("testRenamedGenericType");
        this.testGenericType(opRenamed, "RenamedGenericTypeRenamedGenericTypeString");
        Property renamedComplexValue = this.getProperty("RenamedGenericTypeRenamedGenericTypeString", "value");
        Assert.assertNotEquals((Object)renamedComplexValue, null);
        Assert.assertTrue((boolean)(renamedComplexValue instanceof RefProperty));
        Assert.assertEquals((String)((RefProperty)renamedComplexValue).getSimpleRef(), (String)"RenamedGenericTypeString");
    }

    @Test(description="check generic result")
    public void checkGenericResult() {
        Operation op = this.swagger.getPath("/generics/testGenericResult").getGet();
        Model schema = ((Response)op.getResponsesObject().get((Object)"200")).getResponseSchema();
        Assert.assertEquals((String)schema.getClass().getName(), (String)RefModel.class.getName());
        Assert.assertEquals((String)((RefModel)schema).getSimpleRef(), (String)"GenericListWrapperTag");
        Property entries = this.getProperty("GenericListWrapperTag", "entries");
        Assert.assertNotEquals((Object)entries, null);
        Assert.assertEquals((String)entries.getClass().getName(), (String)ArrayProperty.class.getName());
        Property items = ((ArrayProperty)entries).getItems();
        Assert.assertEquals((String)items.getClass().getName(), (String)RefProperty.class.getName());
        Assert.assertEquals((String)((RefProperty)items).getSimpleRef(), (String)"Tag");
    }

    @Test(description="scan model with Generic Type")
    public void scanModelWithGenericType() {
        Swagger swagger = new Reader(new Swagger()).read(UserApiRoute.class);
        Assert.assertNotNull((Object)swagger);
        Model userEntity = (Model)swagger.getDefinitions().get("UserEntity");
        Assert.assertNotNull((Object)userEntity);
        Map properties = userEntity.getProperties();
        Assert.assertEquals((int)properties.size(), (int)2);
        Assert.assertNotNull(properties.get("id"));
        Assert.assertNotNull(properties.get("name"));
    }
}

