/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.resources.HiddenParametersResource;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HiddenParametersScannerTest {
    private final Swagger swagger = new Reader(new Swagger()).read(HiddenParametersResource.class);

    @Test
    public void shouldScanMethodWithAllParamsHidden() throws Exception {
        Operation get = this.getGet("/all-hidden/{id}");
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((int)0, (int)get.getParameters().size());
    }

    @Test
    public void shouldScanMethodWithSomeParamsHidden() {
        Operation get = this.getGet("/some-hidden/{id}");
        Assert.assertNotNull((Object)get);
        List parameters = get.getParameters();
        Assert.assertEquals((int)parameters.size(), (int)3);
        Assert.assertEquals((String)((Parameter)parameters.get(0)).getIn(), (String)"cookie");
        Assert.assertEquals((String)((Parameter)parameters.get(1)).getIn(), (String)"header");
        Assert.assertEquals((String)((Parameter)parameters.get(2)).getIn(), (String)"query");
    }

    @Test
    public void shouldScanMethodWithOtherParamsHidden() {
        Operation get = this.getGet("/others-hidden/{id}");
        Assert.assertNotNull((Object)get);
        List parameters = get.getParameters();
        Assert.assertEquals((int)parameters.size(), (int)3);
        Assert.assertEquals((String)((Parameter)parameters.get(0)).getIn(), (String)"body");
        Assert.assertEquals((String)((Parameter)parameters.get(1)).getIn(), (String)"formData");
        Assert.assertEquals((String)((Parameter)parameters.get(2)).getIn(), (String)"path");
    }

    private Operation getGet(String path) {
        return ((Path)this.swagger.getPaths().get(path)).getGet();
    }
}

