/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonViewTest {
    @Test(description="check awareness of JsonView")
    public void shouldSerializeTypeParameter() throws JsonProcessingException {
        Swagger swagger = this.getSwagger(CarSummaryApi.class);
        String swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertTrue((boolean)swaggerJson.contains("manufacture"));
        Assert.assertTrue((boolean)swaggerJson.contains("model"));
        Assert.assertTrue((boolean)swaggerJson.contains("color"));
        Assert.assertFalse((boolean)swaggerJson.contains("tires"));
        Assert.assertFalse((boolean)swaggerJson.contains("made"));
        Assert.assertFalse((boolean)swaggerJson.contains("condition"));
        swagger = this.getSwagger(CarDetailApi.class);
        swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertTrue((boolean)swaggerJson.contains("manufacture"));
        Assert.assertTrue((boolean)swaggerJson.contains("model"));
        Assert.assertTrue((boolean)swaggerJson.contains("color"));
        Assert.assertTrue((boolean)swaggerJson.contains("tires"));
        Assert.assertTrue((boolean)swaggerJson.contains("brand"));
        Assert.assertTrue((boolean)swaggerJson.contains("condition"));
        Assert.assertTrue((boolean)swaggerJson.contains("Car_Detail"));
        swagger = this.getSwagger(CarSaleSummaryApi.class);
        swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertTrue((boolean)swaggerJson.contains("manufacture"));
        Assert.assertTrue((boolean)swaggerJson.contains("model"));
        Assert.assertTrue((boolean)swaggerJson.contains("color"));
        Assert.assertTrue((boolean)swaggerJson.contains("price"));
        Assert.assertFalse((boolean)swaggerJson.contains("tires"));
        Assert.assertFalse((boolean)swaggerJson.contains("made"));
        Assert.assertFalse((boolean)swaggerJson.contains("condition"));
        swagger = this.getSwagger(CarApi.class);
        swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertTrue((boolean)swaggerJson.contains("manufacture"));
        Assert.assertTrue((boolean)swaggerJson.contains("model"));
        Assert.assertTrue((boolean)swaggerJson.contains("color"));
        Assert.assertTrue((boolean)swaggerJson.contains("price"));
        Assert.assertTrue((boolean)swaggerJson.contains("tires"));
        Assert.assertFalse((boolean)swaggerJson.contains("made"));
        Assert.assertTrue((boolean)swaggerJson.contains("condition"));
        swagger = this.getSwagger(CarIgnoreApi.class);
        swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertTrue((boolean)swaggerJson.contains("manufacture"));
        Assert.assertTrue((boolean)swaggerJson.contains("model"));
        Assert.assertTrue((boolean)swaggerJson.contains("color"));
        Assert.assertTrue((boolean)swaggerJson.contains("price"));
        Assert.assertTrue((boolean)swaggerJson.contains("tires"));
        Assert.assertFalse((boolean)swaggerJson.contains("made"));
        Assert.assertTrue((boolean)swaggerJson.contains("condition"));
    }

    private Swagger getSwagger(Class<?> cls) {
        return new Reader(new Swagger()).read(cls);
    }

    @Api
    @Path(value="/ignore")
    private static class CarIgnoreApi {
        private CarIgnoreApi() {
        }

        @GET
        @Path(value="/cars")
        @JsonView(value={View.Summary.class, View.Sale.class})
        @ApiOperation(value="getCars", ignoreJsonView=true)
        public List<Car> getCars() {
            return Arrays.asList(new Car());
        }
    }

    @Api
    @Path(value="/")
    private static class CarApi {
        private CarApi() {
        }

        @GET
        @Path(value="/cars")
        public List<Car> getCars() {
            return Arrays.asList(new Car());
        }
    }

    @Api
    @Path(value="/")
    private static class CarSaleSummaryApi {
        private CarSaleSummaryApi() {
        }

        @GET
        @Path(value="/cars/sale")
        @JsonView(value={View.Summary.class, View.Sale.class})
        public List<Car> getSaleSummaries() {
            return Arrays.asList(new Car());
        }
    }

    @Api
    @Path(value="/")
    private static class CarDetailApi {
        private CarDetailApi() {
        }

        @GET
        @Path(value="/cars/detail")
        @JsonView(value={View.Detail.class})
        @ApiOperation(value="Return car detail", response=Car.class, responseContainer="List")
        public Response getDetails() {
            return Response.ok(Arrays.asList(new Car())).build();
        }
    }

    @Api
    @Path(value="/")
    private static class CarSummaryApi {
        private CarSummaryApi() {
        }

        @GET
        @Path(value="/cars/summary")
        @JsonView(value={View.Summary.class})
        public List<Car> getSummaries() {
            return Arrays.asList(new Car());
        }
    }

    private static class Tire {
        @JsonView(value={View.Summary.class})
        @JsonProperty(value="brand")
        private String made = "Michelin";
        @JsonView(value={View.Detail.class})
        @JsonProperty
        private String condition = "new";

        private Tire() {
        }
    }

    private static class Car {
        @JsonView(value={View.Summary.class})
        @JsonProperty(value="manufacture")
        private String made = "Honda";
        @JsonView(value={View.Summary.class, View.Detail.class})
        private String model = "Accord Hybrid";
        @JsonView(value={View.Detail.class})
        @JsonProperty
        private List<Tire> tires = Arrays.asList(new Tire());
        @JsonView(value={View.Sale.class})
        @JsonProperty
        private int price = 40000;
        private String color = "White";

        private Car() {
        }

        public String getColor() {
            return this.color;
        }
    }

    private static class View {
        private View() {
        }

        static interface Sale {
        }

        static interface Detail
        extends Summary {
        }

        static interface Summary {
        }
    }
}

