/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.resources.PostParamResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PostParamTest {
    private static final String BODY = "body";
    private static final String PET = "Pet";
    private final Swagger swagger = new Reader(new Swagger()).read(PostParamResource.class);

    @Test(description="find a Post operation with single object")
    public void findPostOperationWithSingleObject() {
        Path petPath = this.getPath("singleObject");
        Assert.assertNotNull((Object)petPath);
        Assert.assertNull((Object)petPath.getGet());
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Assert.assertTrue((boolean)(petPostBodyParam.getSchema() instanceof Model));
        Assert.assertEquals((String)((Property)((Model)this.swagger.getDefinitions().get(PET)).getProperties().get("status")).getAccess(), (String)"public");
    }

    @Test(description="find a Post operation with list of objects")
    public void findPostOperationWithObjectsList() {
        Path petPath = this.getPath("listOfObjects");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof RefProperty));
        RefProperty rm = (RefProperty)inputSchema;
        Assert.assertEquals((String)rm.getSimpleRef(), (String)PET);
    }

    @Test(description="find a Post operation with collection of objects")
    public void findPostOperationWithObjectsCollection() {
        Path petPath = this.getPath("collectionOfObjects");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof RefProperty));
        RefProperty rm = (RefProperty)inputSchema;
        Assert.assertEquals((String)rm.getSimpleRef(), (String)PET);
    }

    @Test(description="find a Post operation with an array of objects")
    public void findAPostOperationWithObjectsArray() {
        Path petPath = this.getPath("arrayOfObjects");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof RefProperty));
        RefProperty rm = (RefProperty)inputSchema;
        Assert.assertEquals((String)rm.getSimpleRef(), (String)PET);
    }

    @Test(description="find a Post operation with single string")
    public void findAPostOperationWithSingleString() {
        Path petPath = this.getPath("singleString");
        Assert.assertNotNull((Object)petPath);
        Assert.assertNull((Object)petPath.getGet());
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Assert.assertTrue((boolean)(petPostBodyParam.getSchema() instanceof Model));
    }

    @Test(description="find a Post operation with list of strings")
    public void findAPostOperationWithStringsList() {
        Path petPath = this.getPath("listOfStrings");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof StringProperty));
    }

    @Test(description="find a Post operation with collection of strings")
    public void findAPostOperationWithStringsCollection() {
        Path petPath = this.getPath("collectionOfStrings");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof StringProperty));
    }

    @Test(description="find a Post operation with an array of strings")
    public void findAPostOperationWithStringsArray() {
        Path petPath = this.getPath("arrayOfStrings");
        Assert.assertNotNull((Object)petPath);
        Operation petPost = petPath.getPost();
        Assert.assertNotNull((Object)petPost);
        Assert.assertEquals((int)petPost.getParameters().size(), (int)1);
        BodyParameter petPostBodyParam = (BodyParameter)petPost.getParameters().get(0);
        Assert.assertEquals((String)petPostBodyParam.getName(), (String)BODY);
        Model inputModel = petPostBodyParam.getSchema();
        Assert.assertTrue((boolean)(inputModel instanceof ArrayModel));
        ArrayModel ap = (ArrayModel)inputModel;
        Property inputSchema = ap.getItems();
        Assert.assertTrue((boolean)(inputSchema instanceof StringProperty));
    }

    private Path getPath(String path) {
        return (Path)this.swagger.getPaths().get("/pet/".concat(path));
    }
}

