/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.Reader;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Pet;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.resources.AnnotatedInterfaceImpl;
import io.swagger.resources.ApiConsumesProducesResource;
import io.swagger.resources.ApiMultipleConsumesProducesResource;
import io.swagger.resources.BookResource;
import io.swagger.resources.BothConsumesProducesResource;
import io.swagger.resources.ClassPathParentResource;
import io.swagger.resources.ClassPathSubResource;
import io.swagger.resources.DescendantResource;
import io.swagger.resources.IndirectImplicitParamsImpl;
import io.swagger.resources.MyClass;
import io.swagger.resources.MyOtherClass;
import io.swagger.resources.NoConsumesProducesResource;
import io.swagger.resources.Resource1970;
import io.swagger.resources.ResourceWithAnnotationsOnlyInInterfaceImpl;
import io.swagger.resources.ResourceWithClassLevelApiResourceNoMethodLevelApiResources;
import io.swagger.resources.ResourceWithCustomException;
import io.swagger.resources.ResourceWithCustomExceptionAndClassLevelApiResource;
import io.swagger.resources.ResourceWithDeprecatedMethod;
import io.swagger.resources.ResourceWithEmptyPath;
import io.swagger.resources.ResourceWithExternalDocs;
import io.swagger.resources.ResourceWithImplicitFileParam;
import io.swagger.resources.ResourceWithImplicitParams;
import io.swagger.resources.ResourceWithKnownInjections;
import io.swagger.resources.ResourceWithValidation;
import io.swagger.resources.RsConsumesProducesResource;
import io.swagger.resources.RsMultipleConsumesProducesResource;
import io.swagger.resources.SimpleMethods;
import io.swagger.util.Json;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReaderTest {
    private static final String APPLICATION_XML = "application/xml";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    private static final String TEXT_JSON = "text/json";
    private static final String CHARSET8 = ";charset=UTF-8";
    private static final String TEXT_XML_CHARSET = "text/xml;charset=UTF-8";
    private static final String TEXT_HTML_CHARSET = "text/html;charset=UTF-8";

    @Test(description="scan methods")
    public void scanMethods() {
        Method[] methods = SimpleMethods.class.getMethods();
        Reader reader = new Reader(new Swagger());
        for (Method method : methods) {
            if (!this.isValidRestPath(method).booleanValue()) continue;
            Operation operation = reader.parseMethod(method);
            Assert.assertNotNull((Object)operation);
        }
    }

    @Test(description="scan consumes and produces values with api class level annotations")
    public void scanConsumesProducesValuesWithApiClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(ApiConsumesProducesResource.class);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getConsumes().get(0)), (String)"application/xhtml+xml");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getProduces().get(0)), (String)"application/atom+xml");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getConsumes().get(1)), (String)TEXT_HTML_CHARSET);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getProduces().get(1)), (String)TEXT_XML_CHARSET);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getConsumes().get(0)), (String)"application/json");
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getConsumes().get(1)), (String)TEXT_HTML_CHARSET);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getProduces().get(1)), (String)TEXT_XML_CHARSET);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
    }

    @Test(description="scan consumes and produces values with api class level annotations")
    public void scanMultipleConsumesProducesValuesWithApiClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(ApiMultipleConsumesProducesResource.class);
        Assert.assertEquals((Collection)this.getGet(swagger, "/{id}").getConsumes(), Arrays.asList("application/xhtml+xml", APPLICATION_XML, "application/json"));
        Assert.assertEquals((Collection)this.getGet(swagger, "/{id}").getProduces(), Arrays.asList("application/atom+xml", "application/json", APPLICATION_XML));
    }

    @Test(description="scan consumes and produces values with rs class level annotations")
    public void scanConsumesProducesValuesWithRsClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(RsConsumesProducesResource.class);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getConsumes().get(0)), (String)"application/yaml");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getProduces().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getConsumes().get(0)), (String)"application/json");
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((Collection)this.getPut(swagger, "/split").getProduces(), Arrays.asList("image/jpeg", "image/gif", "image/png"));
        Assert.assertEquals((Collection)this.getPut(swagger, "/split").getConsumes(), Arrays.asList("image/jpeg", "image/gif", "image/png"));
    }

    @Test(description="scan multiple consumes and produces values with rs class level annotations")
    public void scanMultipleConsumesProducesValuesWithRsClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(RsMultipleConsumesProducesResource.class);
        Assert.assertEquals((Collection)this.getGet(swagger, "/{id}").getConsumes(), Arrays.asList("application/json", APPLICATION_XML));
        Assert.assertEquals((Collection)this.getGet(swagger, "/{id}").getProduces(), Arrays.asList(APPLICATION_XML, "application/json"));
    }

    @Test(description="scan consumes and produces values with both class level annotations")
    public void scanConsumesProducesValuesWithBothClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(BothConsumesProducesResource.class);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getConsumes().get(0)), (String)"application/xhtml+xml");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}").getProduces().get(0)), (String)"application/atom+xml");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/{name}/value").getConsumes().get(0)), (String)"application/json");
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/{name}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/{type}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/{type}/value").getProduces().get(0)), (String)TEXT_HTML);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getConsumes().get(0)), (String)"application/json");
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
    }

    @Test(description="scan consumes and produces values with no class level annotations")
    public void scanConsumesProducesValuesWithoutClassLevelAnnotations() {
        Swagger swagger = this.getSwagger(NoConsumesProducesResource.class);
        Assert.assertNull((Object)this.getGet(swagger, "/{id}").getConsumes());
        Assert.assertNull((Object)this.getGet(swagger, "/{id}").getProduces());
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getGet(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getConsumes().get(0)), (String)"application/json");
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}").getProduces().get(0)), (String)TEXT_PLAIN);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getConsumes().get(0)), (String)APPLICATION_XML);
        Assert.assertEquals((String)((String)this.getPut(swagger, "/{id}/value").getProduces().get(0)), (String)TEXT_PLAIN);
    }

    @Test(description="scan class level and field level annotations")
    public void scanClassAndFieldLevelAnnotations() {
        Swagger swagger = this.getSwagger(ResourceWithKnownInjections.class);
        List resourceParameters = this.getGet(swagger, "/resource/{id}").getParameters();
        Assert.assertNotNull((Object)resourceParameters);
        Assert.assertEquals((int)resourceParameters.size(), (int)3);
        Assert.assertEquals((String)((Parameter)resourceParameters.get(0)).getName(), (String)"id");
        Assert.assertEquals((String)((Parameter)resourceParameters.get(1)).getName(), (String)"fieldParam");
        Assert.assertEquals((String)((Parameter)resourceParameters.get(2)).getName(), (String)"methodParam");
        List subResourceParameters = this.getGet(swagger, "/resource/{id}/subresource1").getParameters();
        Assert.assertNotNull((Object)subResourceParameters);
        Assert.assertEquals((int)subResourceParameters.size(), (int)3);
        Assert.assertEquals((String)((Parameter)subResourceParameters.get(0)).getName(), (String)"id");
        Assert.assertEquals((String)((Parameter)subResourceParameters.get(1)).getName(), (String)"fieldParam");
        Assert.assertEquals((String)((Parameter)subResourceParameters.get(2)).getName(), (String)"subResourceParam");
    }

    private Boolean isValidRestPath(Method method) {
        for (Class item : Arrays.asList(GET.class, PUT.class, POST.class, DELETE.class, OPTIONS.class, HEAD.class)) {
            if (method.getAnnotation(item) == null) continue;
            return true;
        }
        return false;
    }

    @Test(description="scan overridden method in descendantResource")
    public void scanOverriddenMethod() {
        Swagger swagger = this.getSwagger(DescendantResource.class);
        Operation overriddenMethodWithTypedParam = this.getGet(swagger, "/pet/{petId1}");
        Assert.assertNotNull((Object)overriddenMethodWithTypedParam);
        Assert.assertEquals((String)((Parameter)overriddenMethodWithTypedParam.getParameters().get(0)).getDescription(), (String)"ID of pet to return child");
        Operation methodWithoutTypedParam = this.getGet(swagger, "/pet/{petId2}");
        Assert.assertNotNull((Object)methodWithoutTypedParam);
        Operation overriddenMethodWithoutTypedParam = this.getGet(swagger, "/pet/{petId3}");
        Assert.assertNotNull((Object)overriddenMethodWithoutTypedParam);
        Operation methodWithoutTypedParamFromDescendant = this.getGet(swagger, "/pet/{petId4}");
        Assert.assertNotNull((Object)methodWithoutTypedParamFromDescendant);
        Operation methodFromInterface = this.getGet(swagger, "/pet/{petId5}");
        Assert.assertNotNull((Object)methodFromInterface);
    }

    @Test(description="scan annotation from interface, issue#1427")
    public void scanInterfaceTest() {
        Swagger swagger = new Reader(new Swagger()).read(AnnotatedInterfaceImpl.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertNotNull((Object)swagger.getPath("/v1/users/{id}").getGet());
    }

    @Test(description="scan indirect implicit params from interface")
    public void scanImplicitParamInterfaceTest() {
        Swagger swagger = new Reader(new Swagger()).read(IndirectImplicitParamsImpl.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertEquals((int)swagger.getPath("/v1/users/{id}").getGet().getParameters().size(), (int)2);
    }

    @Test(description="scan indirect implicit params from overridden method")
    public void scanImplicitParamOverriddenMethodTest() {
        Swagger swagger = new Reader(new Swagger()).read(IndirectImplicitParamsImpl.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertEquals((int)swagger.getPath("/v1/users").getPost().getParameters().size(), (int)2);
    }

    @Test(description="scan implicit params")
    public void scanImplicitParam() {
        Swagger swagger = this.getSwagger(ResourceWithImplicitParams.class);
        List params = swagger.getPath("/testString").getPost().getParameters();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((int)params.size(), (int)10);
        Assert.assertEquals((String)((Parameter)params.get(0)).getName(), (String)"sort");
        Assert.assertEquals((String)((Parameter)params.get(0)).getIn(), (String)"query");
        PathParameter pathParam = (PathParameter)params.get(1);
        Assert.assertEquals((String)pathParam.getName(), (String)"type");
        Assert.assertEquals((String)pathParam.getIn(), (String)"path");
        Assert.assertEquals((int)pathParam.getEnum().size(), (int)3);
        Assert.assertEquals((String)pathParam.getType(), (String)"string");
        HeaderParameter headerParam = (HeaderParameter)params.get(2);
        Assert.assertEquals((String)headerParam.getName(), (String)"size");
        Assert.assertEquals((String)headerParam.getIn(), (String)"header");
        Assert.assertEquals((Object)headerParam.getMinimum(), (Object)new BigDecimal(1.0));
        FormParameter formParam = (FormParameter)params.get(3);
        Assert.assertEquals((String)formParam.getName(), (String)"width");
        Assert.assertEquals((String)formParam.getIn(), (String)"formData");
        Assert.assertEquals((Object)formParam.getMaximum(), (Object)new BigDecimal(1.0));
        Assert.assertEquals((String)((Parameter)params.get(4)).getName(), (String)"width");
        Assert.assertEquals((String)((Parameter)params.get(4)).getIn(), (String)"formData");
        QueryParameter queryParam = (QueryParameter)params.get(5);
        Assert.assertEquals((String)queryParam.getName(), (String)"height");
        Assert.assertEquals((String)queryParam.getIn(), (String)"query");
        Assert.assertEquals((Object)queryParam.getMinimum(), (Object)new BigDecimal(3.0));
        Assert.assertEquals((Object)queryParam.getMaximum(), (Object)new BigDecimal(4.0));
        BodyParameter bodyParam = (BodyParameter)params.get(6);
        Assert.assertEquals((String)bodyParam.getName(), (String)"body");
        Assert.assertEquals((String)bodyParam.getIn(), (String)"body");
        Assert.assertTrue((boolean)bodyParam.getRequired());
        queryParam = (QueryParameter)params.get(7);
        Assert.assertEquals((String)queryParam.getName(), (String)"description");
        Assert.assertEquals((String)queryParam.getIn(), (String)"query");
        Assert.assertNull((Object)queryParam.getType());
        QueryParameter selectByParam = (QueryParameter)params.get(8);
        Assert.assertEquals((String)selectByParam.getName(), (String)"select");
        Assert.assertEquals((String)selectByParam.getIn(), (String)"query");
        Assert.assertEquals((String)selectByParam.getCollectionFormat(), (String)"multi");
        QueryParameter orderByParam = (QueryParameter)params.get(9);
        Assert.assertEquals((String)orderByParam.getName(), (String)"orderby");
        Assert.assertEquals((String)orderByParam.getIn(), (String)"query");
        Assert.assertEquals((String)orderByParam.getCollectionFormat(), (String)"csv");
    }

    @Test(description="scan implicit params with file objct")
    public void scanImplicitWithFile() {
        Swagger swagger = this.getSwagger(ResourceWithImplicitFileParam.class);
        Parameter param = (Parameter)swagger.getPath("/testString").getPost().getParameters().get(0);
        Assert.assertTrue((boolean)(param instanceof FormParameter));
        FormParameter fp = (FormParameter)param;
        Assert.assertEquals((String)"file", (String)fp.getType());
    }

    @Test(description="scan Deprecated annotation")
    public void scanDeprecatedAnnotation() {
        Swagger swagger = this.getSwagger(ResourceWithDeprecatedMethod.class);
        Assert.assertTrue((boolean)this.getGet(swagger, "/testDeprecated").isDeprecated());
        Assert.assertNull((Object)this.getGet(swagger, "/testAllowed").isDeprecated());
    }

    @Test(description="scan empty path annotation")
    public void scanEmptyPathAnnotation() {
        Swagger swagger = this.getSwagger(ResourceWithEmptyPath.class);
        Assert.assertNotNull((Object)this.getGet(swagger, "/"));
    }

    @Test(description="it should scan parameters from base resource class")
    public void scanParametersFromBaseResource() {
        Swagger swagger = this.getSwagger(BookResource.class);
        Assert.assertNotNull((Object)swagger);
        List parameters = this.getGet(swagger, "/{id}/v1/books/{name}").getParameters();
        Assert.assertEquals((int)parameters.size(), (int)4);
        Parameter description = (Parameter)parameters.get(0);
        Assert.assertTrue((boolean)(description instanceof PathParameter));
        Assert.assertEquals((String)description.getName(), (String)"description");
        Assert.assertEquals((String)description.getDescription(), (String)"Overridden description");
        Parameter id = (Parameter)parameters.get(1);
        Assert.assertTrue((boolean)(id instanceof PathParameter));
        Assert.assertEquals((String)id.getName(), (String)"id");
        Assert.assertEquals((String)id.getDescription(), (String)"The Identifier of entity");
        Parameter test = (Parameter)parameters.get(2);
        Assert.assertTrue((boolean)(test instanceof QueryParameter));
        Assert.assertEquals((String)test.getName(), (String)"test");
        Assert.assertEquals((String)test.getDescription(), (String)"Test Query Param");
        Parameter name = (Parameter)parameters.get(3);
        Assert.assertTrue((boolean)(name instanceof PathParameter));
        Assert.assertEquals((String)name.getName(), (String)"name");
        Assert.assertEquals((String)name.getDescription(), (String)"The books name");
    }

    @Test(description="it should scan parameters with Swagger and JSR-303 bean validation annotations")
    public void scanBeanValidation() {
        Swagger swagger = this.getSwagger(ResourceWithValidation.class);
        Assert.assertNotNull((Object)swagger);
        QueryParameter par = (QueryParameter)((Operation)((Path)swagger.getPaths().get("/303")).getOperations().get(0)).getParameters().get(0);
        Assert.assertTrue((boolean)par.getRequired());
        Assert.assertEquals((Object)par.getMinimum(), (Object)new BigDecimal(10));
        par = (QueryParameter)((Operation)((Path)swagger.getPaths().get("/swagger-and-303")).getOperations().get(0)).getParameters().get(0);
        Assert.assertTrue((boolean)par.getRequired());
        Assert.assertEquals((Object)par.getMinimum(), (Object)new BigDecimal(7));
        par = (QueryParameter)((Operation)((Path)swagger.getPaths().get("/swagger")).getOperations().get(0)).getParameters().get(0);
        Assert.assertTrue((boolean)par.getRequired());
        Assert.assertEquals((Object)par.getMinimum(), (Object)new BigDecimal(7));
    }

    @Test(description="scan resource with annotated exception")
    public void scanDeclaredExceptions() {
        Swagger swagger = this.getSwagger(ResourceWithCustomException.class);
        Assert.assertNotNull((Object)swagger);
        Operation operation = this.getGet(swagger, "/{id}");
        Assert.assertEquals((int)operation.getResponsesObject().size(), (int)3);
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"200"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"400"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"404"));
    }

    @Test(description="scan resource with annotated exception")
    public void scanDeclaredExceptionsAndCombineWithMethodResponses() {
        Swagger swagger = this.getSwagger(ResourceWithCustomException.class);
        Assert.assertNotNull((Object)swagger);
        Operation operation = this.getPut(swagger, "/{id}");
        Assert.assertEquals((int)operation.getResponsesObject().size(), (int)4);
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"200"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"400"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"404"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"409"));
    }

    @Test(description="scan resource with annotated exception")
    public void scanDeclaredExceptionsAndCombineWithMethodResponsesClassLevel() {
        Swagger swagger = this.getSwagger(ResourceWithCustomExceptionAndClassLevelApiResource.class);
        Assert.assertNotNull((Object)swagger);
        Operation operation = this.getPut(swagger, "/{id}");
        Assert.assertEquals((int)operation.getResponsesObject().size(), (int)5);
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"200"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"400"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"404"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"403"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"409"));
        Assert.assertEquals((String)((Response)operation.getResponsesObject().get((Object)"409")).getDescription(), (String)"Conflict");
        swagger = this.getSwagger(ResourceWithClassLevelApiResourceNoMethodLevelApiResources.class);
        Assert.assertNotNull((Object)swagger);
        operation = this.getPut(swagger, "/{id}");
        Assert.assertEquals((int)operation.getResponsesObject().size(), (int)2);
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"403"));
        Assert.assertTrue((boolean)operation.getResponsesObject().containsKey((Object)"409"));
    }

    @Test(description="scan resource (impl) which has the Api annotations only declared in its interface")
    public void scanApiAnnotationWhichAreOnlyPresentInInterfaceAndNotInImplementation() {
        Swagger swagger = this.getSwagger(ResourceWithAnnotationsOnlyInInterfaceImpl.class);
        Assert.assertNotNull((Object)swagger);
        List tags = swagger.getTags();
        Assert.assertEquals((int)tags.size(), (int)1);
        Assert.assertEquals((String)((Tag)tags.get(0)).getName(), (String)"someTag");
    }

    @Test(description="scan resource (impl) which has the ApiParam annotations only declared in its interface")
    public void scanApiImplicitParamAnnotationWhichAreOnlyPresentInInterfaceAndNotInImplementation() {
        Swagger swagger = this.getSwagger(ResourceWithAnnotationsOnlyInInterfaceImpl.class);
        Assert.assertNotNull((Object)swagger);
        List parameters = this.getGet(swagger, "/pet/randomPet").getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((int)parameters.size(), (int)1);
        Assert.assertEquals((String)((Parameter)parameters.get(0)).getName(), (String)"petImplicitIdParam");
    }

    @Test(description="scan resource per #1970")
    public void scanBigDecimal() {
        Swagger swagger = this.getSwagger(Resource1970.class);
        Assert.assertNotNull((Object)swagger);
        PathParameter parameter = (PathParameter)swagger.getPath("/v1/{param1}").getGet().getParameters().get(0);
        Assert.assertEquals((String)parameter.getType(), (String)"number");
    }

    @Test(description="scan external docs on method")
    public void scanExternalDocsOnMethod() {
        Swagger swagger = this.getSwagger(ResourceWithExternalDocs.class);
        ExternalDocs externalDocsForGet = swagger.getPath("/testString").getGet().getExternalDocs();
        Assert.assertNull((Object)externalDocsForGet);
        ExternalDocs externalDocsForPost = swagger.getPath("/testString").getPost().getExternalDocs();
        Assert.assertNotNull((Object)externalDocsForPost);
        Assert.assertEquals((String)"Test Description", (String)externalDocsForPost.getDescription());
        Assert.assertEquals((String)"https://swagger.io/", (String)externalDocsForPost.getUrl());
    }

    @Test(description="Scan subresource per #2632")
    public void testSubResourceHasTheRightApiPath() {
        Swagger swagger = this.getSwagger(ClassPathParentResource.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertNotNull((Object)swagger.getPath("/v1/parent"));
        Assert.assertNotNull((Object)swagger.getPath("/v1/parent/{id}"));
        Assert.assertEquals((int)swagger.getPaths().size(), (int)2);
        swagger = this.getSwagger(ClassPathSubResource.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertNotNull((Object)swagger.getPath("/subresource"));
        Assert.assertNotNull((Object)swagger.getPath("/subresource/{id}"));
        Assert.assertEquals((int)swagger.getPaths().size(), (int)2);
    }

    @Test(description="Test Response Example")
    public void testResponseExample() {
        Swagger swagger = this.getSwagger(ResponseExampleResource.class);
        Assert.assertNotNull((Object)swagger);
        Assert.assertNotNull((Object)swagger.getPath("/v1/example"));
        Assert.assertEquals((int)swagger.getPaths().size(), (int)1);
        Assert.assertTrue((boolean)(((Response)swagger.getPath("/v1/example").getGet().getResponses().get("200")).getExamples().get("application/json") instanceof JsonNode));
    }

    @Test(description="Resolve Model with XML Properties starting with is prefix per #2635")
    public void testModelResolverXMLPropertiesName() {
        MyClass myClass = new MyClass();
        myClass.populate("isotonicDrink value", "softDrink value", "isoDrink value", "isotonicDrinkOnlyXmlElement value");
        Json.mapper().registerModule((Module)new JaxbAnnotationModule());
        Map schemas = ModelConverters.getInstance().read(MyClass.class);
        Assert.assertNull(((Model)schemas.get("MyClass")).getProperties().get("isotonicDrink"));
        Assert.assertNotNull(((Model)schemas.get("MyClass")).getProperties().get("beerDrink"));
        Assert.assertNotNull(((Model)schemas.get("MyClass")).getProperties().get("saltDrink"));
        Assert.assertNull(((Model)schemas.get("MyClass")).getProperties().get("beerDrinkXmlElement"));
        Assert.assertNotNull(((Model)schemas.get("MyClass")).getProperties().get("isotonicDrinkOnlyXmlElement"));
    }

    @Test(description="Maintain Property names per #2635")
    public void testMaintainPropertyNames() {
        MyOtherClass myOtherClass = new MyOtherClass();
        myOtherClass.populate("myPropertyName value");
        Json.mapper().registerModule((Module)new JaxbAnnotationModule());
        Map schemas = ModelConverters.getInstance().read(MyOtherClass.class);
        Assert.assertNotNull(((Model)schemas.get("MyOtherClass")).getProperties().get("MyPrOperTyName"));
    }

    private Swagger getSwagger(Class<?> cls) {
        return new Reader(new Swagger()).read(cls);
    }

    private Operation getGet(Swagger swagger, String path) {
        return swagger.getPath(path).getGet();
    }

    private Operation getPut(Swagger swagger, String path) {
        return swagger.getPath(path).getPut();
    }

    @Api
    @javax.ws.rs.Path(value="/v1")
    public class ResponseExampleResource {
        @javax.ws.rs.Path(value="example")
        @ApiOperation(value="aa")
        @ApiResponses(value={@ApiResponse(code=200, message="test", response=Pet.class, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"id\" : 1, \"name\" : \"test\"}")}))})
        @GET
        public javax.ws.rs.core.Response getResource() {
            return null;
        }
    }
}

