/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.Reader;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.Pet;
import io.swagger.models.Swagger;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.GenericRef;
import io.swagger.resources.ResourceWithMoreReferences;
import io.swagger.resources.ResourceWithReferences;
import io.swagger.util.Json;
import io.swagger.util.ReferenceSerializationConfigurer;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReferenceTest {
    @Test(description="Scan a model with common reference and reference with ApiModel")
    public void scanModel() {
        Map props = ((Model)ModelConverters.getInstance().readAll(Pet.class).get("Pet")).getProperties();
        RefProperty category = (RefProperty)props.get("category");
        Assert.assertEquals((String)category.getType(), (String)"ref");
        Assert.assertEquals((String)category.get$ref(), (String)"#/definitions/Category");
        RefProperty categoryWithApiModel = (RefProperty)props.get("categoryWithApiModel");
        Assert.assertEquals((String)categoryWithApiModel.getType(), (String)"ref");
        Assert.assertEquals((String)categoryWithApiModel.get$ref(), (String)"#/definitions/MyCategory");
    }

    @Test(description="Scan API with operation and response references")
    public void scanAPI() throws IOException {
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithReferences.class);
        String json = ResourceUtils.loadClassResource(this.getClass(), (String)"ResourceWithReferences.json");
        SerializationMatchers.assertEqualsToJson((Object)swagger, (String)json);
    }

    @Test(description="Scan API with references")
    public void scanRef() throws IOException {
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithMoreReferences.class);
        String json = ResourceUtils.loadClassResource(this.getClass(), (String)"ResourceWithMoreReferences.json");
        SerializationMatchers.assertEqualsToJson((Object)swagger, (String)json);
    }

    @Test(description="Serialize API with references and OriginalRefMixin activated")
    public void serializeRefWithOriginalRef() throws Exception {
        ObjectMapper mapper = Json.mapper().copy();
        ReferenceSerializationConfigurer.serializeAsOriginalRef((ObjectMapper)mapper);
        String json = ResourceUtils.loadClassResource(this.getClass(), (String)"ResourceWithMoreReferencesAsOriginalRef.json");
        Swagger swagger = (Swagger)Json.mapper().readValue(json, Swagger.class);
        SerializationMatchers.assertEqualsToString((Object)swagger, (String)json, (ObjectMapper)mapper);
    }

    @Test(description="Serialize API with references and internal ref also with dots activated")
    public void serializeRefWithInternalRef() throws Exception {
        try {
            GenericRef.internalRefWithAnyDot();
            String json = ResourceUtils.loadClassResource(this.getClass(), (String)"ResourceWithMoreReferencesWithInternalRef.json");
            Swagger swagger = (Swagger)Json.mapper().readValue(json, Swagger.class);
            SerializationMatchers.assertEqualsToJson((Object)swagger, (String)json);
        }
        finally {
            GenericRef.relativeRefWithAnyDot();
        }
    }

    @Test(description="Scan API with references and OriginalRefMixin activated")
    public void scanRefWithOriginalRef() throws IOException {
        ObjectMapper mapper = Json.mapper().copy();
        ReferenceSerializationConfigurer.serializeAsOriginalRef((ObjectMapper)mapper);
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithMoreReferences.class);
        String json = ResourceUtils.loadClassResource(this.getClass(), (String)"ResourceWithMoreReferencesAsOriginalRef.json");
        SerializationMatchers.assertEqualsToString((Object)swagger, (String)json, (ObjectMapper)mapper);
    }
}

