/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.resources.ResourceWithScheme;
import io.swagger.resources.ResourceWithoutScheme;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceWithSchemeTest {
    private final Reader reader = new Reader(new Swagger());

    private Swagger getSwagger(Class<?> resource) {
        return this.reader.read(resource);
    }

    private List<Scheme> loadSchemes(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getGet().getSchemes();
    }

    @Test(description="scan another resource with subresources")
    public void scanResourceWithSubresources() {
        Swagger swagger = this.getSwagger(ResourceWithScheme.class);
        Assert.assertEquals(this.loadSchemes(swagger, "/test/status"), Arrays.asList(Scheme.HTTPS));
        Assert.assertEquals(this.loadSchemes(swagger, "/test/value"), Arrays.asList(Scheme.WS, Scheme.WSS));
        Assert.assertEquals(this.loadSchemes(swagger, "/test/notes"), Arrays.asList(Scheme.HTTP));
        Assert.assertEquals(this.loadSchemes(swagger, "/test/description"), Arrays.asList(Scheme.HTTP));
    }

    @Test(description="scan resource without schemes")
    public void scanResourceWithoutSchemes() {
        Swagger swagger = this.getSwagger(ResourceWithoutScheme.class);
        Assert.assertNull(this.loadSchemes(swagger, "/test/status"));
        Assert.assertNull(this.loadSchemes(swagger, "/test/value"));
    }
}

