/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Responses;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.TestEnum;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.resources.ClassWithExamplePost;
import io.swagger.resources.ClassWithExamplePostClass;
import io.swagger.resources.HiddenResource;
import io.swagger.resources.Issue1979Resource;
import io.swagger.resources.Issue3286Resource;
import io.swagger.resources.NicknamedOperation;
import io.swagger.resources.NotValidRootResource;
import io.swagger.resources.Resource1041;
import io.swagger.resources.Resource1073;
import io.swagger.resources.Resource1085;
import io.swagger.resources.Resource653;
import io.swagger.resources.Resource841;
import io.swagger.resources.Resource877;
import io.swagger.resources.Resource937;
import io.swagger.resources.ResourceWithApiOperationCode;
import io.swagger.resources.ResourceWithApiResponseResponseContainer;
import io.swagger.resources.ResourceWithBodyParams;
import io.swagger.resources.ResourceWithCustomHTTPMethodAnnotations;
import io.swagger.resources.ResourceWithEmptyModel;
import io.swagger.resources.ResourceWithEnums;
import io.swagger.resources.ResourceWithInnerClass;
import io.swagger.resources.ResourceWithMapReturnValue;
import io.swagger.resources.ResourceWithRanges;
import io.swagger.resources.ResourceWithResponse;
import io.swagger.resources.ResourceWithResponseExamples;
import io.swagger.resources.ResourceWithResponseHeaders;
import io.swagger.resources.ResourceWithTypedResponses;
import io.swagger.resources.ResourceWithVoidReturns;
import io.swagger.resources.SimpleResource;
import io.swagger.resources.SimpleResourceWithoutAnnotations;
import io.swagger.resources.SimpleSelfReferencingSubResource;
import io.swagger.resources.TaggedResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleReaderTest {
    private Swagger getSwagger(Class<?> cls) {
        return new Reader(new Swagger()).read(cls);
    }

    private Map<String, Response> getGetResponses(Swagger swagger, String path) {
        return this.getGet(swagger, path).getResponsesObject();
    }

    private Map<String, Response> getPutResponses(Swagger swagger, String path) {
        return this.getPut(swagger, path).getResponsesObject();
    }

    private List<Parameter> getGetParameters(Swagger swagger, String path) {
        return this.getGet(swagger, path).getParameters();
    }

    private List<Parameter> getPostParameters(Swagger swagger, String path) {
        return this.getPost(swagger, path).getParameters();
    }

    private List<Parameter> getPutParameters(Swagger swagger, String path) {
        return this.getPut(swagger, path).getParameters();
    }

    private Operation getGet(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getGet();
    }

    private Operation getPost(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getPost();
    }

    private Operation getPut(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getPut();
    }

    private Operation getPatch(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getPatch();
    }

    private Operation getDelete(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getDelete();
    }

    @Test(description="scan a simple resource")
    public void scanSimpleResource() {
        Swagger swagger = this.getSwagger(SimpleResource.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)3);
        Operation get = this.getGet(swagger, "/{id}");
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((int)get.getParameters().size(), (int)2);
        PathParameter param1 = (PathParameter)get.getParameters().get(0);
        Assert.assertEquals((String)param1.getIn(), (String)"path");
        Assert.assertEquals((String)param1.getName(), (String)"id");
        Assert.assertTrue((boolean)param1.getRequired());
        Assert.assertEquals((String)param1.getDescription(), (String)"sample param data");
        Assert.assertEquals((Object)param1.getDefaultValue(), (Object)"5");
        Parameter param2 = (Parameter)get.getParameters().get(1);
        Assert.assertEquals((String)param2.getIn(), (String)"query");
        Assert.assertEquals((String)param2.getName(), (String)"limit");
        Assert.assertFalse((boolean)param2.getRequired());
        Assert.assertNull((Object)param2.getDescription());
        List<Parameter> params = this.getPutParameters(swagger, "/{bodyparams}");
        BodyParameter bodyParam1 = (BodyParameter)params.get(0);
        Assert.assertEquals((String)bodyParam1.getIn(), (String)"body");
        Assert.assertEquals((String)bodyParam1.getName(), (String)"body");
        Assert.assertTrue((boolean)bodyParam1.getRequired());
        BodyParameter bodyParam2 = (BodyParameter)params.get(1);
        Assert.assertEquals((String)bodyParam2.getIn(), (String)"body");
        Assert.assertEquals((String)bodyParam2.getName(), (String)"body");
        Assert.assertFalse((boolean)bodyParam2.getRequired());
    }

    @Test(description="scan a resource with custom http method annotations")
    public void scanResourceWithCustomHttpMethodAnnotations() {
        Swagger swagger = this.getSwagger(ResourceWithCustomHTTPMethodAnnotations.class);
        Operation get = this.getGet(swagger, "/");
        Assert.assertNotNull((Object)get);
        Operation post = this.getPost(swagger, "/");
        Assert.assertNotNull((Object)post);
        Operation patch = this.getPatch(swagger, "/");
        Assert.assertNotNull((Object)patch);
        Operation put = this.getPut(swagger, "/");
        Assert.assertNotNull((Object)put);
        Operation delete = this.getDelete(swagger, "/");
        Assert.assertNotNull((Object)delete);
    }

    @Test(description="scan a resource with void return type")
    public void scanResourceWithVoidReturnType() {
        Swagger swagger = this.getSwagger(ResourceWithVoidReturns.class);
        Assert.assertEquals((int)swagger.getDefinitions().size(), (int)1);
        Assert.assertNotNull(swagger.getDefinitions().get("NotFoundModel"));
    }

    @Test(description="scan a resource with map return type")
    public void scanResourceWithMapReturnType() {
        Swagger swagger = this.getSwagger(ResourceWithMapReturnValue.class);
        Operation get = this.getGet(swagger, "/{id}");
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull((Object)get.getResponsesObject());
        Response response = (Response)get.getResponsesObject().get((Object)"200");
        Assert.assertNotNull((Object)response);
        Model schema = response.getResponseSchema();
        Assert.assertEquals(schema.getClass(), ModelImpl.class);
        ModelImpl model = (ModelImpl)schema;
        Assert.assertTrue((model.getAdditionalProperties() != null ? 1 : 0) != 0);
    }

    @Test(description="scan a resource with generics per 653")
    public void scanResourceWithGenerics() {
        Swagger swagger = this.getSwagger(Resource653.class);
        Operation get = this.getGet(swagger, "/external/info");
        Assert.assertNotNull((Object)get);
        Responses responses = get.getResponsesObject();
        Assert.assertNotNull((Object)responses);
        Response response = (Response)responses.get("default");
        Assert.assertNotNull((Object)response);
        Assert.assertNull((Object)response.getResponseSchema());
    }

    @Test(description="scan a resource with javax.ws.core.Response ")
    public void scanResourceWithResponse() {
        Assert.assertNull((Object)this.getSwagger(ResourceWithResponse.class).getDefinitions());
    }

    @Test(description="scan a resource with Response.Status return type per 877")
    public void scanResourceWithResponseStatusReturnType() {
        Swagger swagger = this.getSwagger(Resource877.class);
        Assert.assertNotNull((Object)swagger.getTags());
        Assert.assertEquals((int)swagger.getTags().size(), (int)1);
        Tag tag = (Tag)swagger.getTags().get(0);
        Assert.assertEquals((String)tag.getName(), (String)"externalinfo");
        Assert.assertNull((Object)tag.getDescription());
        Assert.assertNull((Object)tag.getExternalDocs());
    }

    @Test(description="scan a resource with tags")
    public void scanResourceWithApiTags() {
        Assert.assertEquals((int)this.getSwagger(TaggedResource.class).getTags().size(), (int)2);
    }

    @Test(description="scan a resource with tags in test 841")
    public void scanResourceWithApiOperationTags() {
        Swagger swagger = this.getSwagger(Resource841.class);
        Assert.assertEquals((int)swagger.getTags().size(), (int)3);
        List rootTags = this.getGet(swagger, "/fun").getTags();
        Assert.assertEquals((int)rootTags.size(), (int)2);
        Assert.assertEquals((Collection)rootTags, Arrays.asList("tag1", "tag2"));
        List thisTags = this.getGet(swagger, "/fun/this").getTags();
        Assert.assertEquals((int)thisTags.size(), (int)1);
        Assert.assertEquals((Collection)thisTags, Arrays.asList("tag1"));
        List thatTags = this.getGet(swagger, "/fun/that").getTags();
        Assert.assertEquals((int)thatTags.size(), (int)1);
        Assert.assertEquals((Collection)thatTags, Arrays.asList("tag2"));
    }

    @Test(description="scan a resource with param enums")
    public void scanResourceWithParamEnums() {
        Swagger swagger = this.getSwagger(ResourceWithEnums.class);
        SerializableParameter param = (SerializableParameter)this.getGetParameters(swagger, "/{id}").get(2);
        List _enum = param.getEnum();
        Assert.assertEquals((Collection)_enum, Arrays.asList("a", "b", "c", "d", "e"));
        List<Parameter> checkEnumHandling = this.getGetParameters(swagger, "/checkEnumHandling/{v0}");
        List allEnumValues = Lists.newArrayList((Collection)Collections2.transform(Arrays.asList(TestEnum.values()), (Function)Functions.toStringFunction()));
        SerializableParameter v0 = (SerializableParameter)checkEnumHandling.get(0);
        Assert.assertEquals((Collection)v0.getEnum(), (Collection)allEnumValues);
        SerializableParameter v1 = (SerializableParameter)checkEnumHandling.get(1);
        Assert.assertEquals((Collection)((StringProperty)v1.getItems()).getEnum(), (Collection)allEnumValues);
        SerializableParameter v2 = (SerializableParameter)checkEnumHandling.get(2);
        Assert.assertEquals((Collection)((StringProperty)v2.getItems()).getEnum(), (Collection)allEnumValues);
        SerializableParameter v3 = (SerializableParameter)checkEnumHandling.get(3);
        Assert.assertEquals((Collection)v3.getEnum(), Arrays.asList("A", "B", "C"));
    }

    @Test(description="scan a resource with param range")
    public void scanResourceWithParamRange() {
        Swagger swagger = this.getSwagger(ResourceWithRanges.class);
        List<Parameter> params = this.getGetParameters(swagger, "/{id}");
        PathParameter param0 = (PathParameter)params.get(0);
        Assert.assertEquals((String)param0.getName(), (String)"id");
        Assert.assertEquals((Object)param0.getDefaultValue(), (Object)5);
        Assert.assertEquals((Object)param0.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertEquals((Object)param0.getMaximum(), (Object)new BigDecimal(10.0));
        PathParameter param1 = (PathParameter)params.get(1);
        Assert.assertEquals((String)param1.getName(), (String)"minValue");
        Assert.assertEquals((Object)param1.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertNull((Object)param1.getMaximum(), null);
        PathParameter param2 = (PathParameter)params.get(2);
        Assert.assertEquals((String)param2.getName(), (String)"maxValue");
        Assert.assertNull((Object)param2.getMinimum());
        Assert.assertEquals((Object)param2.getMaximum(), (Object)new BigDecimal(100.0));
        PathParameter param3 = (PathParameter)params.get(3);
        Assert.assertEquals((String)param3.getName(), (String)"values");
        IntegerProperty items = (IntegerProperty)param3.getItems();
        Assert.assertEquals((Object)items.getMinimum(), (Object)new BigDecimal(0.0));
        Assert.assertEquals((Object)items.getMaximum(), (Object)new BigDecimal(5.0));
        Assert.assertEquals((Boolean)items.getExclusiveMinimum(), (Boolean)Boolean.TRUE);
        Assert.assertEquals((Boolean)items.getExclusiveMaximum(), (Boolean)Boolean.TRUE);
    }

    @Test(description="scan a resource with response headers")
    public void scanResourceWithResponseHeaders() {
        Swagger swagger = this.getSwagger(ResourceWithResponseHeaders.class);
        Map<String, Response> responses = this.getGetResponses(swagger, "/{id}");
        Map headers200 = responses.get("200").getHeaders();
        Assert.assertEquals((int)headers200.size(), (int)1);
        Assert.assertEquals((String)((Property)headers200.get("foo")).getDescription(), (String)"description");
        Assert.assertEquals((String)((Property)headers200.get("foo")).getType(), (String)"string");
        Map headers400 = responses.get("400").getHeaders();
        Assert.assertEquals((int)headers400.size(), (int)2);
        Assert.assertEquals((String)((Property)headers400.get("X-Rack-Cache")).getDescription(), (String)"Explains whether or not a cache was used");
        Assert.assertEquals((String)((Property)headers400.get("X-Rack-Cache")).getType(), (String)"boolean");
        Iterator keyItr = headers400.keySet().iterator();
        Assert.assertEquals((String)((String)keyItr.next()), (String)"X-Rack-Cache");
        Assert.assertEquals((String)((String)keyItr.next()), (String)"X-After-Rack-Cache");
    }

    @Test(description="not scan a hidden resource")
    public void notScanHiddenResource() {
        Assert.assertNull((Object)this.getSwagger(HiddenResource.class).getPaths());
    }

    @Test(description="not scan a resource without @Api annotation")
    public void notScanNotValidRootResourcee() {
        Assert.assertNull((Object)this.getSwagger(NotValidRootResource.class).getPaths());
    }

    @Test(description="correctly model an empty model per 499")
    public void scanResourceWithEmptyModel() {
        Map definitions = this.getSwagger(ResourceWithEmptyModel.class).getDefinitions();
        Assert.assertEquals((int)definitions.size(), (int)1);
        ModelImpl empty = (ModelImpl)definitions.get("EmptyModel");
        Assert.assertEquals((String)empty.getType(), (String)"object");
        Assert.assertNull((Object)empty.getProperties());
        Assert.assertNull((Object)empty.getAdditionalProperties(), null);
    }

    @Test(description="scan a simple resource without annotations")
    public void scanSimpleResourceWithoutAnnotations() {
        DefaultReaderConfig config = new DefaultReaderConfig();
        config.setScanAllResources(true);
        Swagger swagger = new Reader(new Swagger(), (ReaderConfig)config).read(SimpleResourceWithoutAnnotations.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)2);
        Operation get = this.getGet(swagger, "/{id}");
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((int)get.getParameters().size(), (int)2);
        PathParameter param1 = (PathParameter)get.getParameters().get(0);
        Assert.assertEquals((String)param1.getIn(), (String)"path");
        Assert.assertEquals((String)param1.getName(), (String)"id");
        Assert.assertTrue((boolean)param1.getRequired());
        Assert.assertNull((Object)param1.getDescription());
        Assert.assertEquals((Object)param1.getDefaultValue(), (Object)"5");
        Parameter param2 = (Parameter)get.getParameters().get(1);
        Assert.assertEquals((String)param2.getIn(), (String)"query");
        Assert.assertEquals((String)param2.getName(), (String)"limit");
        Assert.assertFalse((boolean)param2.getRequired());
        Assert.assertNull((Object)param2.getDescription());
    }

    @Test(description="scan a simple self-referencing subresource")
    public void scanSimpleSelfReferencingSubResource() {
        DefaultReaderConfig config = new DefaultReaderConfig();
        config.setScanAllResources(true);
        Swagger swagger = new Reader(new Swagger(), (ReaderConfig)config).read(SimpleSelfReferencingSubResource.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)4);
        Operation retrieve = this.getGet(swagger, "/sub");
        Assert.assertNotNull((Object)retrieve);
        Assert.assertEquals((int)retrieve.getParameters().size(), (int)0);
        retrieve = this.getGet(swagger, "/sub/leaf");
        Assert.assertNotNull((Object)retrieve);
        Assert.assertEquals((int)retrieve.getParameters().size(), (int)0);
        retrieve = this.getGet(swagger, "/sub/recurse2");
        Assert.assertNotNull((Object)retrieve);
        Assert.assertEquals((int)retrieve.getParameters().size(), (int)0);
        retrieve = this.getGet(swagger, "/sub/recurse2/leaf");
        Assert.assertNotNull((Object)retrieve);
        Assert.assertEquals((int)retrieve.getParameters().size(), (int)0);
    }

    @Test(description="scan resource with ApiOperation.code() value")
    public void scanResourceWithApiOperationCodeValue() {
        Swagger swagger = this.getSwagger(ResourceWithApiOperationCode.class);
        Map<String, Response> responses1 = this.getGetResponses(swagger, "/{id}");
        Assert.assertEquals((int)responses1.size(), (int)3);
        Assert.assertTrue((boolean)responses1.containsKey("202"));
        Assert.assertFalse((boolean)responses1.containsKey("200"));
        Assert.assertEquals((String)responses1.get("202").getDescription(), (String)"successful operation");
        Map<String, Response> responses2 = this.getPutResponses(swagger, "/{id}");
        Assert.assertEquals((int)responses2.size(), (int)3);
        Assert.assertTrue((boolean)responses2.containsKey("200"));
        Assert.assertEquals((String)responses2.get("200").getDescription(), (String)"successful operation");
    }

    @Test(description="scan resource with ApiResponse.responseContainer() value")
    public void scanResourceWithApiResponseResponseContainerValue() {
        Swagger swagger = this.getSwagger(ResourceWithApiResponseResponseContainer.class);
        Path paths = (Path)swagger.getPaths().get("/{id}");
        Responses responses1 = paths.getGet().getResponsesObject();
        Assert.assertEquals(((Response)responses1.get("200")).getResponseSchema().getClass(), ModelImpl.class);
        Assert.assertTrue((((ModelImpl)((Response)responses1.get("200")).getResponseSchema()).getAdditionalProperties() != null ? 1 : 0) != 0);
        Assert.assertEquals(((Response)responses1.get("400")).getResponseSchema().getClass(), ArrayModel.class);
        Responses responses2 = paths.getPut().getResponsesObject();
        Assert.assertEquals(((Response)responses2.get("201")).getResponseSchema().getClass(), RefModel.class);
        Assert.assertEquals(((Response)responses2.get("401")).getResponseSchema().getClass(), ArrayModel.class);
        Responses responses3 = paths.getPost().getResponsesObject();
        Assert.assertEquals(((Response)responses3.get("202")).getResponseSchema().getClass(), RefModel.class);
        Assert.assertEquals(((Response)responses3.get("402")).getResponseSchema().getClass(), RefModel.class);
        Responses responses4 = paths.getDelete().getResponsesObject();
        Assert.assertEquals(((Response)responses4.get("203")).getResponseSchema().getClass(), RefModel.class);
        Assert.assertEquals(((Response)responses4.get("403")).getResponseSchema().getClass(), RefModel.class);
        Path paths2 = (Path)swagger.getPaths().get("/{id}/name");
        Responses responses5 = paths2.getGet().getResponsesObject();
        Assert.assertEquals(((Response)responses5.get("203")).getResponseSchema().getClass(), ArrayModel.class);
        Assert.assertNull((Object)((ArrayModel)((Response)responses5.get("203")).getResponseSchema()).getUniqueItems());
        Assert.assertNotEquals(((Property)((Response)responses5.get("203")).getHeaders().get("foo")).getClass(), MapProperty.class);
        Assert.assertEquals(((Response)responses5.get("403")).getResponseSchema().getClass(), ArrayModel.class);
        Assert.assertEquals((Boolean)((ArrayModel)((Response)responses5.get("403")).getResponseSchema()).getUniqueItems(), (Boolean)Boolean.TRUE);
        Responses responses6 = paths2.getPut().getResponsesObject();
        Assert.assertEquals(((Response)responses6.get("203")).getResponseSchema().getClass(), ArrayModel.class);
        Assert.assertEquals((Boolean)((ArrayModel)((Response)responses6.get("203")).getResponseSchema()).getUniqueItems(), (Boolean)Boolean.TRUE);
        Assert.assertEquals(((Property)((Response)responses6.get("203")).getHeaders().get("foo")).getClass(), ArrayProperty.class);
        Assert.assertEquals((Boolean)((ArrayProperty)((Response)responses6.get("203")).getHeaders().get("foo")).getUniqueItems(), (Boolean)Boolean.TRUE);
        Assert.assertEquals(((Response)responses6.get("403")).getResponseSchema().getClass(), ArrayModel.class);
    }

    @Test(description="scan a resource with inner class")
    public void scanResourceWithInnerClass() {
        Swagger swagger = this.getSwagger(ResourceWithInnerClass.class);
        Assert.assertEquals((String)((RefProperty)((ArrayModel)this.getGetResponses(swagger, "/description").get("200").getResponseSchema()).getItems()).get$ref(), (String)"#/definitions/Description");
        Assert.assertTrue((boolean)swagger.getDefinitions().containsKey("Description"));
    }

    @Test(description="scan defaultValue and required per #937")
    public void scanDefaultValueAndRequiredOptions() {
        Swagger swagger = this.getSwagger(Resource937.class);
        QueryParameter param = (QueryParameter)this.getGetParameters(swagger, "/external/info").get(0);
        Assert.assertFalse((boolean)param.getRequired());
        Assert.assertEquals((Object)param.getDefaultValue(), (Object)"dogs");
    }

    @Test(description="scan a resource with all hidden values #1073")
    public void scanResourceWithAllHiddenValues() {
        Assert.assertNull((Object)this.getSwagger(Resource1073.class).getPaths());
    }

    @Test(description="scan a resource with body parameters")
    public void scanResourceWithBodyParameters() {
        Swagger swagger = this.getSwagger(ResourceWithBodyParams.class);
        BodyParameter param = (BodyParameter)this.getPostParameters(swagger, "/testShort").get(0);
        Assert.assertEquals((String)param.getDescription(), (String)"a short input");
        ModelImpl schema = (ModelImpl)param.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"integer");
        Assert.assertEquals((String)schema.getFormat(), (String)"int32");
        Assert.assertEquals(swagger.getDefinitions().keySet(), Arrays.asList("Tag"));
        this.testString(swagger, "/testApiString", "input", "String parameter");
        this.testString(swagger, "/testString", "body", null);
        this.testObject(swagger, "/testApiObject", "input", "Object parameter");
        this.testObject(swagger, "/testObject", "body", null);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Path path : swagger.getPaths().values()) {
            Operation op = path.getPost();
            if (!op.getOperationId().startsWith("testPrimitive")) continue;
            operations.add(op);
        }
        Assert.assertEquals((int)operations.size(), (int)16);
        for (Operation operation : operations) {
            Assert.assertEquals((int)operation.getParameters().size(), (int)1);
        }
    }

    private Model testParam(Swagger swagger, String path, String name, String description) {
        BodyParameter param = (BodyParameter)this.getPostParameters(swagger, path).get(0);
        Assert.assertEquals((String)param.getIn(), (String)"body");
        Assert.assertEquals((String)param.getName(), (String)name);
        Assert.assertEquals((String)param.getDescription(), (String)description);
        return param.getSchema();
    }

    private void testString(Swagger swagger, String path, String name, String description) {
        Assert.assertEquals((String)((ModelImpl)this.testParam(swagger, path, name, description)).getType(), (String)"string");
    }

    private void testObject(Swagger swagger, String path, String name, String description) {
        Assert.assertEquals((String)((RefModel)this.testParam(swagger, path, name, description)).getSimpleRef(), (String)"Tag");
    }

    @Test(description="verify top-level path params per #1085")
    public void verifyTopLevelPathParams() {
        Swagger swagger = this.getSwagger(Resource1085.class);
        Parameter param = this.getGetParameters(swagger, "/external/info/{id}").get(0);
        Assert.assertEquals((String)param.getName(), (String)"id");
        Assert.assertTrue((boolean)(param instanceof PathParameter));
    }

    @Test(description="verify top-level auth #1041")
    public void verifyTopLevelAuthorization() {
        Swagger swagger = this.getSwagger(Resource1041.class);
        Operation path1 = this.getGet(swagger, "/external/info/path1");
        List security1 = path1.getSecurity();
        Assert.assertEquals((int)security1.size(), (int)1);
        Assert.assertNotNull(((Map)security1.get(0)).get("my_auth"));
        Operation path2 = this.getGet(swagger, "/external/info/path2");
        List security2 = path2.getSecurity();
        Assert.assertEquals((int)security2.size(), (int)1);
        Assert.assertNotNull(((Map)security2.get(0)).get("your_auth"));
    }

    @Test(description="check response models processing")
    public void checkResponseModelsProcessing() {
        Swagger swagger = this.getSwagger(ResourceWithTypedResponses.class);
        Assert.assertEquals(swagger.getDefinitions().keySet(), Arrays.asList("Tag"));
        for (Map.Entry entry : swagger.getPaths().entrySet()) {
            String name = ((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf("/") + 1);
            if ("testPrimitiveResponses".equals(name)) {
                ImmutableMap expected = ImmutableMap.of((Object)"400", (Object)new String[]{"string", "uri"}, (Object)"401", (Object)new String[]{"string", "url"}, (Object)"402", (Object)new String[]{"string", "uuid"}, (Object)"403", (Object)new String[]{"integer", "int64"}, (Object)"404", (Object)new String[]{"string", null});
                Assert.assertEquals((int)((Path)entry.getValue()).getGet().getResponsesObject().size(), (int)expected.size());
                for (Map.Entry responseEntry : ((Path)entry.getValue()).getGet().getResponsesObject().entrySet()) {
                    String[] expectedProp = (String[])expected.get(responseEntry.getKey());
                    Model model = ((Response)responseEntry.getValue()).getResponseSchema();
                    ModelImpl modelImpl = (ModelImpl)model;
                    Assert.assertEquals((String)modelImpl.getType(), (String)expectedProp[0]);
                    Assert.assertEquals((String)modelImpl.getFormat(), (String)expectedProp[1]);
                }
                continue;
            }
            Operation op = ((Path)entry.getValue()).getGet();
            Model response = ((Response)op.getResponsesObject().get((Object)"200")).getResponseSchema();
            Model model = ((BodyParameter)op.getParameters().get(0)).getSchema();
            Assert.assertEquals((int)op.getParameters().size(), (int)1);
            if ("testObjectResponse".equals(name)) {
                Assert.assertEquals((String)((RefModel)response).getSimpleRef(), (String)"Tag");
                Assert.assertEquals((String)((RefModel)model).getSimpleRef(), (String)"Tag");
                continue;
            }
            if ("testObjectsResponse".equals(name)) {
                Assert.assertEquals((String)((RefProperty)((ArrayModel)response).getItems()).getSimpleRef(), (String)"Tag");
                Assert.assertEquals((String)((RefProperty)((ArrayModel)model).getItems()).getSimpleRef(), (String)"Tag");
                continue;
            }
            if ("testStringResponse".equals(name)) {
                Assert.assertEquals(response.getClass(), ModelImpl.class);
                Assert.assertEquals((String)((ModelImpl)model).getType(), (String)"string");
                continue;
            }
            if ("testStringsResponse".equals(name)) {
                Assert.assertEquals(((ArrayModel)response).getItems().getClass(), StringProperty.class);
                Assert.assertEquals(((ArrayModel)model).getItems().getClass(), StringProperty.class);
                continue;
            }
            if ("testMapResponse".equals(name)) {
                Assert.assertEquals((String)((RefProperty)((ModelImpl)response).getAdditionalProperties()).getSimpleRef(), (String)"Tag");
                Assert.assertNull((Object)model.getProperties());
                Assert.assertEquals((String)((RefProperty)((ModelImpl)model).getAdditionalProperties()).getSimpleRef(), (String)"Tag");
                continue;
            }
            Assert.fail((String)String.format("Unexpected property: %s", name));
        }
    }

    @Test(description="test response examples")
    public void testResponseExamples() {
        Swagger swagger = this.getSwagger(ResourceWithResponseExamples.class);
        for (Map.Entry entry : swagger.getPaths().entrySet()) {
            String name = ((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf("/") + 1);
            if (!"testPrimitiveResponses".equals(name)) continue;
            ImmutableMap expected = ImmutableMap.of((Object)"404", (Object)new String[]{"string", null});
            Assert.assertEquals((int)((Path)entry.getValue()).getGet().getResponsesObject().size(), (int)expected.size());
            for (Map.Entry responseEntry : ((Path)entry.getValue()).getGet().getResponsesObject().entrySet()) {
                String[] expectedProp = (String[])expected.get(responseEntry.getKey());
                Model model = ((Response)responseEntry.getValue()).getResponseSchema();
                ModelImpl modelImpl = (ModelImpl)model;
                Assert.assertEquals((String)modelImpl.getType(), (String)expectedProp[0]);
                Assert.assertEquals((String)modelImpl.getFormat(), (String)expectedProp[1]);
                Response response = (Response)responseEntry.getValue();
                Assert.assertEquals((int)response.getExamples().size(), (int)2);
                Assert.assertEquals((String)response.getExamples().get("*/*").toString(), (String)"message example 1");
                Assert.assertEquals((String)response.getExamples().get("application/json").toString(), (String)"message example 2");
            }
        }
    }

    @Test(description="scan a resource with custom operation nickname")
    public void scanResourceWithApiOperationNickname() {
        Swagger swagger = this.getSwagger(NicknamedOperation.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)1);
        Assert.assertNotNull(swagger.getPaths().get("/external/info"));
        Operation op = ((Path)swagger.getPaths().get("/external/info")).getGet();
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((String)op.getOperationId(), (String)"getMyNicknameTest");
    }

    @Test(description="scan a resource with operation post example")
    public void scanClassWithExamplePost() {
        Swagger swagger = this.getSwagger(ClassWithExamplePost.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info")).getPost().getParameters().get(0);
        BodyParameter bp = (BodyParameter)param;
        Assert.assertNotNull((Object)bp.getExamples());
        Assert.assertTrue((bp.getExamples().size() == 1 ? 1 : 0) != 0);
        String value = (String)bp.getExamples().get("application/json");
        Assert.assertEquals((String)"[\"a\",\"b\"]", (String)value);
    }

    @Test(description="scan a resource with operation implicit post example")
    public void scanClassWithImplicitExamplePost() {
        Swagger swagger = this.getSwagger(ClassWithExamplePost.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info2")).getPost().getParameters().get(0);
        BodyParameter bp = (BodyParameter)param;
        Assert.assertNotNull((Object)bp.getExamples());
        Assert.assertTrue((bp.getExamples().size() == 1 ? 1 : 0) != 0);
        String value = (String)bp.getExamples().get("application/json");
        Assert.assertEquals((String)"[\"a\",\"b\"]", (String)value);
    }

    @Test(description="scan a resource with query param example")
    public void scanClassWithExampleQuery() {
        Swagger swagger = this.getSwagger(ClassWithExamplePost.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info")).getGet().getParameters().get(0);
        QueryParameter bp = (QueryParameter)param;
        Assert.assertNotNull((Object)bp.getExample());
        Object value = bp.getExample();
        Assert.assertEquals((Object)"a,b,c", (Object)value);
    }

    @Test(description="scan a resource with implicit operation query example")
    public void scanClassWithImplicitExampleQuery() {
        Swagger swagger = this.getSwagger(ClassWithExamplePost.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info2")).getGet().getParameters().get(0);
        QueryParameter bp = (QueryParameter)param;
        Assert.assertNotNull((Object)bp.getExample());
        Object value = bp.getExample();
        Assert.assertEquals((Object)"77", (Object)value);
    }

    @Test(description="scan a resource with operation post example (dataTypeClass)")
    public void scanClassWithExamplePostClass() {
        Swagger swagger = this.getSwagger(ClassWithExamplePostClass.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info")).getPost().getParameters().get(0);
        BodyParameter bp = (BodyParameter)param;
        Assert.assertNotNull((Object)bp.getExamples());
        Assert.assertTrue((bp.getExamples().size() == 1 ? 1 : 0) != 0);
        String value = (String)bp.getExamples().get("application/json");
        Assert.assertEquals((String)"[\"a\",\"b\"]", (String)value);
    }

    @Test(description="scan a resource with operation implicit post example (dataTypeClass)")
    public void scanClassWithImplicitExamplePostClass() {
        Swagger swagger = this.getSwagger(ClassWithExamplePostClass.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info2")).getPost().getParameters().get(0);
        BodyParameter bp = (BodyParameter)param;
        Assert.assertNotNull((Object)bp.getExamples());
        Assert.assertTrue((bp.getExamples().size() == 1 ? 1 : 0) != 0);
        String value = (String)bp.getExamples().get("application/json");
        Assert.assertEquals((String)"[\"a\",\"b\"]", (String)value);
    }

    @Test(description="scan a resource with query param example (dataTypeClass)")
    public void scanClassWithExampleClassQuery() {
        Swagger swagger = this.getSwagger(ClassWithExamplePostClass.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info")).getGet().getParameters().get(0);
        QueryParameter bp = (QueryParameter)param;
        Assert.assertNotNull((Object)bp.getExample());
        Object value = bp.getExample();
        Assert.assertEquals((Object)"a,b,c", (Object)value);
    }

    @Test(description="scan a resource with implicit operation query example (dataTypeClass)")
    public void scanClassWithImplicitExampleClassQuery() {
        Swagger swagger = this.getSwagger(ClassWithExamplePostClass.class);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/external/info2")).getGet().getParameters().get(0);
        QueryParameter bp = (QueryParameter)param;
        Assert.assertNotNull((Object)bp.getExample());
        Object value = bp.getExample();
        Assert.assertEquals((Object)"77", (Object)value);
    }

    @Test(description="scan a resource with read-only and empty value parameters")
    public void scanClassWithReadOnlyAndEmptyValueParams() {
        Swagger swagger = this.getSwagger(Issue1979Resource.class);
        Parameter readOnlyParam = (Parameter)swagger.getPath("/fun/readOnly").getGet().getParameters().get(0);
        Assert.assertTrue((boolean)readOnlyParam.isReadOnly());
        SerializableParameter allowEmptyParam = (SerializableParameter)swagger.getPath("/fun/allowEmpty").getGet().getParameters().get(0);
        Assert.assertTrue((boolean)allowEmptyParam.getAllowEmptyValue());
    }

    @Test
    public void testTicket3286() {
        Swagger swagger = this.getSwagger(Issue3286Resource.class);
        BodyParameter bodyParam = (BodyParameter)swagger.getPath("/fun/{id}").getPost().getParameters().get(1);
        Assert.assertEquals((String)bodyParam.getSchema().getReference(), (String)"#/definitions/BookRequest");
        Assert.assertEquals((String)((Response)swagger.getPath("/fun/{id}").getPost().getResponses().get("200")).getResponseSchema().getReference(), (String)"#/definitions/BookResponse");
        Assert.assertTrue((boolean)swagger.getDefinitions().containsKey("BookRequest"));
        Assert.assertTrue((boolean)swagger.getDefinitions().containsKey("BookResponse"));
    }
}

