/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.resources.SimpleResourceWithVendorAnnotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleScannerWithDecoratorExtensionTest {
    private static final String RESPONSE_DESCRIPTION = "Some vendor error description";
    private static final String RESPONSE_STATUS_401 = "401";
    private static final SwaggerExtension customExtension = new AbstractSwaggerExtension(){

        public void decorateOperation(Operation operation, Method method, Iterator<SwaggerExtension> chain) {
            method.getDeclaredAnnotations();
            SimpleResourceWithVendorAnnotation.VendorFunnyAnnotation myFunyError = method.getAnnotation(SimpleResourceWithVendorAnnotation.VendorFunnyAnnotation.class);
            if (myFunyError != null) {
                Response value = new Response();
                value.setDescription(SimpleScannerWithDecoratorExtensionTest.RESPONSE_DESCRIPTION);
                operation.getResponsesObject().put((Object)SimpleScannerWithDecoratorExtensionTest.RESPONSE_STATUS_401, (Object)value);
            }
        }
    };

    private Swagger getSwagger(Class<?> cls) {
        return new Reader(new Swagger()).read(cls);
    }

    private Operation getGet(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getGet();
    }

    @BeforeMethod
    public void addCustomExtension() {
        SwaggerExtensions.getExtensions().add(customExtension);
    }

    @AfterMethod
    public void removeCustomExtension() {
        SwaggerExtensions.getExtensions().remove(customExtension);
    }

    @Test(description="scan a simple resource with custom decorator")
    public void scanSimpleResourceWithDecorator() {
        Swagger swagger = this.getSwagger(SimpleResourceWithVendorAnnotation.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)2);
        Operation get = this.getGet(swagger, "/{id}");
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((int)get.getParameters().size(), (int)2);
        Response response = (Response)get.getResponsesObject().get((Object)RESPONSE_STATUS_401);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)response.getDescription(), (String)RESPONSE_DESCRIPTION);
    }

    @Test(description="scan a simple resource without custom decorator")
    public void scanSimpleResourceWithoutDecorator() {
        Swagger swagger = this.getSwagger(SimpleResourceWithVendorAnnotation.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)2);
        Operation get = this.getGet(swagger, "/{id}/value");
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((int)get.getParameters().size(), (int)0);
        Response response = (Response)get.getResponsesObject().get((Object)RESPONSE_STATUS_401);
        Assert.assertNull((Object)response);
    }
}

