/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.resources.Resource942;
import io.swagger.resources.ResourceWithSubResources;
import io.swagger.resources.SubResourceHead;
import io.swagger.resources.TestResource;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubResourceReaderTest {
    @Test(description="scan a resource with subresources")
    public void readResourceWithSubresources() {
        Swagger swagger = this.getSwagger(ResourceWithSubResources.class);
        Assert.assertEquals((String)this.getOperationId(swagger, "/employees/{id}"), (String)"getAllEmployees");
        Assert.assertEquals((String)this.getOperationId(swagger, "/employees/{id}/{id}"), (String)"getSubresourceOperation");
        Assert.assertEquals((String)this.getOperationId(swagger, "/employees/noPath"), (String)"getGreeting");
    }

    @Test(description="scan another resource with subresources")
    public void readAnotherResourceWithSubresources() {
        Swagger swagger = this.getSwagger(TestResource.class);
        Operation get = this.getGet(swagger, "/test/more/otherStatus");
        Assert.assertEquals((String)get.getOperationId(), (String)"otherStatus");
        Parameter qp = (Parameter)get.getParameters().get(0);
        Assert.assertEquals((String)qp.getIn(), (String)"query");
        Assert.assertEquals((String)qp.getName(), (String)"qp");
        Assert.assertTrue((boolean)get.getProduces().containsAll(Arrays.asList("application/json", "application/xml")));
        Assert.assertEquals((int)swagger.getPaths().keySet().size(), (int)2);
    }

    @Test(description="scan resource with class-based sub-resources")
    public void readResourceWithClassBasedSubresources() {
        Swagger swagger = this.getSwagger(SubResourceHead.class);
        Assert.assertEquals((int)swagger.getPaths().size(), (int)3);
        Assert.assertTrue((this.getOperationId(swagger, "/head/noPath").equals("getGreeting") || this.getOperationId(swagger, "/head/noPath").equals("getGreeting_1") ? 1 : 0) != 0);
        Assert.assertTrue((this.getOperationId(swagger, "/head/tail/hello").equals("getGreeting") || this.getOperationId(swagger, "/head/tail/hello").equals("getGreeting_1") ? 1 : 0) != 0);
        Operation echo = this.getGet(swagger, "/head/tail/{string}");
        Assert.assertEquals((String)echo.getOperationId(), (String)"getEcho");
        Assert.assertEquals((int)echo.getParameters().size(), (int)1);
    }

    @Test(description="find a body param")
    public void findBodyParam() {
        Swagger swagger = this.getSwagger(Resource942.class);
        Assert.assertTrue((boolean)(swagger.getPath("/test").getPost().getParameters().get(0) instanceof BodyParameter));
    }

    private Swagger getSwagger(Class<?> cls) {
        return new Reader(new Swagger()).read(cls);
    }

    private Operation getGet(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getGet();
    }

    private String getOperationId(Swagger swagger, String path) {
        return this.getGet(swagger, path).getOperationId();
    }
}

