/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.jaxrs.config.SwaggerConfigLocator;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import io.swagger.jaxrs.config.WebXMLReader;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SwaggerContextServiceTest {
    private ServletContext servletContext1;
    private ServletConfig servletConfig1;
    private ServletContext servletContext2;
    private ServletConfig servletConfig2;
    private Scanner beanConfigScanner1;
    private Scanner beanConfigScanner2;
    private Scanner jaxrsScanner;

    @BeforeMethod
    void initMock() {
        this.servletContext1 = (ServletContext)Mockito.mock(ServletContext.class);
        this.servletConfig1 = (ServletConfig)Mockito.mock(ServletConfig.class);
        this.servletContext2 = (ServletContext)Mockito.mock(ServletContext.class);
        this.servletConfig2 = (ServletConfig)Mockito.mock(ServletConfig.class);
        this.jaxrsScanner = new DefaultJaxrsScanner();
        BeanConfig bc = new BeanConfig();
        bc.setDescription("Bean Config test 1");
        this.beanConfigScanner1 = bc;
        bc = new BeanConfig();
        bc.setDescription("Bean Config test 2");
        this.beanConfigScanner2 = bc;
    }

    void stubWithPathBasedConfigInitParam() {
        Mockito.when((Object)this.servletContext1.getAttribute("swagger.scanner.id./url1")).thenReturn((Object)this.beanConfigScanner1);
        Mockito.when((Object)this.servletContext2.getAttribute("swagger.scanner.id./url2")).thenReturn((Object)this.beanConfigScanner2);
        Mockito.when((Object)this.servletConfig1.getServletContext()).thenReturn((Object)this.servletContext1);
        Mockito.when((Object)this.servletConfig2.getServletContext()).thenReturn((Object)this.servletContext2);
        Mockito.when((Object)this.servletConfig1.getInitParameter("swagger.use.path.based.config")).thenReturn((Object)"true");
        Mockito.when((Object)this.servletConfig2.getInitParameter("swagger.use.path.based.config")).thenReturn((Object)"true");
    }

    private void stubWithInitParam() {
        Mockito.when((Object)this.servletContext1.getAttribute("swagger.scanner.id.test.1")).thenReturn((Object)this.beanConfigScanner1);
        Mockito.when((Object)this.servletContext2.getAttribute("swagger.scanner.id.test.2")).thenReturn((Object)this.beanConfigScanner2);
        Mockito.when((Object)this.servletConfig1.getServletContext()).thenReturn((Object)this.servletContext1);
        Mockito.when((Object)this.servletConfig2.getServletContext()).thenReturn((Object)this.servletContext2);
        Mockito.when((Object)this.servletConfig1.getInitParameter("swagger.scanner.id")).thenReturn((Object)"test.1");
        Mockito.when((Object)this.servletConfig2.getInitParameter("swagger.scanner.id")).thenReturn((Object)"test.2");
        Mockito.when((Object)this.servletConfig1.getInitParameter("swagger.config.id")).thenReturn((Object)"test.1");
        Mockito.when((Object)this.servletConfig2.getInitParameter("swagger.config.id")).thenReturn((Object)"test.2");
    }

    private void stubWithContextInitParam() {
        Mockito.when((Object)this.servletContext1.getAttribute("swagger.scanner.id.test.1")).thenReturn((Object)this.beanConfigScanner1);
        Mockito.when((Object)this.servletContext2.getAttribute("swagger.scanner.id.test.2")).thenReturn((Object)this.beanConfigScanner2);
        Mockito.when((Object)this.servletConfig1.getServletContext()).thenReturn((Object)this.servletContext1);
        Mockito.when((Object)this.servletConfig2.getServletContext()).thenReturn((Object)this.servletContext2);
        Mockito.when((Object)this.servletConfig1.getInitParameter("swagger.context.id")).thenReturn((Object)"test.1");
        Mockito.when((Object)this.servletConfig2.getInitParameter("swagger.context.id")).thenReturn((Object)"test.2");
    }

    private void stubWithoutInitParam() {
        Mockito.when((Object)this.servletContext1.getAttribute("swagger.scanner.id.default")).thenReturn((Object)this.jaxrsScanner);
        Mockito.when((Object)this.servletContext2.getAttribute("swagger.scanner.id.default")).thenReturn((Object)this.jaxrsScanner);
        Mockito.when((Object)this.servletConfig1.getServletContext()).thenReturn((Object)this.servletContext1);
        Mockito.when((Object)this.servletConfig2.getServletContext()).thenReturn((Object)this.servletContext2);
    }

    @Test(description="should add servletContext attributes SCANNER_ID_PREFIX + \"test.1/2")
    public void initializeScannerWithInitParam() {
        this.stubWithInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initScanner();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initScanner();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
    }

    @Test(description="should call servletContext getAttribute with param SCANNER_ID_PREFIX + \"test.1/2\"")
    public void getScannerWithInitParam() {
        this.stubWithInitParam();
        Scanner scanner1 = new SwaggerContextService().withServletConfig(this.servletConfig1).getScanner();
        Scanner scanner2 = new SwaggerContextService().withServletConfig(this.servletConfig2).getScanner();
        Assert.assertEquals((Object)this.beanConfigScanner1, (Object)scanner1);
        Assert.assertEquals((Object)this.beanConfigScanner2, (Object)scanner2);
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.times((int)1))).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.times((int)1))).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"));
    }

    @Test(description="should add servletContext attributes SCANNER_ID_PREFIX + \"test.1/2")
    public void initializeScannerWithContextInitParam() {
        this.stubWithContextInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initScanner();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initScanner();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
    }

    @Test(description="should call servletContext getAttribute with param SCANNER_ID_PREFIX + \"test.1/2\"")
    public void getScannerWithContextInitParam() {
        this.stubWithContextInitParam();
        Scanner scanner1 = new SwaggerContextService().withServletConfig(this.servletConfig1).getScanner();
        Scanner scanner2 = new SwaggerContextService().withServletConfig(this.servletConfig2).getScanner();
        Assert.assertEquals((Object)this.beanConfigScanner1, (Object)scanner1);
        Assert.assertEquals((Object)this.beanConfigScanner2, (Object)scanner2);
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.times((int)1))).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.times((int)1))).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).getAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"));
    }

    @Test(description="should add servletContext attributes SCANNER_ID_DEFAULT")
    public void initializeAndGetScannerWithoutInitParam() {
        this.stubWithoutInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initScanner();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initScanner();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.default"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.default"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
    }

    @Test(description="should add scanner to ScannerFactory")
    public void initializeAndGetScannerWithoutServletConfig() {
        new SwaggerContextService().initScanner();
        new SwaggerContextService().initScanner();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.never())).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.default"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.never())).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.scanner.id"));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.default"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext2, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.2"), ArgumentMatchers.any(Scanner.class));
        ((ServletContext)Mockito.verify((Object)this.servletContext1, (VerificationMode)Mockito.never())).setAttribute((String)ArgumentMatchers.eq((Object)"swagger.scanner.id.test.1"), ArgumentMatchers.any(Scanner.class));
        Assert.assertNotNull((Object)ScannerFactory.getScanner());
        Assert.assertEquals((Object)new SwaggerContextService().getScanner(), (Object)SwaggerScannerLocator.getInstance().getScanner("swagger.scanner.id.default"));
    }

    @Test(description="should add SwaggerConfig to SwaggerConfigLocator map with key CONFIG_ID_PREFIX + \"test.1/2\"")
    public void initializeAndGetConfigWithInitParam() {
        this.stubWithInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initConfig();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initConfig();
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.test.1") instanceof WebXMLReader));
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.test.2") instanceof WebXMLReader));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
    }

    @Test(description="should add SwaggerConfig to SwaggerConfigLocator map with key CONFIG_ID_PREFIX + \"test.1/2\"")
    public void initializeAndGetConfigWithContextInitParam() {
        this.stubWithContextInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initConfig();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initConfig();
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.test.1") instanceof WebXMLReader));
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.test.2") instanceof WebXMLReader));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)2))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.context.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
    }

    @Test(description="should add SwaggerConfig to SwaggerConfigLocator map with key CONFIG_ID_DEFAULT")
    public void initializeAndGetConfigWithoutInitParam() {
        this.stubWithoutInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).initConfig();
        new SwaggerContextService().withServletConfig(this.servletConfig2).initConfig();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
    }

    @Test(description="should add SwaggerConfig to SwaggerConfigLocator map with key CONFIG_ID_DEFAULT")
    public void initializeAndGetConfigWithoutServletConfig() {
        new SwaggerContextService().initConfig();
        new SwaggerContextService().initConfig();
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.never())).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.never())).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.config.id"));
    }

    private void stubWithContextSwaggerAttribute() {
        Swagger swagger = new Swagger();
        Info info = new Info().title("Test Title");
        swagger.setInfo(info);
        Mockito.when((Object)this.servletContext1.getAttribute("swagger")).thenReturn((Object)swagger);
        Mockito.when((Object)this.servletConfig1.getServletContext()).thenReturn((Object)this.servletContext1);
        Mockito.when((Object)this.servletConfig2.getServletContext()).thenReturn((Object)this.servletContext2);
        Mockito.when((Object)this.servletConfig1.getInitParameter("swagger.context.id")).thenReturn((Object)"test.1");
        Mockito.when((Object)this.servletConfig2.getInitParameter("swagger.context.id")).thenReturn((Object)"test.2");
    }

    @Test(description="should get correct swagger context set via context param \"swagger\"")
    public void initConfigViaContextParamSwagger() {
        this.stubWithContextSwaggerAttribute();
        Swagger swagger = new SwaggerContextService().withServletConfig(this.servletConfig1).getSwagger();
        Assert.assertEquals((String)"Test Title", (String)swagger.getInfo().getTitle());
    }

    @Test(description="should add SwaggerConfig to SwaggerConfigLocator map with keys path-based keys")
    public void initializeAndGetConfigBasedOnPath() {
        this.stubWithPathBasedConfigInitParam();
        new SwaggerContextService().withServletConfig(this.servletConfig1).withBasePath("/url1").initConfig();
        new SwaggerContextService().withServletConfig(this.servletConfig2).withBasePath("url2").initConfig();
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id./url1/") instanceof WebXMLReader));
        Assert.assertTrue((boolean)(SwaggerConfigLocator.getInstance().getConfig("swagger.config.id./url2/") instanceof WebXMLReader));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig1, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.use.path.based.config"));
        ((ServletConfig)Mockito.verify((Object)this.servletConfig2, (VerificationMode)Mockito.times((int)1))).getInitParameter((String)ArgumentMatchers.eq((Object)"swagger.use.path.based.config"));
    }
}

