/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.functional.test.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/cars")
@Api(tags={"cars"}, description="Car operations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CarResource {
    @GET
    @Path(value="/summary")
    @JsonView(value={View.Summary.class})
    @ApiOperation(value="Return car summaries", response=Car.class, consumes="List")
    public Response getSummaries() {
        return Response.ok(Arrays.asList(new Car())).build();
    }

    @GET
    @Path(value="/detail")
    @JsonView(value={View.Detail.class})
    @ApiResponses(value={@ApiResponse(code=200, message="Return car detail", response=Car.class, responseContainer="List")})
    @ApiOperation(value="Return car detail")
    public List<Car> getDetails() {
        return Arrays.asList(new Car());
    }

    @GET
    @Path(value="/sale")
    @JsonView(value={View.Summary.class, View.Sale.class})
    @ApiOperation(value="Return car sale summary")
    public List<Car> getSaleSummaries() {
        return Arrays.asList(new Car());
    }

    @GET
    @Path(value="/all")
    @ApiResponses(value={@ApiResponse(code=200, message="Return whole car", response=Car.class, responseContainer="List")})
    @ApiOperation(value="Return whole car")
    public List<Car> getAll() {
        return Arrays.asList(new Car());
    }

    private static class Tire {
        @JsonView(value={View.Summary.class})
        @JsonProperty(value="brand")
        private String made = "Michelin";
        @JsonView(value={View.Detail.class})
        @JsonProperty
        private String condition = "new";

        private Tire() {
        }
    }

    private static class Car {
        @JsonView(value={View.Summary.class})
        @JsonProperty(value="manufacture")
        private String made = "Honda";
        @JsonView(value={View.Summary.class, View.Detail.class})
        private String model = "Accord Hybrid";
        @JsonView(value={View.Detail.class})
        @JsonProperty
        private List<Tire> tires = Arrays.asList(new Tire());
        @JsonView(value={View.Sale.class})
        @JsonProperty
        private int price = 40000;
        private String color = "White";

        private Car() {
        }

        public String getColor() {
            return this.color;
        }
    }

    private static class View {
        private View() {
        }

        static interface Sale {
        }

        static interface Detail
        extends Summary {
        }

        static interface Summary {
        }
    }
}

