/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.Test1InterfaceChildResource;
import io.swagger.jaxrs.Test1InterfaceParentResource;
import io.swagger.jaxrs.Test2ClassParentResource;
import io.swagger.jaxrs.Test2InterfaceChildResource;
import io.swagger.jaxrs.Test3ClassChildResource;
import io.swagger.jaxrs.Test3ClassParentResource;
import io.swagger.jaxrs.Test4ClassChildResource;
import io.swagger.jaxrs.Test4ClassParentResource;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReaderFixFor1959Test {
    @Test
    public void testParentAndChildInterface() {
        this.readAndCompare(new HashSet(Arrays.asList(Test1InterfaceParentResource.class, Test1InterfaceChildResource.class)), new HashSet<String>(Arrays.asList("getTestValue", "getTestValue_1")));
    }

    @Test
    public void testClassWithImplementedInterface() {
        this.readAndCompare(new HashSet(Arrays.asList(Test2InterfaceChildResource.class, Test2ClassParentResource.class)), new HashSet<String>(Arrays.asList("getTestValue", "getTestValue_1")));
    }

    @Test
    public void testParentAndChildClass() {
        this.readAndCompare(new HashSet(Arrays.asList(Test3ClassParentResource.class, Test3ClassChildResource.class)), new HashSet<String>(Arrays.asList("getTestValue", "getTestValue_1")));
    }

    @Test
    public void testParentAndChildInterfaceAndImplementingParentAndChildClass() {
        this.readAndCompare(new HashSet(Arrays.asList(Test1InterfaceParentResource.class, Test1InterfaceChildResource.class, Test4ClassParentResource.class, Test4ClassChildResource.class)), new HashSet<String>(Arrays.asList("getTestValue", "getTestValue_1", "getTestValue_2", "getTestValue_3")));
    }

    private void readAndCompare(Set<Class<?>> testClasses, Set<String> expectedOperationIds) {
        Swagger swagger = new Swagger();
        new Reader(swagger).read(testClasses);
        HashSet<String> actualOperationIds = new HashSet<String>();
        for (Path path : swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                actualOperationIds.add(operation.getOperationId());
            }
        }
        Assert.assertEquals(actualOperationIds, expectedOperationIds);
    }
}

