/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import io.swagger.jaxrs.Reader;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Map;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReaderTest {
    private Reader reader;
    @Mock
    private Swagger swagger;
    @Mock
    private Map<String, Path> paths;
    @Mock
    private Path path;
    @Mock
    private Operation operation;

    public ReaderTest() {
        MockitoAnnotations.initMocks((Object)this);
        this.reader = new Reader(this.swagger, null);
    }

    @Test(description="tests to check if duplicated operation id are being fixed.")
    public void duplicateOperationIdFix() {
        ArrayList<Path> mockedPaths = new ArrayList<Path>();
        mockedPaths.add(this.path);
        ArrayList<Operation> mockedOperations = new ArrayList<Operation>();
        mockedOperations.add(this.operation);
        Mockito.when((Object)this.swagger.getPaths()).thenReturn(this.paths);
        Mockito.when((Object)this.paths.isEmpty()).thenReturn((Object)false);
        Mockito.when(this.paths.values()).thenReturn(mockedPaths);
        Mockito.when((Object)this.path.getOperations()).thenReturn(mockedOperations);
        Mockito.when((Object)this.operation.getOperationId()).thenReturn((Object)"fixDuplicated");
        Assert.assertEquals((String)this.reader.getOperationId("fixDuplicated"), (String)"fixDuplicated_1");
        Assert.assertEquals((String)this.reader.getOperationId("newOne"), (String)"newOne");
        Mockito.when((Object)this.operation.getOperationId()).thenReturn((Object)"fixDuplicated").thenReturn((Object)"fixDuplicated_1").thenReturn((Object)"fixDuplicated_2").thenReturn((Object)"fixDuplicated_3").thenReturn((Object)"fixDuplicated_4");
        Assert.assertEquals((String)this.reader.getOperationId("fixDuplicated"), (String)"fixDuplicated_5");
        Mockito.when((Object)this.operation.getOperationId()).thenReturn((Object)"fixDuplicated").thenReturn((Object)"fixDuplicated_1").thenReturn((Object)"fixDuplicated_2").thenReturn((Object)"fixDuplicated_3").thenReturn((Object)"fixDuplicated_4").thenReturn((Object)"fixDuplicated_5").thenReturn((Object)"fixDuplicated_8");
        Assert.assertEquals((String)this.reader.getOperationId("fixDuplicated"), (String)"fixDuplicated_6");
    }
}

