/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.jaxrs2.ext.AbstractOpenAPIExtension;
import io.swagger.jaxrs2.ext.OpenAPIExtension;
import io.swagger.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class DefaultParameterExtension
extends AbstractOpenAPIExtension {
    private static String QUERY_PARAM = "query";
    private static String HEADER_PARAM = "header";
    private static String COOKIE_PARAM = "cookie";
    private static String PATH_PARAM = "path";
    private static String FORM_PARAM = "form";
    final ObjectMapper mapper = Json.mapper();

    @Override
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<OpenAPIExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            Parameter pp;
            QueryParam param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                Parameter qp = new Parameter();
                qp.setIn(QUERY_PARAM);
                qp.setName(param.value());
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                pp = new Parameter();
                pp.setIn(PATH_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                pp = new Parameter();
                pp.setIn(HEADER_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                pp = new Parameter();
                pp.setIn(COOKIE_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof FormParam) {
                param = (FormParam)annotation;
                pp = new Parameter();
                pp.setIn(FORM_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof io.swagger.oas.annotations.Parameter) {
                Parameter pp2;
                parameter = pp2 = new Parameter();
                continue;
            }
            this.handleAdditionalAnnotation(parameters, annotation, type, typesToSkip);
        }
        if (parameter != null) {
            parameters.add(parameter);
        }
        return parameters;
    }

    private void handleAdditionalAnnotation(List<Parameter> parameters, Annotation annotation, Type type, Set<Type> typesToSkip) {
        if (BeanParam.class.isAssignableFrom(annotation.getClass())) {
            BeanDescription beanDesc = this.mapper.getSerializationConfig().introspect(this.constructType(type));
            List properties = beanDesc.findProperties();
            for (BeanPropertyDefinition propDef : properties) {
                AnnotatedField field = propDef.getField();
                AnnotatedMethod setter = propDef.getSetter();
                AnnotatedMethod getter = propDef.getGetter();
                ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
                Iterator<OpenAPIExtension> extensions = OpenAPIExtensions.chain();
                Class paramType = null;
                if (field != null) {
                    paramType = field.getRawType();
                    for (Annotation fieldAnnotation : field.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (setter != null) {
                    if (paramType == null) {
                        paramType = setter.getRawParameterTypes() != null ? setter.getRawParameterTypes()[0] : null;
                    }
                    for (Annotation fieldAnnotation : setter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (getter != null) {
                    if (paramType == null) {
                        paramType = getter.getRawReturnType();
                    }
                    for (Annotation fieldAnnotation : getter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (paramType == null) continue;
                List<Parameter> extracted = extensions.next().extractParameters(paramAnnotations, paramType, typesToSkip, extensions);
                for (Parameter param : extracted) {
                    if (ParameterProcessor.applyAnnotations(null, (Parameter)param, (Type)paramType, paramAnnotations) == null) continue;
                    parameters.add(param);
                }
            }
        }
    }

    @Override
    protected boolean shouldIgnoreClass(Class<?> cls) {
        return cls.getName().startsWith("javax.ws.rs.");
    }
}

