/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration;

import io.swagger.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.jaxrs2.integration.ServletOpenApiContextBuilder;
import io.swagger.oas.integration.OpenApiConfigurationException;
import io.swagger.oas.integration.OpenApiContextLocator;
import io.swagger.oas.integration.api.OpenApiContext;
import io.swagger.oas.models.OpenAPI;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class OpenApiServlet
extends HttpServlet {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String ACCEPT_HEADER = "Accept";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig(config);
        try {
            new ServletOpenApiContextBuilder().servletConfig(config).ctxId(ctxId).buildContext(true);
        }
        catch (OpenApiConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig(this.getServletConfig());
        OpenApiContext ctx = OpenApiContextLocator.getInstance().getOpenApiContext(ctxId);
        OpenAPI oas = ctx.read();
        String type = "json";
        String acceptHeader = req.getHeader(ACCEPT_HEADER);
        if (!StringUtils.isBlank((CharSequence)acceptHeader) && acceptHeader.toLowerCase().contains(APPLICATION_YAML)) {
            type = "yaml";
        } else if (req.getRequestURL().toString().toLowerCase().endsWith("yaml")) {
            type = "yaml";
        }
        boolean pretty = false;
        if (ctx.getOpenApiConfiguration() != null && Boolean.TRUE.equals(ctx.getOpenApiConfiguration().isPrettyPrint())) {
            pretty = true;
        }
        resp.setStatus(200);
        if (type.equalsIgnoreCase("yaml")) {
            resp.setContentType(APPLICATION_YAML);
            PrintWriter pw = resp.getWriter();
            pw.write(pretty ? Yaml.pretty((Object)oas) : Yaml.mapper().writeValueAsString((Object)oas));
            pw.close();
        } else {
            resp.setContentType(APPLICATION_JSON);
            PrintWriter pw = resp.getWriter();
            pw.write(pretty ? Json.pretty((Object)oas) : Json.mapper().writeValueAsString((Object)oas));
            pw.close();
        }
    }
}

