/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jersey;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SwaggerJerseyJaxrs
extends AbstractSwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return Collections.emptyList();
        }
        for (Annotation annotation : annotations) {
            AbstractSerializableParameter param;
            if (!(annotation instanceof FormDataParam)) continue;
            FormDataParam fd = (FormDataParam)annotation;
            Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
            if (InputStream.class.isAssignableFrom(cls)) {
                param = ((FormParameter)new FormParameter().type("file")).name(fd.value());
            } else {
                FormParameter fp = (FormParameter)new FormParameter().name(fd.value());
                Property schema = ModelConverters.getInstance().readAsProperty(type);
                if (schema != null) {
                    fp.setProperty(schema);
                }
                param = fp;
            }
            return Collections.singletonList(param);
        }
        return super.extractParameters(annotations, type, typesToSkip, chain);
    }

    protected boolean shouldIgnoreClass(Class<?> cls) {
        for (Class item : Arrays.asList(FormDataContentDisposition.class, FormDataBodyPart.class)) {
            if (!item.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }
}

