/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.Api;
import io.swagger.jaxrs.Reader;
import io.swagger.models.ListOfStringsBeanParam;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BeanParamTest {
    @Test(description="check array type of serialized BeanParam containing QueryParams")
    public void shouldSerializeTypeParameter() {
        Swagger swagger = new Reader(new Swagger()).read(MyBeanParamResource.class);
        List getOperationParams = swagger.getPath("/").getGet().getParameters();
        Assert.assertEquals((int)getOperationParams.size(), (int)1);
        QueryParameter param = (QueryParameter)getOperationParams.get(0);
        Assert.assertEquals((String)param.getName(), (String)"listOfStrings");
        Assert.assertEquals((String)param.getType(), (String)"array");
        Property itemsProperty = param.getItems();
        Assert.assertEquals(itemsProperty.getClass(), StringProperty.class);
        Assert.assertEquals((String)itemsProperty.getType(), (String)"string");
    }

    @Api
    @Path(value="/")
    private static class MyBeanParamResource {
        private MyBeanParamResource() {
        }

        @GET
        public String getWithBeanParam(@BeanParam ListOfStringsBeanParam listOfStringsBean) {
            return "result";
        }
    }
}

