/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.resources.ResourceWithBeanParams;
import io.swagger.resources.ResourceWithComplexBodyInputType;
import io.swagger.resources.ResourceWithExtensions;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScannerTest {
    @Test(description="scan a simple resource")
    public void scanSimpleResource() {
        Swagger swagger = this.getSwagger(ResourceWithBeanParams.class);
        List<Parameter> params = this.getParameters(swagger, "/{id}");
        Parameter skip = params.get(0);
        Assert.assertEquals((String)skip.getName(), (String)"skip");
        Assert.assertEquals((String)skip.getDescription(), (String)"number of records to skip");
        Parameter limit = params.get(1);
        Assert.assertEquals((String)limit.getName(), (String)"limit");
        Assert.assertEquals((String)limit.getDescription(), (String)"maximum number of records to return");
    }

    @Test(description="scan another resource")
    public void scanAnotherResource() {
        Swagger swagger = this.getSwagger(ResourceWithComplexBodyInputType.class);
        Operation post = ((Path)swagger.getPaths().get("/myapi/testPostWithBody")).getPost();
        Assert.assertNotNull((Object)post);
        Assert.assertNotNull((Object)swagger.getDefinitions());
        Assert.assertNotNull(swagger.getDefinitions().get("ClassWithString"));
    }

    @Test(description="scan resource with extensions")
    public void scanResourceWithExtensions() throws JsonProcessingException {
        Swagger swagger = this.getSwagger(ResourceWithExtensions.class);
        Assert.assertNotNull((Object)swagger);
        Map infoExtensions = swagger.getInfo().getVendorExtensions();
        Assert.assertEquals((Object)"private", infoExtensions.get("x-accessLevel"));
        Map operationExtensions = swagger.getPath("/rest/test").getGet().getVendorExtensions();
        Assert.assertEquals((Object)"/hello-world/v1/", operationExtensions.get("x-externalPath"));
    }

    @Test(description="scan a bean param resource")
    public void scanBeanParamResource() {
        Swagger swagger = this.getSwagger(ResourceWithBeanParams.class);
        List<Parameter> params = this.getParameters(swagger, "/bean/{id}");
        HeaderParameter headerParam1 = (HeaderParameter)params.get(0);
        Assert.assertEquals((Object)headerParam1.getDefaultValue(), (Object)1);
        Assert.assertEquals((String)headerParam1.getName(), (String)"test order annotation 1");
        HeaderParameter headerParam2 = (HeaderParameter)params.get(1);
        Assert.assertEquals((Object)headerParam2.getDefaultValue(), (Object)2);
        Assert.assertEquals((String)headerParam2.getName(), (String)"test order annotation 2");
        QueryParameter priority1 = (QueryParameter)params.get(2);
        Assert.assertNull((Object)priority1.getDefaultValue());
        Assert.assertEquals((String)priority1.getName(), (String)"test priority 1");
        QueryParameter priority2 = (QueryParameter)params.get(3);
        Assert.assertEquals((Object)priority2.getDefaultValue(), (Object)4);
        Assert.assertEquals((String)priority2.getName(), (String)"test priority 2");
        ModelImpl bodyParam1 = (ModelImpl)((BodyParameter)params.get(4)).getSchema();
        Assert.assertEquals((Object)bodyParam1.getDefaultValue(), (Object)"bodyParam");
    }

    private List<Parameter> getParameters(Swagger swagger, String path) {
        return ((Path)swagger.getPaths().get(path)).getGet().getParameters();
    }

    private Swagger getSwagger(Class<?> clas) {
        DefaultReaderConfig config = new DefaultReaderConfig();
        config.setScanAllResources(true);
        return new Reader(new Swagger(), (ReaderConfig)config).read(clas);
    }
}

