/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import io.swagger.jaxrs.DefaultParameterExtension;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jersey.SwaggerJersey2Jaxrs;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.TestEnum;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.params.BaseBean;
import io.swagger.params.ChildBean;
import io.swagger.params.EnumBean;
import io.swagger.params.RefBean;
import io.swagger.resources.Resource2031;
import io.swagger.resources.ResourceWithFormData;
import io.swagger.resources.ResourceWithJacksonBean;
import io.swagger.resources.ResourceWithKnownInjections;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.internal.collections.Pair;

public class SwaggerJersey2JaxrsTest {
    void testRoute(@BeanParam BaseBean baseBean, @BeanParam ChildBean childBean, @BeanParam RefBean refBean, @BeanParam EnumBean enumBean, Integer nonBean) {
    }

    void testFormDataParamRoute(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
    }

    @Test(description="not skip all types passed to extension")
    public void testAllTypes() {
        for (Class cls : Arrays.asList(BaseBean.class, ChildBean.class, RefBean.class)) {
            HashSet typesToSkip = new HashSet();
            new SwaggerJersey2Jaxrs().extractParameters(new ArrayList(), (Type)cls, typesToSkip, SwaggerExtensions.chain());
            Assert.assertEquals((int)typesToSkip.size(), (int)0);
        }
    }

    @Test(description="return the proper @BeanParam Parameters based on the call to extractParameters")
    public void returnProperBeanParam() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("testRoute", BaseBean.class, ChildBean.class, RefBean.class, EnumBean.class, Integer.class);
        List<Pair<Type, Annotation[]>> parameters = this.getParameters(method.getGenericParameterTypes(), method.getParameterAnnotations());
        for (Pair<Type, Annotation[]> parameter : parameters) {
            Type parameterType = (Type)parameter.first();
            List swaggerParams = new SwaggerJersey2Jaxrs().extractParameters(Arrays.asList((Object[])parameter.second()), parameterType, new HashSet(), SwaggerExtensions.chain());
            if (parameterType.equals(BaseBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)2);
            } else if (parameterType.equals(ChildBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)5);
            } else if (parameterType.equals(RefBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)5);
            } else if (parameterType.equals(EnumBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)1);
                HeaderParameter enumParam = (HeaderParameter)swaggerParams.get(0);
                Assert.assertEquals((String)enumParam.getType(), (String)"string");
                HashSet enumValues = Sets.newHashSet((Iterable)Collections2.transform(Arrays.asList(TestEnum.values()), (Function)Functions.toStringFunction()));
                Assert.assertEquals((Collection)enumParam.getEnum(), (Collection)enumValues);
            } else if (parameterType.equals(Integer.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)0);
            } else {
                Assert.fail((String)String.format("Parameter of type %s was not expected", parameterType));
            }
            for (Parameter param : swaggerParams) {
                Assert.assertEquals((String)param.getName(), (String)param.getClass().getSimpleName().replace("eter", ""));
            }
        }
    }

    @Test(description="return the proper @BeanParam Parameters based on the call to DefaultParameterExtension.extractParameters")
    public void returnProperBeanParamWithDefaultParameterExtension() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("testRoute", BaseBean.class, ChildBean.class, RefBean.class, EnumBean.class, Integer.class);
        List<Pair<Type, Annotation[]>> parameters = this.getParameters(method.getGenericParameterTypes(), method.getParameterAnnotations());
        for (Pair<Type, Annotation[]> parameter : parameters) {
            Type parameterType = (Type)parameter.first();
            List swaggerParams = new DefaultParameterExtension().extractParameters(Arrays.asList((Object[])parameter.second()), parameterType, new HashSet(), SwaggerExtensions.chain());
            if (parameterType.equals(BaseBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)2);
            } else if (parameterType.equals(ChildBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)5);
            } else if (parameterType.equals(RefBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)5);
            } else if (parameterType.equals(EnumBean.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)1);
                HeaderParameter enumParam = (HeaderParameter)swaggerParams.get(0);
                Assert.assertEquals((String)enumParam.getType(), (String)"string");
                HashSet enumValues = Sets.newHashSet((Iterable)Collections2.transform(Arrays.asList(TestEnum.values()), (Function)Functions.toStringFunction()));
                Assert.assertEquals((Collection)enumParam.getEnum(), (Collection)enumValues);
            } else if (parameterType.equals(Integer.class)) {
                Assert.assertEquals((int)swaggerParams.size(), (int)0);
            } else {
                Assert.fail((String)String.format("Parameter of type %s was not expected", parameterType));
            }
            for (Parameter param : swaggerParams) {
                Assert.assertEquals((String)param.getName(), (String)param.getClass().getSimpleName().replace("eter", ""));
            }
        }
    }

    @Test(description="return the proper @FormDataParam Parameters based on the call to extractParameters")
    public void returnProperFormDataParam() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("testFormDataParamRoute", InputStream.class, FormDataContentDisposition.class);
        List<Pair<Type, Annotation[]>> parameters = this.getParameters(method.getGenericParameterTypes(), method.getParameterAnnotations());
        for (Pair<Type, Annotation[]> parameter : parameters) {
            Type parameterType = (Type)parameter.first();
            List swaggerParams = new SwaggerJersey2Jaxrs().extractParameters(Arrays.asList((Object[])parameter.second()), parameterType, new HashSet(), SwaggerExtensions.chain());
            if (parameterType.equals(InputStream.class)) {
                Assert.assertEquals((String)((FormParameter)swaggerParams.get(0)).getType(), (String)"file");
                continue;
            }
            Assert.assertEquals((int)swaggerParams.size(), (int)0);
        }
    }

    private List<Pair<Type, Annotation[]>> getParameters(Type[] type, Annotation[][] annotations) {
        Iterator<Type> typeIterator = Arrays.asList(type).iterator();
        Iterator paramIterator = Arrays.asList(annotations).iterator();
        ArrayList<Pair<Type, Annotation[]>> result = new ArrayList<Pair<Type, Annotation[]>>();
        while (paramIterator.hasNext() && typeIterator.hasNext()) {
            Pair pair = new Pair((Object)typeIterator.next(), paramIterator.next());
            result.add((Pair<Type, Annotation[]>)pair);
        }
        return result;
    }

    @Test(description="scan class level and field level annotations")
    public void scanClassAnfFieldLevelAnnotations() {
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithKnownInjections.class);
        List resourceParameters = ((Path)swagger.getPaths().get("/resource/{id}")).getGet().getParameters();
        Assert.assertNotNull((Object)resourceParameters);
        Assert.assertEquals((int)resourceParameters.size(), (int)4);
        Assert.assertEquals((String)this.getName(resourceParameters, 0), (String)"fieldParam");
        Assert.assertEquals((String)this.getName(resourceParameters, 1), (String)"skip");
        Assert.assertEquals((String)this.getName(resourceParameters, 2), (String)"limit");
        Assert.assertEquals((String)this.getName(resourceParameters, 3), (String)"methodParam");
    }

    @Test(description="FormDataBodyPart should be ignored when generating the Swagger document")
    public void testFormDataBodyPart() {
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithFormData.class);
        List parameters = swagger.getPath("/test/document/{documentName}.json").getPost().getParameters();
        Assert.assertEquals((int)parameters.size(), (int)3);
        Assert.assertEquals((String)((Parameter)parameters.get(0)).getName(), (String)"documentName");
        Assert.assertEquals((String)((Parameter)parameters.get(1)).getName(), (String)"input");
        Assert.assertEquals((String)((Parameter)parameters.get(2)).getName(), (String)"id");
    }

    @Test(description="JsonUnwrapped, JsonIgnore, JsonValue should be honoured")
    public void testJacksonFeatures() {
        Swagger swagger = new Reader(new Swagger()).read(ResourceWithJacksonBean.class);
        Model o = (Model)swagger.getDefinitions().get("JacksonBean");
        Assert.assertEquals(o.getProperties().keySet(), (Set)Sets.newHashSet((Object[])new String[]{"identity", "bean", "code", "message", "precodesuf", "premessagesuf"}));
    }

    @Test(description="Tests issue 2031")
    public void testIssue2031() {
        Swagger swagger = new Reader(new Swagger()).read(Resource2031.class);
        Assert.assertNotNull((Object)swagger);
    }

    private String getName(List<Parameter> resourceParameters, int i) {
        return resourceParameters.get(i).getName();
    }
}

